/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.TextEditorAction;

public abstract class BlockCommentAction
extends TextEditorAction {
    public String fDocumentPartitioning;

    public BlockCommentAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null || !this.ensureEditable(iTextEditor)) {
            return;
        }
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iDocumentProvider == null || iEditorInput == null) {
            return;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        if (iDocument == null) {
            return;
        }
        if (!(iDocument instanceof IDocumentExtension3)) {
            return;
        }
        IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
        ITextSelection iTextSelection = this.getCurrentSelection();
        if (!this.isValidSelection(iTextSelection, iDocumentExtension3)) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        IRewriteTarget iRewriteTarget = (IRewriteTarget)iTextEditor.getAdapter(IRewriteTarget.class);
        if (iRewriteTarget != null) {
            iRewriteTarget.beginCompoundChange();
        }
        try {
            try {
                this.runInternal(iTextSelection, iDocumentExtension3);
                return;
            }
            catch (BadLocationException badLocationException) {
                if (iRewriteTarget == null) return;
                iRewriteTarget.endCompoundChange();
                return;
            }
            catch (BadPartitioningException badPartitioningException) {
                Assert.isTrue((boolean)false, (String)"bad partitioning");
                if (iRewriteTarget == null) return;
                iRewriteTarget.endCompoundChange();
                return;
            }
        }
        finally {
            if (iRewriteTarget != null) {
                iRewriteTarget.endCompoundChange();
            }
        }
    }

    protected boolean ensureEditable(ITextEditor iTextEditor) {
        Assert.isNotNull((Object)iTextEditor);
        if (iTextEditor instanceof ITextEditorExtension2) {
            ITextEditorExtension2 iTextEditorExtension2 = (ITextEditorExtension2)iTextEditor;
            return iTextEditorExtension2.validateEditorInputState();
        }
        return iTextEditor.isEditable();
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (!this.canModifyEditor()) {
                this.setEnabled(false);
                return;
            }
            ITextEditor iTextEditor = this.getTextEditor();
            if (iTextEditor != null) {
                IDocumentExtension3 iDocumentExtension3;
                ITextSelection iTextSelection;
                IDocument iDocument;
                IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                IEditorInput iEditorInput = iTextEditor.getEditorInput();
                if (iDocumentProvider != null && iEditorInput != null && (iDocument = iDocumentProvider.getDocument((Object)iEditorInput)) != null && (iTextSelection = this.getCurrentSelection()) != null && !iTextSelection.isEmpty() && iDocument instanceof IDocumentExtension3 && !this.isValidSelection(iTextSelection, iDocumentExtension3 = (IDocumentExtension3)iDocument)) {
                    this.setEnabled(false);
                }
            }
        }
    }

    protected ITextSelection getCurrentSelection() {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor != null && (iSelectionProvider = iTextEditor.getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    protected abstract void runInternal(ITextSelection var1, IDocumentExtension3 var2) throws BadLocationException, BadPartitioningException;

    protected abstract boolean isValidSelection(ITextSelection var1, IDocumentExtension3 var2);

    protected String getCommentStart() {
        return "/*";
    }

    protected String getCommentEnd() {
        return "*/";
    }

    public void configure(ISourceViewer iSourceViewer, SourceViewerConfiguration sourceViewerConfiguration) {
        this.fDocumentPartitioning = sourceViewerConfiguration.getConfiguredDocumentPartitioning(iSourceViewer);
    }
}

