/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilter;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilterComposite;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeTableLabelProvider;
import org.eclipse.php.internal.ui.dialogs.openType.generic.BasicSelector;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenPhpElementDialog
extends Dialog {
    private PHPCodeData selectedElement = null;
    private BasicSelector basicSelector;
    private CodeData[] initialElements;
    private String initFilterText;
    private final PhpTypeFilter phpTypeFilter = new PhpTypeFilter();
    private String title;

    public OpenPhpElementDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public OpenPhpElementDialog(Shell shell, String string) {
        this(shell);
        this.title = string;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(500, 400, true);
    }

    public void setInitialElements(CodeData[] codeDataArray) {
        this.initialElements = codeDataArray;
    }

    public void setInitFilterText(String string) {
        this.initFilterText = string;
    }

    public PhpTypeFilter getFilter() {
        return this.phpTypeFilter;
    }

    protected Control createDialogArea(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.help.opening_php_elements");
        Composite composite2 = (Composite)super.createDialogArea(composite);
        CompositeFactory compositeFactory = new CompositeFactory(){

            public Composite createComposite(Composite composite) {
                return new PhpTypeFilterComposite(composite, OpenPhpElementDialog.this.phpTypeFilter, OpenPhpElementDialog.this.phpTypeFilter);
            }
        };
        this.basicSelector = new BasicSelector(composite2, compositeFactory);
        if (this.initFilterText != null) {
            this.basicSelector.setInitFilterText(this.initFilterText);
        }
        this.basicSelector.setLayoutData(new GridData(1808));
        this.basicSelector.addFilter(this.phpTypeFilter);
        this.basicSelector.setLabelProvider(new PhpTypeTableLabelProvider());
        this.basicSelector.setElements(this.getElements());
        this.basicSelector.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                OpenPhpElementDialog.this.okPressed();
            }
        });
        this.basicSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection().isEmpty()) {
                    OpenPhpElementDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                OpenPhpElementDialog.this.getButton(0).setEnabled(true);
            }
        });
        return composite2;
    }

    private Object[] getElements() {
        CodeData[] codeDataArray;
        block9: {
            IProject[] iProjectArray;
            codeDataArray = this.initialElements;
            if (codeDataArray != null) break block9;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            IProject[] iProjectArray2 = iProjectArray = PHPUiPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IProject iProject;
                    block8: {
                        iProject = iProjectArray2[n2];
                        try {
                            if (!iProject.exists() || !iProject.isOpen()) break block7;
                            if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) {
                            }
                            break block8;
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                        break block7;
                    }
                    PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
                    if (pHPProjectModel != null) {
                        IPhpModel[] iPhpModelArray = pHPProjectModel.getModels();
                        IPHPLanguageModel iPHPLanguageModel = pHPProjectModel.getPHPLanguageModel();
                        int n3 = 0;
                        while (n3 < iPhpModelArray.length) {
                            IPhpModel iPhpModel = iPhpModelArray[n3];
                            if (iPhpModel != iPHPLanguageModel) {
                                this.addData(iPhpModel.getClasses(), linkedHashSet);
                                this.addData(iPhpModel.getFunctions(), linkedHashSet);
                                this.addData(iPhpModel.getConstants(), linkedHashSet);
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            codeDataArray = linkedHashSet.toArray(new CodeData[linkedHashSet.size()]);
        }
        return this.sortAndremoveDuplicates(codeDataArray);
    }

    private Object[] sortAndremoveDuplicates(CodeData[] codeDataArray) {
        if (codeDataArray.length == 0) {
            return new Object[0];
        }
        Comparator<CodeData> comparator = new Comparator<CodeData>(){

            @Override
            public int compare(CodeData codeData, CodeData codeData2) {
                return codeData.toString().compareToIgnoreCase(codeData2.toString());
            }
        };
        Arrays.sort(codeDataArray, comparator);
        CodeData codeData = codeDataArray[0];
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        arrayList.add(codeData);
        CodeData[] codeDataArray2 = codeDataArray;
        int n = codeDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData2 = codeDataArray2[n2];
            if (!this.equals(codeData, codeData2)) {
                arrayList.add(codeData2);
            }
            codeData = codeData2;
            ++n2;
        }
        return arrayList.toArray();
    }

    private boolean equals(CodeData codeData, CodeData codeData2) {
        if (codeData.getClass() != codeData2.getClass()) {
            return false;
        }
        if (!codeData.getName().equalsIgnoreCase(codeData.getName())) {
            return false;
        }
        String string = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)codeData)).getName();
        String string2 = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)codeData2)).getName();
        return string.equals(string2);
    }

    private void addData(CodeData[] codeDataArray, Collection collection) {
        CodeData[] codeDataArray2 = codeDataArray;
        int n = codeDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData = codeDataArray2[n2];
            collection.add(codeData);
            ++n2;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title != null ? this.title : PHPUIMessages.getString("OpenType_DialogTitle"));
    }

    public PHPCodeData getSelectedElement() {
        return this.selectedElement;
    }

    protected void okPressed() {
        this.selectedElement = (PHPCodeData)this.basicSelector.getSelectedElement();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setEnabled(false);
    }

    public boolean close() {
        this.basicSelector.close();
        return super.close();
    }
}

