/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);

    public ResourceTransferDragAdapter(ISelectionProvider iSelectionProvider) {
        this.fProvider = iSelectionProvider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        List list = this.convertSelection();
        dragSourceEvent.data = list.toArray(new IResource[list.size()]);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        if (dragSourceEvent.detail == 2) {
            this.handleFinishedDropMove(dragSourceEvent);
        }
    }

    private List convertSelection() {
        ISelection iSelection = this.fProvider.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iStructuredSelection.size());
        for (Object e : iStructuredSelection) {
            IAdaptable iAdaptable;
            IResource iResource;
            if (!(e instanceof IAdaptable) || (iResource = (IResource)(iAdaptable = (IAdaptable)e).getAdapter(IResource.class)) == null) continue;
            arrayList.add(iResource);
        }
        return arrayList;
    }

    private void handleFinishedDropMove(DragSourceEvent dragSourceEvent) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.php.ui", 10001, "Cannot delete resources", null);
        List list = this.convertSelection();
        for (IResource iResource : list) {
            try {
                iResource.delete(true, null);
            }
            catch (CoreException coreException) {
                multiStatus.add(coreException.getStatus());
            }
        }
        if (multiStatus.getChildren().length > 0) {
            IResource iResource;
            Shell shell = SWTUtil.getShell(dragSourceEvent.widget);
            iResource = new ErrorDialog(shell, "Moving Resources with Drag and Drop", "Cannot delete the following file(s)", (IStatus)multiStatus, 4);
            iResource.open();
        }
    }
}

