/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;

public class PHPStructuredTextProjectionAnnotationHover
extends StructuredTextAnnotationHover
implements IAnnotationHoverExtension {
    private IInformationControlCreator fInformationControlCreator;

    public boolean canHandleMouseCursor() {
        return false;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInformationControlCreator == null) {
            this.fInformationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new PHPSourceViewerInformationControl(shell);
                }
            };
        }
        return this.fInformationControlCreator;
    }

    public Object getHoverInfo(ISourceViewer iSourceViewer, ILineRange iLineRange, int n) {
        return this.getProjectionTextAtLine(iSourceViewer, iLineRange.getStartLine(), n);
    }

    private String getProjectionTextAtLine(ISourceViewer iSourceViewer, int n, int n2) {
        IAnnotationModelExtension iAnnotationModelExtension;
        ISourceViewerExtension2 iSourceViewerExtension2;
        Object object;
        IAnnotationModel iAnnotationModel = null;
        if (iSourceViewer instanceof ISourceViewerExtension2 && (object = (iSourceViewerExtension2 = (ISourceViewerExtension2)iSourceViewer).getVisualAnnotationModel()) instanceof IAnnotationModelExtension) {
            iAnnotationModelExtension = (IAnnotationModelExtension)object;
            iAnnotationModel = iAnnotationModelExtension.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        if (iAnnotationModel != null) {
            try {
                iSourceViewerExtension2 = iSourceViewer.getDocument();
                object = iAnnotationModel.getAnnotationIterator();
                while (object.hasNext()) {
                    Position position;
                    iAnnotationModelExtension = (ProjectionAnnotation)object.next();
                    if (!iAnnotationModelExtension.isCollapsed() || (position = iAnnotationModel.getPosition((Annotation)iAnnotationModelExtension)) == null || !this.isCaptionLine((ProjectionAnnotation)iAnnotationModelExtension, position, (IDocument)iSourceViewerExtension2, n)) continue;
                    return this.getText((IDocument)iSourceViewerExtension2, position.getOffset(), position.getLength(), n2);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private String getText(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4 = n + n2;
        try {
            int n5 = iDocument.getLineOfOffset(n) + Math.max(0, n3 - 1);
            IRegion iRegion = iDocument.getLineInformation(n5);
            n4 = Math.min(n4, iRegion.getOffset() + iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return iDocument.get(n, n4 - n);
    }

    private boolean isCaptionLine(ProjectionAnnotation projectionAnnotation, Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = position instanceof IProjectionPosition ? ((IProjectionPosition)position).computeCaptionOffset(iDocument) : 0;
                int n3 = iDocument.getLineOfOffset(position.getOffset() + n2);
                return n == n3;
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public ILineRange getHoverLineRange(ISourceViewer iSourceViewer, int n) {
        return new LineRange(n, 1);
    }
}

