/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class PHPTemplateStore
extends ContributionTemplateStore {
    public PHPTemplateStore(ContextTypeRegistry contextTypeRegistry, IPreferenceStore iPreferenceStore, String string) {
        super(contextTypeRegistry, iPreferenceStore, string);
    }

    public void add(TemplatePersistenceData templatePersistenceData) {
        Template template = templatePersistenceData.getTemplate();
        if (template.getName().equals("")) {
            String string = PHPUIMessages.getString("PHPTemplateStore_error_title");
            String string2 = PHPUIMessages.getString("PHPTemplateStore_error_message_nameEmpty");
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)string, (String)string2);
            return;
        }
        super.add(templatePersistenceData);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template) {
        String string = null;
        int n = 0;
        if (template != null) {
            Document document = new Document();
            DocumentTemplateContext documentTemplateContext = new DocumentTemplateContext(contextTypeRegistry.getContextType(template.getContextTypeId()), (IDocument)document, 0, 0);
            try {
                TemplateBuffer templateBuffer = documentTemplateContext.evaluate(template);
                string = templateBuffer.getString();
                TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
                int n2 = 0;
                while (n2 != templateVariableArray.length) {
                    TemplateVariable templateVariable = templateVariableArray[n2];
                    if ("cursor".equals(templateVariable.getName())) {
                        n = templateVariable.getOffsets()[0];
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                Logger.log(202, "Could not create template for new PHP", exception);
            }
        }
        return new CompiledTemplate(string, n);
    }

    public static class CompiledTemplate {
        public final String string;
        public final int offset;

        public CompiledTemplate(String string, int n) {
            this.string = string;
            this.offset = n;
        }
    }
}

