/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.CustomFiltersActionGroup;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.StringMatcher;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.keys.KeySequence;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    protected StringMatcher fStringMatcher;
    private ICommand fInvokingCommand;
    private KeySequence[] fInvokingCommandKeySequences;
    private Composite fViewMenuButtonComposite;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private IAction fShowViewMenuAction;
    private HandlerSubmission fShowViewMenuHandlerSubmission;
    private int fTreeStyle;

    public AbstractInformationControl(Shell shell, int n, int n2, String string, boolean bl) {
        super(shell, n, true, true, true, true, null, null);
        if (string != null) {
            ICommandManager iCommandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
            this.fInvokingCommand = iCommandManager.getCommand(string);
            if (this.fInvokingCommand != null && !this.fInvokingCommand.isDefined()) {
                this.fInvokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.fTreeStyle = n2;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite composite) {
        this.fTreeViewer = this.createTreeViewer(composite, this.fTreeStyle);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.getId(), (StructuredViewer)this.fTreeViewer);
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent mouseEvent) {
                TreeItem treeItem;
                if (tree.equals(mouseEvent.getSource()) && (treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y))) instanceof TreeItem) {
                    if (!treeItem.equals(this.fLastItem)) {
                        this.fLastItem = treeItem;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (mouseEvent.y < tree.getItemHeight() / 4) {
                        Point point = tree.toDisplay(mouseEvent.x, mouseEvent.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(point.x, point.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (mouseEvent.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point point = tree.toDisplay(mouseEvent.x, mouseEvent.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(point.x, point.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (mouseEvent.button != 1) {
                    return;
                }
                if (tree.equals(mouseEvent.getSource())) {
                    TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    TreeItem treeItem2 = tree.getSelection()[0];
                    if (treeItem2.equals(treeItem)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    public AbstractInformationControl(Shell shell, int n, int n2) {
        this(shell, n, n2, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite composite) {
        this.fFilterText = new Text(composite, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)gridData);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (keyEvent.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (keyEvent.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (keyEvent.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.fFilterText;
    }

    protected void createHorizontalSeparator(Composite composite) {
        Label label = new Label(composite, 259);
        label.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected void handleStatusFieldClicked() {
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ((Text)modifyEvent.widget).getText();
                int n = string.length();
                if (n > 0 && string.charAt(n - 1) != '*') {
                    string = String.valueOf(string) + '*';
                }
                AbstractInformationControl.this.setMatcherString(string, true);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String string, boolean bl) {
        if (string.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean bl2 = string.toLowerCase().equals(string);
            this.fStringMatcher = new StringMatcher(string, bl2, false);
        }
        if (bl) {
            this.stringMatcherUpdated();
        }
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object object = this.getSelectedElement();
        if (object != null) {
            try {
                this.dispose();
                IEditorPart iEditorPart = EditorUtility.openInEditor(object, true);
                if (iEditorPart != null && object instanceof PHPCodeData) {
                    EditorUtility.revealInEditor(iEditorPart, (PHPCodeData)object);
                }
            }
            catch (CoreException coreException) {
                PHPUiPlugin.log(coreException);
            }
        }
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        PHPCodeData pHPCodeData = this.findElement(tree.getItems());
        if (pHPCodeData != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)pHPCodeData), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private PHPCodeData findElement(TreeItem[] treeItemArray) {
        ILabelProvider iLabelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int n = 0;
        while (n < treeItemArray.length) {
            String string;
            PHPCodeData pHPCodeData = (PHPCodeData)treeItemArray[n].getData();
            if (this.fStringMatcher == null) {
                return pHPCodeData;
            }
            if (pHPCodeData != null && this.fStringMatcher.match(string = iLabelProvider.getText((Object)pHPCodeData))) {
                return pHPCodeData;
            }
            pHPCodeData = this.findElement(treeItemArray[n].getItems());
            if (pHPCodeData != null) {
                return pHPCodeData;
            }
            ++n;
        }
        return null;
    }

    public void setInformation(String string) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager iMenuManager) {
        this.fCustomFiltersActionGroup.fillViewMenu(iMenuManager);
    }

    protected void fillDialogMenu(IMenuManager iMenuManager) {
        super.fillDialogMenu(iMenuManager);
        this.fillViewMenu(iMenuManager);
    }

    protected void inputChanged(Object object, Object object2) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(object);
        if (object2 != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object2));
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.open();
        } else {
            this.removeHandlerAndKeyBindingSupport();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
            this.removeHandlerAndKeyBindingSupport();
        }
    }

    public int open() {
        this.addHandlerAndKeyBindingSupport();
        return super.open();
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.removeHandlerAndKeyBindingSupport();
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    protected void addHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission == null) {
            this.fShowViewMenuHandlerSubmission = new HandlerSubmission(null, this.getShell(), null, this.fShowViewMenuAction.getActionDefinitionId(), (IHandler)new ActionHandler(this.fShowViewMenuAction), Priority.MEDIUM);
            PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    protected void removeHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission != null) {
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.fShowViewMenuHandlerSubmission);
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int n, int n2) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point point) {
        if (!this.getPersistBounds() || this.getDialogSettings() == null) {
            this.getShell().setLocation(point);
        }
    }

    public void setSize(int n, int n2) {
        this.getShell().setSize(n, n2);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.getShell().addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.getShell().removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.applyForegroundColor(color, this.getContents());
    }

    public void setBackgroundColor(Color color) {
        this.applyBackgroundColor(color, this.getContents());
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.getShell().addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.getShell().removeFocusListener(focusListener);
    }

    protected final ICommand getInvokingCommand() {
        return this.fInvokingCommand;
    }

    protected final KeySequence[] getInvokingCommandKeySequences() {
        List list;
        if (this.fInvokingCommandKeySequences == null && this.getInvokingCommand() != null && !(list = this.getInvokingCommand().getKeySequenceBindings()).isEmpty()) {
            this.fInvokingCommandKeySequences = new KeySequence[list.size()];
            int n = 0;
            while (n < this.fInvokingCommandKeySequences.length) {
                this.fInvokingCommandKeySequences[n] = ((IKeySequenceBinding)list.get(n)).getKeySequence();
                ++n;
            }
            return this.fInvokingCommandKeySequences;
        }
        return this.fInvokingCommandKeySequences;
    }

    protected IDialogSettings getDialogSettings() {
        String string = this.getId();
        IDialogSettings iDialogSettings = PHPUiPlugin.getDefault().getDialogSettings().getSection(string);
        if (iDialogSettings == null) {
            iDialogSettings = PHPUiPlugin.getDefault().getDialogSettings().addNewSection(string);
        }
        return iDialogSettings;
    }

    protected Control createTitleMenuArea(Composite composite) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(composite);
        if (this.hasHeader()) {
            this.fFilterText = this.createFilterText(composite);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite composite) {
        if (this.hasHeader()) {
            return super.createTitleControl(composite);
        }
        this.fFilterText = this.createFilterText(composite);
        return this.fFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.fFilterText, this.fTreeViewer.getTree()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTreeViewer.getTree()});
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object object, Object object2) {
            StringMatcher stringMatcher = AbstractInformationControl.this.getMatcher();
            if (stringMatcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String string = ((ILabelProvider)treeViewer.getLabelProvider()).getText(object2);
            if (string != null && stringMatcher.match(string)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, object2);
        }

        private boolean hasUnfilteredChild(TreeViewer treeViewer, Object object) {
            Object[] objectArray = ((ITreeContentProvider)treeViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                if (this.select((Viewer)treeViewer, object, objectArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

