/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.internal.ui.text.AbstractInformationControl;
import org.eclipse.php.internal.ui.util.StringMatcher;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class PHPOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private PHPCodeData fInput = null;
    private OutlineLabelProvider fInnerLabelProvider;
    private String fPattern;

    public PHPOutlineInformationControl(Shell shell, int n, int n2, String string) {
        super(shell, n, n2, string, true);
    }

    protected Text createFilterText(Composite composite) {
        Text text = super.createFilterText(composite);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite composite, int n) {
        Tree tree = new Tree(composite, 4 | n & 0xFFFFFFFD);
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gridData);
        OutlineTreeViewer outlineTreeViewer = new OutlineTreeViewer(tree);
        outlineTreeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        this.fInnerLabelProvider = new OutlineLabelProvider();
        PlatformUI.getWorkbench().getDecoratorManager();
        outlineTreeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fOutlineContentProvider = new OutlineContentProvider(outlineTreeViewer, this.fInnerLabelProvider);
        outlineTreeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        outlineTreeViewer.setAutoExpandLevel(-1);
        outlineTreeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return outlineTreeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] keySequenceArray = this.getInvokingCommandKeySequences();
        if (keySequenceArray == null || keySequenceArray.length == 0) {
            return "";
        }
        keySequenceArray[0].format();
        return "";
    }

    protected String getId() {
        return "org.eclipse.php.internal.ui.text.QuickOutline";
    }

    public void setInput(Object object) {
        if (object == null || object instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        this.fInput = (PHPCodeData)object;
        this.inputChanged(this.fInput, object);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
                    KeySequence[] keySequenceArray = PHPOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (keySequenceArray == null) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < keySequenceArray.length) {
                        if (keySequenceArray[n2].equals((Object)keySequence)) {
                            keyEvent.doit = false;
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void fillViewMenu(IMenuManager iMenuManager) {
        super.fillViewMenu(iMenuManager);
    }

    protected void setMatcherString(String string, boolean bl) {
        this.fPattern = string;
        if (string.length() == 0) {
            super.setMatcherString(string, bl);
            return;
        }
        boolean bl2 = string.toLowerCase().equals(string);
        String string2 = "*" + string;
        this.fStringMatcher = new OrStringMatcher(string, string2, bl2, false);
        if (bl) {
            this.stringMatcherUpdated();
        }
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        return iEditorPart.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String string, String string2, boolean bl, boolean bl2) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(string, bl, false);
            this.fMatcher2 = new StringMatcher(string2, bl, false);
        }

        public boolean match(String string) {
            return this.fMatcher2.match(string) || this.fMatcher1.match(string);
        }
    }

    private class OutlineContentProvider
    extends PHPOutlineContentProvider {
        public OutlineContentProvider(TreeViewer treeViewer, PHPOutlineLabelProvider pHPOutlineLabelProvider) {
            super(treeViewer, pHPOutlineLabelProvider);
        }
    }

    private class OutlineLabelProvider
    extends PHPOutlineLabelProvider {
        private OutlineLabelProvider() {
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        public OutlineTreeViewer(Tree tree) {
            super(tree);
        }
    }
}

