/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PHPServerAdvancedTab
extends AbstractLaunchConfigurationTab {
    private Button debugFirstPageBt;
    private Button debugAllPagesBt;
    private Button debugStartFromBt;
    private Button debugContinueBt;
    private Button resetBt;
    private Text debugFromTxt;
    protected Button openBrowser;
    protected boolean isOpenInBrowser;
    protected WidgetListener listener = new WidgetListener();
    protected ILaunchConfiguration launchConfiguration;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createAdvanceControl(composite2);
        this.createExtensionControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        this.setControl((Control)composite2);
    }

    protected void createAdvanceControl(Composite composite) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Session Settings");
        this.openBrowser = new Button((Composite)group, 32);
        this.openBrowser.setText("Open in Browser");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.openBrowser.setLayoutData((Object)gridData);
        this.openBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.getSource();
                PHPServerAdvancedTab.this.isOpenInBrowser = button.getSelection();
                if (!PHPServerAdvancedTab.this.isOpenInBrowser) {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(true);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(false);
                } else {
                    PHPServerAdvancedTab.this.debugFirstPageBt.setSelection(false);
                    PHPServerAdvancedTab.this.debugAllPagesBt.setSelection(true);
                }
                PHPServerAdvancedTab.this.debugStartFromBt.setSelection(false);
                PHPServerAdvancedTab.this.debugContinueBt.setSelection(false);
                PHPServerAdvancedTab.this.enableSessionSettingButtons(PHPServerAdvancedTab.this.isOpenInBrowser);
                PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.debugAllPagesBt = this.createRadioButton((Composite)group, "Debug &All Pages");
        gridData = (GridData)this.debugAllPagesBt.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 20;
        this.debugFirstPageBt = this.createRadioButton((Composite)group, "Debug &First Page Only");
        gridData = (GridData)this.debugFirstPageBt.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 20;
        this.debugStartFromBt = this.createRadioButton((Composite)group, "&Start Debug from:");
        gridData = (GridData)this.debugStartFromBt.getLayoutData();
        gridData.horizontalIndent = 20;
        this.debugFromTxt = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.debugFromTxt.setLayoutData((Object)gridData);
        this.resetBt = this.createPushButton((Composite)group, "Default", null);
        this.resetBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PHPServerAdvancedTab.this.launchConfiguration != null) {
                    try {
                        PHPServerAdvancedTab.this.debugFromTxt.setText(PHPServerAdvancedTab.this.launchConfiguration.getAttribute("base_url", ""));
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
        this.debugContinueBt = this.createCheckButton((Composite)group, "&Continue Debug from This Page");
        gridData = (GridData)this.debugContinueBt.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 40;
        this.debugStartFromBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPServerAdvancedTab.this.updateDebugFrom();
            }
        });
        this.updateDebugFrom();
        this.debugFirstPageBt.addSelectionListener((SelectionListener)this.listener);
        this.debugAllPagesBt.addSelectionListener((SelectionListener)this.listener);
        this.debugContinueBt.addSelectionListener((SelectionListener)this.listener);
        this.debugStartFromBt.addSelectionListener((SelectionListener)this.listener);
        this.debugFromTxt.addModifyListener((ModifyListener)this.listener);
    }

    private void enableSessionSettingButtons(boolean bl) {
        String string = this.getLaunchConfigurationDialog().getMode();
        bl = bl && "debug".equals(string);
        this.debugFirstPageBt.setEnabled(bl);
        this.debugAllPagesBt.setEnabled(bl);
        this.debugStartFromBt.setEnabled(bl);
        this.debugContinueBt.setEnabled(false);
        this.resetBt.setEnabled(false);
        this.debugFromTxt.setEnabled(false);
    }

    protected void createExtensionControls(Composite composite) {
    }

    public String getName() {
        return "Advanced";
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.launchConfiguration = iLaunchConfiguration;
        try {
            this.isOpenInBrowser = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            this.openBrowser.setSelection(this.isOpenInBrowser);
            String string = iLaunchConfiguration.getAttribute("debugPages", "debugAllPages");
            if ("debugAllPages".equals(string)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(true);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFirstPage".equals(string)) {
                this.debugFirstPageBt.setSelection(true);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(false);
            } else if ("debugFrom".equals(string)) {
                this.debugFirstPageBt.setSelection(false);
                this.debugAllPagesBt.setSelection(false);
                this.debugStartFromBt.setSelection(true);
                boolean bl = iLaunchConfiguration.getAttribute("debugFromURL", false);
                this.debugContinueBt.setSelection(bl);
            }
            String string2 = iLaunchConfiguration.getAttribute("debugContinue", "");
            this.debugFromTxt.setText(string2);
            this.updateDebugFrom();
            this.enableSessionSettingButtons(this.isOpenInBrowser);
        }
        catch (CoreException coreException) {}
        this.isValid(iLaunchConfiguration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.launchConfiguration = iLaunchConfigurationWorkingCopy;
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", this.isOpenInBrowser);
        if (this.isOpenInBrowser) {
            if (this.debugAllPagesBt.getSelection()) {
                iLaunchConfigurationWorkingCopy.setAttribute("debugPages", "debugAllPages");
            } else if (this.debugFirstPageBt.getSelection()) {
                iLaunchConfigurationWorkingCopy.setAttribute("debugPages", "debugFirstPage");
            } else {
                iLaunchConfigurationWorkingCopy.setAttribute("debugPages", "debugFrom");
                iLaunchConfigurationWorkingCopy.setAttribute("debugContinue", this.debugFromTxt.getText());
                iLaunchConfigurationWorkingCopy.setAttribute("debugFromURL", this.debugContinueBt.getSelection());
            }
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("debugPages", "debugFirstPage");
        }
        this.applyExtension(iLaunchConfigurationWorkingCopy);
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.launchConfiguration = iLaunchConfigurationWorkingCopy;
        this.setErrorMessage(null);
        iLaunchConfigurationWorkingCopy.setAttribute("debugPages", "debugAllPages");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.launchConfiguration = iLaunchConfiguration;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.debugStartFromBt.getSelection()) {
            if (this.debugFromTxt.getText().trim().equals("")) {
                this.setErrorMessage("Invalid debug start page");
                return false;
            }
            try {
                new URL(this.debugFromTxt.getText());
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage("Invalid URL");
                return false;
            }
        }
        return this.isValidExtension(iLaunchConfiguration);
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    private void updateDebugFrom() {
        if (this.launchConfiguration != null && this.debugFromTxt.getText().trim().equals("")) {
            try {
                this.debugFromTxt.setText(this.launchConfiguration.getAttribute("base_url", ""));
            }
            catch (CoreException coreException) {}
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    boolean bl = PHPServerAdvancedTab.this.debugStartFromBt.getSelection();
                    PHPServerAdvancedTab.this.debugFromTxt.setEnabled(bl);
                    PHPServerAdvancedTab.this.debugContinueBt.setEnabled(bl);
                    PHPServerAdvancedTab.this.resetBt.setEnabled(bl);
                }
                catch (SWTException sWTException) {}
            }
        });
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            PHPServerAdvancedTab.this.setDirty(true);
            PHPServerAdvancedTab.this.updateLaunchConfigurationDialog();
        }
    }
}

