/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching.zend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestController;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestEvent;
import org.eclipse.php.internal.debug.core.zend.testConnection.IDebugServerTestListener;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.launching.zend.DefaultServerTestMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DefaultDebugServerConnectionTest
implements IDebugServerConnectionTest,
IDebugServerTestListener {
    protected Shell fShell;
    protected Server fServer;
    protected String fURL;
    private Boolean isFinished = false;
    private ProgressMonitorDialog progressDialog = null;
    private static final int DEFAULT_TIMEOUT = 10000;
    private List<String> timeoutServerList = new ArrayList<String>();

    public void testConnection(Server server, Shell shell) {
        this.fServer = server;
        this.fShell = shell;
        this.fURL = server.getBaseURL();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingConnectivity"), -1);
                try {
                    this.checkWebServerExistence();
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    String[] stringArray = DefaultDebugServerConnectionTest.this.getAllLocalHostsAddresses();
                    DebugServerTestController.getInstance().addListener((IDebugServerTestListener)DefaultDebugServerConnectionTest.this);
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string;
                        block16: {
                            string = stringArray2[n2];
                            if (iProgressMonitor.isCanceled()) {
                                return;
                            }
                            DefaultDebugServerConnectionTest.this.isFinished = false;
                            String string2 = DefaultDebugServerConnectionTest.this.generateDebugQuery(string);
                            try {
                                this.activateTestDebug(iProgressMonitor, string, string2);
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break block16;
                                String string3 = NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL);
                                DefaultDebugServerConnectionTest.this.showCustomErrorDialog(string3);
                                return;
                            }
                        }
                        if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break;
                        Thread.sleep(10000L);
                        if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break;
                        DefaultDebugServerConnectionTest.this.timeoutServerList.add(string);
                        ++n2;
                    }
                    if (DefaultDebugServerConnectionTest.this.isFinished != false) return;
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(DefaultDebugServerConnectionTest.this.addTimeOutsMessage("A timeout occurred when the debug server attempted to connect to the following client hosts/IPs:\n"));
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_theURLCouldNotBeFound"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (!DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) {
                        DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        return;
                    }
                    DefaultDebugServerConnectionTest.this.removeThisListener();
                    return;
                }
                catch (ConnectException connectException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                    catch (IOException iOException) {
                        DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        return;
                    }
                }
                finally {
                    DefaultDebugServerConnectionTest.this.removeThisListener();
                }
            }

            private void activateTestDebug(IProgressMonitor iProgressMonitor, String string, String string2) throws IOException {
                iProgressMonitor.subTask(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingCommunication"), (Object)string));
                InputStream inputStream = null;
                try {
                    URL uRL = new URL(string2);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setReadTimeout(10000);
                    inputStream = uRLConnection.getInputStream();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }

            private void checkWebServerExistence() throws MalformedURLException, IOException {
                InputStream inputStream = null;
                try {
                    URL uRL = new URL(String.valueOf(DefaultDebugServerConnectionTest.this.fURL) + "/dummy.php");
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(5000);
                    uRLConnection.setReadTimeout(10000);
                    inputStream = uRLConnection.getInputStream();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        };
        this.progressDialog = new ProgressMonitorDialog(this.fShell);
        this.progressDialog.setBlockOnOpen(false);
        this.progressDialog.setCancelable(true);
        try {
            this.progressDialog.run(true, true, iRunnableWithProgress);
        }
        catch (Exception exception) {
            Logger.logException(exception);
        }
    }

    private void removeThisListener() {
        DebugServerTestController.getInstance().removeListener((IDebugServerTestListener)this);
    }

    protected void showCustomErrorDialog(final String string) {
        this.fShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultServerTestMessageDialog defaultServerTestMessageDialog = new DefaultServerTestMessageDialog(DefaultDebugServerConnectionTest.this.fShell, PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), null, string, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                defaultServerTestMessageDialog.open();
            }
        });
    }

    protected String generateDebugQuery(String string) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fURL);
        stringBuilder.append("/dummy.php?start_debug=1&debug_port=");
        String string3 = Integer.toString(PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.zendDebugger"));
        stringBuilder.append(string3);
        stringBuilder.append("&debug_fastfile=1&debug_host=");
        stringBuilder.append(String.valueOf(string) + "&testConnection=true");
        string2 = stringBuilder.toString();
        return string2;
    }

    private String[] getAllLocalHostsAddresses() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        String string = preferences.getString(PHPDebugCorePreferenceNames.CLIENT_IP);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void showSuccessMessage() {
        String string = PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_success");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (this.timeoutServerList.size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_however"));
            stringBuilder.append(this.addTimeOutsMessage(""));
        }
        MessageDialog.openInformation((Shell)this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)stringBuilder.toString());
    }

    private String addTimeOutsMessage(String string) {
        String string2 = string;
        if (this.timeoutServerList.size() > 0) {
            Iterator<String> iterator = this.timeoutServerList.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                stringBuilder.append(String.valueOf('-') + iterator.next() + '\n');
            }
            stringBuilder.append(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_theClientHostIPs"));
            string2 = String.valueOf(string2) + stringBuilder.toString();
        }
        return string2;
    }

    public void testEventReceived(final DebugServerTestEvent debugServerTestEvent) {
        this.fShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultDebugServerConnectionTest.this.removeThisListener();
                if (debugServerTestEvent.getEventType() == 0) {
                    DefaultDebugServerConnectionTest.this.isFinished = true;
                    DefaultDebugServerConnectionTest.this.showSuccessMessage();
                } else {
                    switch (debugServerTestEvent.getEventType()) {
                        case 2: {
                            MessageDialog.openError((Shell)DefaultDebugServerConnectionTest.this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_oldDebuggerVersion"));
                            break;
                        }
                        case 1: {
                            DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        }
                    }
                }
            }
        });
    }
}

