/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualPath
implements Cloneable {
    private static final Pattern VOLNAME = Pattern.compile("([A-Za-z]:)[/\\\\](.*)");
    private static final Pattern PROTOCOL = Pattern.compile("([A-Za-z]*://)(.*)");
    private LinkedList<String> segments;
    private String device;
    private char sepChar;

    public VirtualPath(String string) {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.startsWith("\\\\")) {
            this.sepChar = (char)92;
            this.device = "\\\\";
            string = string.substring(2);
        } else {
            object = VOLNAME.matcher(string);
            if (((Matcher)object).matches()) {
                this.sepChar = (char)92;
                this.device = String.valueOf(((Matcher)object).group(1)) + "\\";
                string = ((Matcher)object).group(2);
            } else if (string.startsWith("/")) {
                this.sepChar = (char)47;
                this.device = "/";
            } else {
                object = PROTOCOL.matcher(string);
                if (((Matcher)object).matches()) {
                    this.sepChar = (char)47;
                    this.device = ((Matcher)object).group(1);
                    string = ((Matcher)object).group(2);
                } else {
                    throw new IllegalArgumentException("Illegal or not full path: " + string);
                }
            }
        }
        object = new StringTokenizer(string, "/\\");
        this.segments = new LinkedList();
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.length() <= 0) continue;
            this.segments.add(string2);
        }
    }

    public static boolean isAbsolute(String string) {
        return string.startsWith("\\\\") || VOLNAME.matcher(string).matches() || string.startsWith("/") || PROTOCOL.matcher(string).matches();
    }

    protected VirtualPath(String string, char c, LinkedList<String> linkedList) {
        this.device = string;
        this.sepChar = c;
        this.segments = linkedList;
    }

    public String getLastSegment() {
        return this.segments.getLast();
    }

    public int getSegmentsCount() {
        return this.segments.size();
    }

    public String removeFirstSegment() {
        return this.segments.removeFirst();
    }

    public String removeLastSegment() {
        return this.segments.removeLast();
    }

    public void addLastSegment(String string) {
        this.segments.addLast(string);
    }

    public String[] getSegments() {
        return this.segments.toArray(new String[this.segments.size()]);
    }

    public char getSeparatorChar() {
        return this.sepChar;
    }

    public boolean isPrefixOf(VirtualPath virtualPath) {
        Iterator iterator = this.segments.iterator();
        Iterator iterator2 = virtualPath.segments.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (((String)iterator.next()).equals(iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.device);
        Iterator iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.sepChar);
        }
        return stringBuilder.toString();
    }

    public VirtualPath clone() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            linkedList.add((String)iterator.next());
        }
        VirtualPath virtualPath = new VirtualPath(this.device, this.sepChar, linkedList);
        return virtualPath;
    }

    public int hashCode() {
        return this.device.hashCode() + 13 * this.segments.hashCode() + 31 * this.sepChar;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof VirtualPath)) {
            return false;
        }
        VirtualPath virtualPath = (VirtualPath)object;
        boolean bl2 = bl = virtualPath.segments.size() == this.segments.size();
        if (bl) {
            Iterator iterator = this.segments.iterator();
            Iterator iterator2 = virtualPath.segments.iterator();
            while (bl && iterator.hasNext() && iterator2.hasNext()) {
                bl &= ((String)iterator.next()).equalsIgnoreCase((String)iterator2.next());
            }
        }
        return virtualPath.device.equalsIgnoreCase(this.device) && bl && virtualPath.sepChar == this.sepChar;
    }
}

