<?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php echo $lang ?>" xml:lang="<?php echo $lang ?>">
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
	
	<title>Pixmania</title>
	
	<link rel="stylesheet" type="text/css" media="screen, projection" href="styles/form.css" />
	<link rel="stylesheet" type="text/css" media="screen, projection" href="styles/form-<?php echo $lang ?>.css" />
	<script type="text/javascript" src="styles/control.js"></script>
</head>

<body>
<div id="formPage">
	<div class="pageTop"><?php echo _T('Your credit application') ?></div>
	
	<div class="pageIn">
		
		<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
<?php
$isGood = true;

foreach($errors as $k => $v)
{
	if($v == -1 || (isset($_POST[$k]) && $v == 0))
	{
		$isGood = false;
		break;
	}
}

if(!$isGood)
{
?>
			<p class="FormLigneError"><?php echo _T('Sorry, your application has not been totally properly filled in. Please, check bellow'); ?></p>
<?php
}
?>
			<fieldset id="frm_your_project">
				<legend><?php echo _T('Your project') ?></legend>
				
				<div class="ligne">
					<label><?php echo _T('Reference number') ?></label>
					<strong><?php echo $pixData['ref'] ?></strong>
				</div>
				
				<div class="ligne">
					<label><?php echo _T('Credit application date') ?></label>
					<strong><?php echo date(_T('m/d/Y')) ?></strong>
				</div>
				
				<div class="ligne">
					<label><?php echo _T('What do you wish to finance?') ?></label>
					<strong><?php
						if     ($pixData['prd'] == 1) echo _T('Camera');
						else if($pixData['prd'] == 2) echo _T('Camcorder');
						else if($pixData['prd'] == 3) echo _T('TV Video');
						else if($pixData['prd'] == 4) echo _T('Sound');
						else if($pixData['prd'] == 5) echo _T('IT Product');
						else if($pixData['prd'] == 6) echo _T('Telephony - PDA - GPS');
						else if($pixData['prd'] == 7) echo _T('Consumable');
						else if($pixData['prd'] == 8) echo _T('Accesories');
						else if($pixData['prd'] == 9) echo _T('CD - DVD - Video Games');
						else echo _T('Several products');
					?></strong>
				</div>
				
				<div class="ligne">
					<label><?php echo _T('Order amount (inc VAT & delivery Cost)') ?></label>
					<strong><?php echo number_format($pixData['mnt'], 2, _T(','), _T('.')).'&nbsp;'._T('G') ?></strong>
				</div>
				
				<!-- 
				<h2>Choose your mean of funding</h2>
				<h3>Instalment loan</h3>
				<ul>
					<li>from 6 to 48 months</li>
					<li>X% interest rate</li>
					<li>legal mentions</li>
				</ul>
				
				<h3>Special offer</h3>
				<ul>
					<li>...</li>
					<li>legal mentions</li>
				</ul>
				-->
				
				<h2><?php echo _T('Tick-mark your funding choice') ?></h2>
				<p><?php echo _T('For an amount of') ?> <strong><?php echo number_format($pixData['mnt'], 2, _T(','), _T('.')).'&nbsp;'._T('G') ?></strong></p>
				
				<p class="mentions">
					<?php echo _T('The monthly payments are mentionned without insurances') ?>
				</p>
<?php 
if($errors['duree'] == -1
||(isset($_POST['btnBdd']) && $errors['duree'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thansks to tick-mark here your choice') ?></p>
<?php
}
?>
				<table id="fundingChoice">
					<tr>
						<th class="col1"></th>
						<th><?php echo _T('Length') ?></th>
						<th><?php echo _T('Number of monthly payments') ?></th>
						<th><?php echo _T('Amount of monthly payment') ?></th>
						<th><?php echo _T('Interest rate') ?></th>
						<th><?php echo _T('Total cost of the credit') ?></th>
						<th><?php echo _T('Total cost of the purchase with credit') ?></th>
					</tr>
<?php
if($lang == 'gr')
{
	define('CALC_MENSU', '(%1\$d * (17.11/100/12))/(1-pow((1+(17.11/100/12)),-6)) + round((%1\$d * (17.11/100/12))/(1-pow((1+(17.11/100/12)), -6)*(2.5/100)), 2)');
	$simu = array(
		6  => array(
			'duree'         => 6,
			'tnc'           => 17.11,
			'frais'         => 10,
			'tauxAssurance' => 2.5,
			'mensualite'    => 107.65,
			'mensu1'        => 0,
			'cout'          => 30.30,
			'coutTotal'     => 645.90,
			'mensunoassu'   => eval('return '.'.';')
		),
	);
}
else
{
	for($i=6; $i<= 48; $i+=6)
	{
		if($i == 30 || $i == 42)
			continue;
	
		$simulation->setParam(SIMU_PARAM_DUREE, $i);
		$simu[$i] = $simulation->getSimulation();
	}
}

foreach($simu as $i => $tmp)
{
	if(!isset($tmp['coutTotal']))
		$tmp['coutTotal'] = $tmp['cout'] + $pixData['mnt'];
?>
					<tr>
						<td class="col1"><input type="radio" class="inputRadio" name="duree" id="frm_m<?php echo $i ?>" value="<?php echo $i ?>"<?php if($datas['duree'] == $i) echo ' checked="checked"' ?> /></td>
						<td><label for="frm_m<?php echo $i ?>"><?php printf(_T('%u monthes'), $i) ?></label></td>
						<td><?php echo $tmp['duree'] ?></td>
						<td class="chiffres"><?php echo number_format($tmp['mensualite'], 2, _T(','), _T('.')).'&nbsp;'._T('G') ?></td>
						<td><?php echo number_format($tmp['teg'], 2, _T(','), _T('.')).'&nbsp;%' ?></td>
						<td class="chiffres"><?php echo number_format($tmp['cout'], 2, _T(','), _T('.')).'&nbsp;'._T('G') ?></td>
						<td class="chiffres"><?php echo number_format($tmp['coutTotal'], 2, _T(','), _T('.')).'&nbsp;'._T('G') ?></td>
					</tr>
<?php
}
?>
				</table>
			
				<p class="mentions">
					<?php echo _T('Offer subjected to Cetelem acceptance') ?><br />
					<?php printf(_T('Condition in course on %s'), '10/10/2006') ?><br />
					<?php echo _T('This page is hosted on Cetelem server') ?>
				</p>
			</fieldset>

			
			<fieldset id="frm_personal_details">
				<legend><?php echo _T('Your personal details') ?></legend>
				
				<div class="ligne">
<?php 
if($errors['civilite'] == -1
||(isset($_POST['civilite']) && $errors['civilite'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_civilite"><?php echo _T('Title') ?></label>					
					<select id="frm_civilite" name="civilite">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['civilite'] == 1) echo ' selected="selected"' ?>><?php echo _T('Mr') ?></option>
						<option value="2"<?php if($datas['civilite'] == 2) echo ' selected="selected"' ?>><?php echo _T('Ms') ?></option>
<?php
	if(false !== strpos('en,hu',$lang))
	{
?>
						<option value="3"<?php if($datas['civilite'] == 3) echo ' selected="selected"' ?>><?php echo _T('Mrs') ?></option>
<?php
	}
?>
					</select>
				</div>				
				
				<div class="ligne">
<?php 
if($errors['nom'] == -1
||(isset($_POST['nom']) && $errors['nom'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_nom"><?php echo _T('First Name') ?></label>
					<input id="frm_nom" name="nom" type="text" class="inputText" value="<?php echo $datas['nom'] ?>" />
				</div>		

				<div class="ligne">
<?php 
if($errors['nom_jeune_fille'] == -1
||(isset($_POST['nom_jeune_fille']) && $errors['nom_jeune_fille'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_nom_jeune_fille"><?php echo _T('Maiden name') ?></label>
					<input id="frm_nom_jeune_fille" name="nom_jeune_fille" value="<?php echo $datas['nom_jeune_fille'] ?>" type="text" class="inputText" />
				</div>		

				<div class="ligne">
<?php 
if($errors['prenom'] == -1
||(isset($_POST['prenom']) && $errors['prenom'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_prenom"><?php echo _T('Last Name') ?></label>
					<input id="frm_prenom" name="prenom" type="text" value="<?php echo $datas['prenom'] ?>" class="inputText" />
				</div>	
				
				<div class="ligne">
<?php 
if($errors['date_naissance_j'] == -1
|| $errors['date_naissance_m'] == -1
|| $errors['date_naissance_a'] == -1
||(isset($_POST['date_naissance_j']) && $errors['date_naissance_j'] == 0)
||(isset($_POST['date_naissance_m']) && $errors['date_naissance_m'] == 0)
||(isset($_POST['date_naissance_a']) && $errors['date_naissance_a'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_date_naissance_j"><?php echo _T('Date of birth') ?></label>
					<input id="frm_date_naissance_j" name="date_naissance_j" value="<?php echo $datas['date_naissance_j'] ?>" type="text" class="inputText inputDay" /> / 
					<select id="frm_date_naissance_m" name="date_naissance_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_naissance_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_naissance_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_naissance_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_naissance_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_naissance_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_naissance_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_naissance_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_naissance_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_naissance_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_naissance_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_naissance_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_naissance_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_naissance_a" name="date_naissance_a" value="<?php echo $datas['date_naissance_a'] ?>" type="text" class="inputText inputYear" />
				</div>
				
				<div class="ligne">
<?php 
if($errors['ville_naissance'] == -1
||(isset($_POST['ville_naissance']) && $errors['ville_naissance'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_ville_naissance"><?php echo _T('City of birth') ?></label>
					<input id="frm_ville_naissance" name="ville_naissance" value="<?php echo $datas['ville_naissance'] ?>" type="text" class="inputText" />
				</div>
<?php
if(false !== strpos('en,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['dep_naissance'] == -1
	||(isset($_POST['dep_naissance']) && $errors['dep_naissance'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_dep_naissance"><?php echo _T('County of birth') ?></label>
					<input id="frm_dep_naissance" name="dep_naissance" value="<?php echo $datas['dep_naissance'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('en,gr,de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['nationalite'] == -1
	||(isset($_POST['nationalite']) && $errors['nationalite'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_nationalite"><?php echo _T('Country of birth') ?></label>
					<select id="frm_nationalite" name="nationalite">
						<option value="">&nbsp;</option>
						<option <?php if($datas['nationalite'] == _T('United Kingdom')) echo 'selected="selected" ' ?>value="<?php echo _T('United Kingdom') ?>"><?php echo _T('United Kingdom') ?></option>
						<option <?php if($datas['nationalite'] == _T('European Union')) echo 'selected="selected" ' ?>value="<?php echo _T('European Union') ?>"><?php echo _T('European Union') ?></option>
<?php
	if($lang == 'de')
	{
?>
						<option <?php if($datas['nationalite'] == _T('Bosnia')) echo 'selected="selected" ' ?>value="<?php echo _T('Bosnia') ?>"><?php echo _T('Bosnia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Yugoslavia')) echo 'selected="selected" ' ?>value="<?php echo _T('Yugoslavia') ?>"><?php echo _T('Yugoslavia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Croatia')) echo 'selected="selected" ' ?>value="<?php echo _T('Croatia') ?>"><?php echo _T('Croatia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Poland')) echo 'selected="selected" ' ?>value="<?php echo _T('Poland') ?>"><?php echo _T('Poland') ?></option>
						<option <?php if($datas['nationalite'] == _T('Romania')) echo 'selected="selected" ' ?>value="<?php echo _T('Romania') ?>"><?php echo _T('Romania') ?></option>
						<option <?php if($datas['nationalite'] == _T('Russia')) echo 'selected="selected" ' ?>value="<?php echo _T('Russia') ?>"><?php echo _T('Russia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Slovacia')) echo 'selected="selected" ' ?>value="<?php echo _T('Slovacia') ?>"><?php echo _T('Slovacia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Slovenia')) echo 'selected="selected" ' ?>value="<?php echo _T('Slovenia') ?>"><?php echo _T('Slovenia') ?></option>
						<option <?php if($datas['nationalite'] == _T('Czech Republic')) echo 'selected="selected" ' ?>value="<?php echo _T('Czech Republic') ?>"><?php echo _T('Czech Republic') ?></option>
						<option <?php if($datas['nationalite'] == _T('Turkish')) echo 'selected="selected" ' ?>value="<?php echo _T('Turkish') ?>"><?php echo _T('Turkish') ?></option>
<?php
	}
?>
						<option <?php if($datas['nationalite'] == _T('Other')) echo 'selected="selected" ' ?>value="<?php echo _T('Other') ?>"><?php echo _T('Other') ?></option>
					</select>
				</div>
<?php
}

if(false !== strpos('gr,pl,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['num_compl_identite'] == -1
	||(isset($_POST['num_compl_identite']) && $errors['num_compl_identite'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_num_compl_identite"><?php echo _T('Tax number') ?></label>
					<input id="frm_num_compl_identite" name="num_compl_identite" value="<?php echo $datas['num_compl_identite'] ?>" type="text" class="inputText" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
if($errors['num_identite_national'] == -1
||(isset($_POST['num_identite_national']) && $errors['num_identite_national'] == 0)
||(isset($errors['piece_identite'])
   && ($errors['piece_identite'] == -1
       ||(isset($_POST['piece_identite']) && $errors['piece_identite'] == 0))))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_num_identite_national"><?php echo _T('Identity number') ?></label>
					<input id="frm_num_identite_national" name="num_identite_national" value="<?php echo $datas['num_identite_national'] ?>" type="text" class="inputText" />
<?php
if(false !== strpos('gr,de',$lang))
{
?>
					<select id="frm_piece_identite" name="piece_identite">
						<option value="">&nbsp;</option>
						<option <?php if($datas['piece_identite'] == _T('Normal ID')) echo 'selected="selected" ' ?>value="<?php echo _T('Normal ID') ?>"><?php echo _T('Normal ID') ?></option>
						<option <?php if($datas['piece_identite'] == _T('Military ID')) echo 'selected="selected" ' ?>value="<?php echo _T('Military ID') ?>"><?php echo _T('Military ID') ?></option>
						<option <?php if($datas['piece_identite'] == _T('Passport')) echo 'selected="selected" ' ?>value="<?php echo _T('Passport') ?>"><?php echo _T('Passport') ?></option>
<?php
	if($lang == 'de')
	{
?>
						<option <?php if($datas['piece_identite'] == 'Deutscher Reisepass') echo 'selected="selected" ' ?>value="Deutscher Reisepass">Deutscher Reisepass</option>
						<option <?php if($datas['piece_identite'] == 'EU Personalausweis') echo 'selected="selected" ' ?>value="EU Personalausweis">EU Personalausweis</option>
						<option <?php if($datas['piece_identite'] == 'EU Reisepass') echo 'selected="selected" ' ?>value="EU Reisepass">EU Reisepass</option>
						<option <?php if($datas['piece_identite'] == 'Keine Ausweispapiere') echo 'selected="selected" ' ?>value="Keine Ausweispapiere">Keine Ausweispapiere</option>
<?php
	}
?>
					</select>
<?php
}
?>
				</div>
<?php
if(false !== strpos('en,de,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['lieu_obtention'] == -1
	||(isset($_POST['lieu_obtention']) && $errors['lieu_obtention'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_lieu_obtention"><?php echo _T('Place of delivery') ?></label>
					<input id="frm_lieu_obtention" name="lieu_obtention" value="<?php echo $datas['lieu_obtention'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['date_obtention_m'] == -1
	|| $errors['date_obtention_a'] == -1
	||(isset($_POST['date_obtention_m']) && $errors['date_obtention_m'] == 0)
	||(isset($_POST['date_obtention_a']) && $errors['date_obtention_a'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_obtention_m"><?php echo _T('Date of issue') ?></label>
					<select id="frm_date_obtention_m" name="date_obtention_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_obtention_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_obtention_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_obtention_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_obtention_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_obtention_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_obtention_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_obtention_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_obtention_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_obtention_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_obtention_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_obtention_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_obtention_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_obtention_a" name="date_obtention_a" value="<?php echo $datas['date_obtention_a'] ?>" type="text" maxlength="4" class="inputText inputYear" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
	if($errors['statut_marital'] == -1
	||(isset($_POST['statut_marital']) && $errors['statut_marital'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_statut_marital"><?php echo _T('Marital status') ?></label>					
					<select id="frm_statut_marital" name="statut_marital">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['statut_marital'] == 1) echo ' selected="selected"' ?>><?php echo _T('Single') ?></option>
						<option value="2"<?php if($datas['statut_marital'] == 2) echo ' selected="selected"' ?>><?php echo _T('Married') ?></option>
						<option value="3"<?php if($datas['statut_marital'] == 3) echo ' selected="selected"' ?>><?php echo _T('Civil partner') ?></option>
<?php
	if(false !== strpos('en,de,gr,hu',$lang))
	{
?>
						<option value="6"<?php if($datas['statut_marital'] == 6) echo ' selected="selected"' ?>><?php echo _T('Divided') ?></option>
<?php
	}
?>
						<option value="4"<?php if($datas['statut_marital'] == 4) echo ' selected="selected"' ?>><?php echo _T('Divorced') ?></option>
						<option value="5"<?php if($datas['statut_marital'] == 5) echo ' selected="selected"' ?>><?php echo _T('Widower') ?></option>
					</select>
				</div>	
				
				<div class="ligne">
<?php 
	if($errors['nb_enfants_charge'] == -1
	||(isset($_POST['nb_enfants_charge']) && $errors['nb_enfants_charge'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_nb_enfants_charge"><?php echo _T('Number of dependent children') ?></label>
					<input id="frm_nb_enfants_charge" name="nb_enfants_charge" value="<?php echo $datas['nb_enfants_charge'] ?>" maxlength="2" type="text" class="inputText" />
				</div>
<?php
if(false !== strpos('de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['type_part_credit'] == -1
	||(isset($_POST['type_part_credit']) && $errors['type_part_credit'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_type_part_credit"><?php echo _T('Co-Applicant for credit request') ?></label>					
					<select id="frm_type_part_credit" name="type_part_credit">
						<option value="">&nbsp;</option>
						<option value="0"<?php if($datas['type_part_credit'] == "0") echo ' selected="selected"' ?>><?php echo _T('None') ?></option>
						<option value="1"<?php if($datas['type_part_credit'] == "1") echo ' selected="selected"' ?>><?php echo _T('Partner') ?></option>
						<option value="2"<?php if($datas['type_part_credit'] == "2") echo ' selected="selected"' ?>><?php echo _T('Third Person') ?></option>
					</select>
				</div>
<?php
}
?>
			</fieldset>

			<fieldset id="frm_partner_personal_details">
				<legend><?php echo _T('Your partner personal details') ?></legend>
				
				<div class="ligne">
<?php 
	if($errors['civilite_conjoint'] == -1
	||($errors['civilite_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_civilite_conjoint"><?php echo _T('Title') ?></label>					
					<select id="frm_civilite_conjoint" name="civilite_conjoint">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['civilite_conjoint'] == 1) echo ' selected="selected"' ?>><?php echo _T('Mr') ?></option>
						<option value="2"<?php if($datas['civilite_conjoint'] == 2) echo ' selected="selected"' ?>><?php echo _T('Ms') ?></option>
<?php
	if(false !== strpos('en,hu',$lang))
	{
?>
						<option value="3"<?php if($datas['civilite_conjoint'] == 3) echo ' selected="selected"' ?>><?php echo _T('Mrs') ?></option>
<?php
	}
?>
					</select>
				</div>				
				
				<div class="ligne">
<?php 
	if($errors['nom_conjoint'] == -1
	||($errors['nom_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_nom_conjoint"><?php echo _T('First Name') ?></label>
					<input id="nom_conjoint" name="nom_conjoint" value="<?php echo $datas['nom_conjoint'] ?>" type="text" class="inputText" />
				</div>		
<?php
if(false !== strpos('en,de,pl,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['nom_jeune_fille_conjoint'] == -1
	||($errors['nom_jeune_fille_conjoint'] == 0 && $datas['civilite_conjoint'] == 2))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_nom_jeune_fille_conjoint"><?php echo _T('Maiden name') ?></label>
					<input id="frm_nom_jeune_fille_conjoint" name="nom_jeune_fille_conjoint" value="<?php echo $datas['nom_jeune_fille_conjoint'] ?>" type="text" class="inputText" />
				</div>		
<?php
}
?>
				<div class="ligne">
<?php 
	if($errors['prenom_conjoint'] == -1
	||($errors['prenom_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_prenom_conjoint"><?php echo _T('Last Name') ?></label>
					<input id="frm_prenom_conjoint" name="prenom_conjoint" value="<?php echo $datas['prenom_conjoint'] ?>" type="text" class="inputText" />
				</div>	
				
				<div class="ligne">
<?php 
	if($errors['date_naissance_conjoint_j'] == -1
	|| $errors['date_naissance_conjoint_m'] == -1
	|| $errors['date_naissance_conjoint_a'] == -1
	||(     ($errors['date_naissance_conjoint_j'] == 0
	      || $errors['date_naissance_conjoint_m'] == 0
	      || $errors['date_naissance_conjoint_a'] == 0)
	   &&   ($datas['statut_marital'] == 2 
	      || $datas['statut_marital'] == 3
	      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_naissance_conjoint_j"><?php echo _T('Date of birth') ?></label>
					<input id="frm_date_naissance_conjoint_j" name="date_naissance_conjoint_j" value="<?php echo $datas['date_naissance_conjoint_j'] ?>" type="text" class="inputText inputDay" /> / 
					<select id="frm_date_naissance_conjoint_m" name="date_naissance_conjoint_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_naissance_conjoint_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_naissance_conjoint_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_naissance_conjoint_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_naissance_conjoint_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_naissance_conjoint_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_naissance_conjoint_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_naissance_conjoint_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_naissance_conjoint_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_naissance_conjoint_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_naissance_conjoint_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_naissance_conjoint_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_naissance_conjoint_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_naissance_conjoint_a" name="date_naissance_conjoint_a" value="<?php echo $datas['date_naissance_conjoint_a'] ?>" type="text" class="inputText inputYear" />
				</div>
				
				<div class="ligne">
<?php 
	if($errors['ville_naissance_conjoint'] == -1
	||($errors['ville_naissance_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_ville_naissance_conjoint"><?php echo _T('City of birth') ?></label>
					<input id="frm_ville_naissance_conjoint" name="ville_naissance_conjoint" value="<?php echo $datas['ville_naissance_conjoint'] ?>" type="text" class="inputText" />
				</div>
<?php
if(false !== strpos('en,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['dep_naissance_conjoint'] == -1
	||($errors['dep_naissance_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_dep_naissance_conjoint"><?php echo _T('County of birth') ?></label>
					<input id="frm_dep_naissance_conjoint" name="dep_naissance_conjoint" value="<?php echo $datas['dep_naissance_conjoint'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('en,gr,de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['nationalite_conjoint'] == -1
	||($errors['nationalite_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_nationalite_conjoint"><?php echo _T('Country of birth') ?></label>
					<select id="frm_nationalite_conjoint" name="nationalite_conjoint">
						<option value="">&nbsp;</option>
						<option <?php if($datas['nationalite_conjoint'] == _T('United Kingdom')) echo 'selected="selected" ' ?>value="<?php echo _T('United Kingdom') ?>"><?php echo _T('United Kingdom') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('European Union')) echo 'selected="selected" ' ?>value="<?php echo _T('European Union') ?>"><?php echo _T('European Union') ?></option>
<?php
	if($lang == 'de')
	{
?>
						<option <?php if($datas['nationalite_conjoint'] == _T('Bosnia')) echo 'selected="selected" ' ?>value="<?php echo _T('Bosnia') ?>"><?php echo _T('Bosnia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Yugoslavia')) echo 'selected="selected" ' ?>value="<?php echo _T('Yugoslavia') ?>"><?php echo _T('Yugoslavia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Croatia')) echo 'selected="selected" ' ?>value="<?php echo _T('Croatia') ?>"><?php echo _T('Croatia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Poland')) echo 'selected="selected" ' ?>value="<?php echo _T('Poland') ?>"><?php echo _T('Poland') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Romania')) echo 'selected="selected" ' ?>value="<?php echo _T('Romania') ?>"><?php echo _T('Romania') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Russia')) echo 'selected="selected" ' ?>value="<?php echo _T('Russia') ?>"><?php echo _T('Russia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Slovacia')) echo 'selected="selected" ' ?>value="<?php echo _T('Slovacia') ?>"><?php echo _T('Slovacia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Slovenia')) echo 'selected="selected" ' ?>value="<?php echo _T('Slovenia') ?>"><?php echo _T('Slovenia') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Czech Republic')) echo 'selected="selected" ' ?>value="<?php echo _T('Czech Republic') ?>"><?php echo _T('Czech Republic') ?></option>
						<option <?php if($datas['nationalite_conjoint'] == _T('Turkish')) echo 'selected="selected" ' ?>value="<?php echo _T('Turkish') ?>"><?php echo _T('Turkish') ?></option>
<?php
	}
?>
						<option <?php if($datas['nationalite_conjoint'] == _T('Other')) echo 'selected="selected" ' ?>value="<?php echo _T('Other') ?>"><?php echo _T('Other') ?></option>
					</select>
				</div>
<?php
}

if(false !== strpos('gr,pl,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['num_compl_identite_conjoint'] == -1
	||($errors['num_compl_identite_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_num_compl_identite_conjoint"><?php echo _T('Tax number') ?></label>
					<input id="frm_num_compl_identite_conjoint" name="num_compl_identite_conjoint" value="<?php echo $datas['num_compl_identite_conjoint'] ?>" type="text" class="inputText" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
	if($errors['num_identite_national_conjoint'] == -1
	||(isset($errors['piece_identite_conjoint']) && $errors['piece_identite_conjoint'] == -1)
	||(     ($errors['num_identite_national_conjoint'] == 0
	      ||(isset($errors['piece_identite_conjoint']) && $errors['piece_identite_conjoint'] == 0))
	   &&   ($datas['statut_marital'] == 2 
	      || $datas['statut_marital'] == 3
	      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_num_identite_national_conjoint"><?php echo _T('Identity number') ?></label>
					<input id="frm_num_identite_national_conjoint" name="num_identite_national_conjoint" value="<?php echo $datas['num_identite_national_conjoint'] ?>" type="text" class="inputText" />
<?php
if(false !== strpos('gr,de',$lang))
{
?>
					<select id="frm_piece_identite_conjoint" name="piece_identite_conjoint">
						<option value="">&nbsp;</option>
						<option <?php if($datas['piece_identite_conjoint'] == _T('Normal ID')) echo 'selected="selected" ' ?>value="<?php echo _T('Normal ID') ?>"><?php echo _T('Normal ID') ?></option>
						<option <?php if($datas['piece_identite_conjoint'] == _T('Military ID')) echo 'selected="selected" ' ?>value="<?php echo _T('Military ID') ?>"><?php echo _T('Military ID') ?></option>
						<option <?php if($datas['piece_identite_conjoint'] == _T('Passport')) echo 'selected="selected" ' ?>value="<?php echo _T('Passport') ?>"><?php echo _T('Passport') ?></option>
					</select>
<?php
}
?>
				</div>
<?php
if(false !== strpos('en,de,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['lieu_obtention_conjoint'] == -1
	||($errors['lieu_obtention_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_lieu_obtention_conjoint"><?php echo _T('Place of delivery') ?></label>
					<input id="frm_lieu_obtention_conjoint" name="lieu_obtention_conjoint" value="<?php echo $datas['lieu_obtention_conjoint'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['date_obtention_conjoint_m'] == -1
	|| $errors['date_obtention_conjoint_a'] == -1
	||(     ($errors['date_obtention_conjoint_m'] == 0
	      || $errors['date_obtention_conjoint_a'] == 0)
	   &&   ($datas['statut_marital'] == 2 
	      || $datas['statut_marital'] == 3
	      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_obtention_conjoint_m"><?php echo _T('Date of issue') ?></label>
					<select id="frm_date_obtention_conjoint_m" name="date_obtention_conjoint_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_obtention_conjoint_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_obtention_conjoint_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_obtention_conjoint_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_obtention_conjoint_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_obtention_conjoint_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_obtention_conjoint_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_obtention_conjoint_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_obtention_conjoint_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_obtention_conjoint_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_obtention_conjoint_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_obtention_conjoint_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_obtention_conjoint_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_obtention_conjoint_a" name="date_obtention_conjoint_a" value="<?php echo $datas['date_obtention_conjoint_a'] ?>" type="text" class="inputText inputYear" />
				</div>
<?php
}
?>
			</fieldset>
			
			<fieldset>
				<legend><?php echo _T('Your address') ?></legend>
				
				<div class="ligne">
<?php 
if($errors['adresse'] == -1
||(isset($_POST['adresse']) && $errors['adresse'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_adresse"><?php echo _T('Address line 1') ?></label>
					<input id="frm_adresse" name="adresse" value="<?php echo $datas['adresse'] ?>" type="text" class="inputText inputAddress" />
				</div>
<?php
if(false !== strpos('en,gr,de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['compl_adresse'] == -1
	||(isset($_POST['compl_adresse']) && $errors['compl_adresse'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_compl_adresse"><?php echo _T('Address line 2') ?></label>
					<input id="frm_compl_adresse" name="compl_adresse" value="<?php echo $datas['compl_adresse'] ?>" type="text" class="inputText inputAddress" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
if($errors['code_postal'] == -1
||(isset($_POST['code_postal']) && $errors['code_postal'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_code_postal"><?php echo _T('Zip Code') ?></label>
					<input id="frm_code_postal" name="code_postal" value="<?php echo $datas['code_postal'] ?>" type="text" class="inputText" />
				</div>
				
				<div class="ligne">
<?php 
if($errors['ville_residence'] == -1
||(isset($_POST['ville_residence']) && $errors['ville_residence'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_ville_residence"><?php echo _T('City') ?></label>
					<input id="frm_ville_residence" name="ville_residence" value="<?php echo $datas['ville_residence'] ?>" type="text" class="inputText" />
				</div>
<?php
if(false !== strpos('en,gr',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['dep_residence'] == -1
	||(isset($_POST['dep_residence']) && $errors['dep_residence'] == 0))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_dep_residence"><?php echo _T('County') ?></label>
					<input id="frm_dep_residence" name="dep_residence" value="<?php echo $datas['dep_residence'] ?>" type="text" class="inputText" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
if($errors['statut_locatif'] == -1
||(isset($_POST['statut_locatif']) && $errors['statut_locatif'] == 0))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_statut_locatif"><?php echo _T('Residence') ?></label>
					<select id="frm_statut_locatif" name="statut_locatif">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['statut_locatif'] == 1) echo ' selected="selected"' ?>><?php echo _T('Owner') ?></option>
						<option value="2"<?php if($datas['statut_locatif'] == 2) echo ' selected="selected"' ?>><?php echo _T('Tenant') ?></option>
						<option value="3"<?php if($datas['statut_locatif'] == 3) echo ' selected="selected"' ?>><?php echo _T('Homed by family') ?></option>
						<option value="4"<?php if($datas['statut_locatif'] == 4) echo ' selected="selected"' ?>><?php echo _T('Homed by employer') ?></option>
						<option value="5"<?php if($datas['statut_locatif'] == 5) echo ' selected="selected"' ?>><?php echo _T('Mortgage in course') ?></option>
<?php
if(false !== strpos('en,gr,hu,de',$lang))
{
?>
						<option value="6"<?php if($datas['statut_locatif'] == 6) echo ' selected="selected"' ?>><?php echo _T('Other') ?></option>
<?php
}
?>
					</select>
				</div>
				
				<div class="ligne">
<?php 
	if($errors['date_location_m'] == -1
	|| $errors['date_location_a'] == -1
	||(isset($_POST['date_location_m']) && $errors['date_location_m'] == 0)
	||(isset($_POST['date_location_a']) && $errors['date_location_a'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_location_m"><?php echo _T('At this address since') ?></label>
					<select id="frm_date_location_m" name="date_location_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_location_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_location_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_location_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_location_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_location_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_location_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_location_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_location_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_location_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_location_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_location_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_location_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_location_a" name="date_location_a" value="<?php echo $datas['date_location_a'] ?>" maxlength="4" type="text" class="inputText inputYear" />
				</div>
				
				<div class="ligne">
<?php 
	if(  ($errors['tel_perso']    == -1
	   && $errors['tel_portable'] == -1
	   &&($lang == 'de' || $errors['tel_pro'] == -1)
	   )
	||   (isset($_POST['tel_perso'])
	   &&(isset($_POST['tel_pro']) || $lang == 'de')
	   && isset($_POST['tel_portable'])
	   && $errors['tel_perso']    == 0
	   &&($lang == 'de' || $errors['tel_pro'] == 0)
	   && $errors['tel_portable'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete one of the following phone fields') ?></p>
<?php
	}
?>
					<label for="frm_tel_perso"><?php echo _T('Home phone number') ?></label>
					<input id="frm_tel_perso" name="tel_perso" value="<?php echo $datas['tel_perso'] ?>" type="text" class="inputText inputTel" />
				</div>
<?php
	if($lang != 'de')
	{
?>
				<div class="ligne">
					<label for="frm_tel_pro"><?php echo _T('Work phone number') ?></label>
					<input id="frm_tel_pro" name="tel_pro" value="<?php echo $datas['tel_pro'] ?>" type="text" class="inputText inputTel" />
				</div>
<?php
	}
?>
				<div class="ligne">
					<label for="frm_tel_portable"><?php echo _T('Mobile phone number') ?></label>
					<input id="frm_tel_portable" name="tel_portable" value="<?php echo $datas['tel_portable'] ?>" type="text" class="inputText inputTel" />
				</div>
				
				<div class="ligne">
<?php 
	if($errors['email'] == -1
	||(isset($_POST['email']) && $errors['email'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_email"><?php echo _T('E-mail address') ?></label>
					<input id="frm_email" name="email" value="<?php echo $datas['email'] ?>" type="text" class="inputText inputEmail" />
				</div>
<?php
if(false !== strpos('en',$lang))
{
?>
				<div class="ligne2">
					<?php echo _T('Mailing list authorised') ?>
<?php 
	if($errors['optin'] == -1
	||(isset($_POST['optin']) && $errors['optin'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thansks to tick-mark here your choice') ?></p>
<?php
	}
?>
					<input id="frm_optin_1" name="optin" value="1" <?php if($datas['optin'] == "1") echo ' checked="checked"' ?>type="radio" class="inputRadio" /><label for="frm_optin_1"><?php echo _T('Yes') ?></label>
					<input id="frm_optin_0" name="optin" value="0" <?php if($datas['optin'] == "0") echo ' checked="checked"' ?>type="radio" class="inputRadio" /><label for="frm_optin_0"><?php echo _T('No') ?></label>
				</div>
<?php
}
?>
			</fieldset>
			
<?php
if('de' == $lang)
{
?>
			<fieldset id="frm_partner_address">
				<legend><?php echo _T('Your co-applicant address') ?></legend>
				
				<div class="ligne">
<?php 
	if($errors['adresse_conjoint'] == -1
	||($errors['adresse_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_adresse_conjoint"><?php echo _T('Address line 1') ?></label>
					<input id="frm_adresse_conjoint" name="adresse_conjoint" value="<?php echo $datas['adresse_conjoint'] ?>" type="text" class="inputText inputAddress" />
				</div>

				<div class="ligne">
<?php 
	if($errors['compl_adresse_conjoint'] == -1
	||($errors['compl_adresse_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_compl_adresse_conjoint"><?php echo _T('Address line 2') ?></label>
					<input id="frm_compl_adresse_conjoint" name="compl_adresse_conjoint" value="<?php echo $datas['compl_adresse_conjoint'] ?>" type="text" class="inputText inputAddress" />
				</div>

				<div class="ligne">
<?php 
	if($errors['code_postal_conjoint'] == -1
	||($errors['code_postal_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_code_postal_conjoint"><?php echo _T('Zip Code') ?></label>
					<input id="frm_code_postal_conjoint" name="code_postal_conjoint" value="<?php echo $datas['code_postal_conjoint'] ?>" type="text" class="inputText" />
				</div>
				
				<div class="ligne">
<?php 
	if($errors['ville_residence_conjoint'] == -1
	||($errors['ville_residence_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_ville_residence_conjoint"><?php echo _T('City') ?></label>
					<input id="frm_ville_residence_conjoint" name="ville_residence_conjoint" value="<?php echo $datas['ville_residence_conjoint'] ?>" type="text" class="inputText" />
				</div>
				
				<div class="ligne">
<?php 
	if(  ($errors['tel_perso_conjoint']    == -1
	   && $errors['tel_portable_conjoint'] == -1)
	||   (isset($_POST['tel_perso_conjoint'])
	   && isset($_POST['tel_portable_conjoint'])
	   && $errors['tel_perso_conjoint']    == 0
	   && $errors['tel_portable_conjoint'] == 0
	   &&   ($datas['statut_marital'] == 2 
	      || $datas['statut_marital'] == 3
	      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete one of the following phone fields') ?></p>
<?php
	}
?>
					<label for="frm_tel_perso_conjoint"><?php echo _T('Home phone number') ?></label>
					<input id="frm_tel_perso_conjoint" name="tel_perso_conjoint" value="<?php echo $datas['tel_perso_conjoint'] ?>" type="text" class="inputText inputTel" />
				</div>
				
				<div class="ligne">
					<label for="frm_tel_portable_conjoint"><?php echo _T('Mobile phone number') ?></label>
					<input id="frm_tel_portable_conjoint" name="tel_portable_conjoint" value="<?php echo $datas['tel_portable_conjoint'] ?>" type="text" class="inputText inputTel" />
				</div>
				
				<div class="ligne">
<?php 
	if($errors['ville_residence_conjoint'] == -1)
	{		
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_email_conjoint"><?php echo _T('E-mail address') ?></label>
					<input id="frm_email_conjoint" name="email_conjoint" value="<?php echo $datas['email_conjoint'] ?>" type="text" class="inputText inputEmail" />
				</div>
			</fieldset>
<?php
}
?>
			
			<fieldset>
				<legend><?php echo _T('Your professional details') ?></legend>			
				
				<div class="ligne">
<?php 
if($errors['categorie_pro'] == -1
||(isset($_POST['categorie_pro']) && $errors['categorie_pro'] == 0))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_sector"><?php echo _T('Sector') ?></label>
					<select id="frm_sector" name="categorie_pro">
						<option value="">&nbsp;</option>
<?php
foreach($csp['basic'] as $v)
{
	echo "\t\t\t\t\t\t", '<option value="', $v, '"';
	if($datas['categorie_pro'] == $v)
		echo ' selected="selected"';
	echo '>', $v, '</option>', "\n";
}
?>
					</select>
				</div>
<?php
if(count($csp) > 1)
{
?>
				<div class="ligne">
<?php 
	if($errors['profession'] == -1
	||(isset($_POST['profession']) && $errors['profession'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_occupation"><?php echo _T('Occupation') ?></label>
					<select id="frm_occupation" name="profession">
						<option value="">&nbsp;</option>
<?php
	foreach($csp['basic'] as $v)
	{
		echo "\t\t\t\t\t\t", '<optgroup label="', $v, '">', "\n";
		
		if(is_array($csp[$v]))
		{
			foreach($csp[$v] as $o)
			{
				echo "\t\t\t\t\t\t\t", '<option value="', $o, '"';
				if($datas['profession'] == $o)
					echo ' selected="selected"';
				echo '>', $o, '</option>', "\n";
			}
		}
		
		echo "\t\t\t\t\t\t", '</optgroup>', "\n";
	}
?>
					</select>
				</div>
<?php
}

if('hu' == $lang)
{
?>
				<div class="ligne">
<?php 
	if($errors['type_contrat'] == -1
	||(isset($_POST['type_contrat']) && $errors['type_contrat'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_type_contrat"><?php echo _T('Type of contract') ?></label>
					<select id="frm_type_contrat" name="type_contrat">
						<option value="">&nbsp;</option>
						<option <?php if($datas['type_contrat'] == _T('Indeterminate')) echo 'selected="selected" ' ?>value="<?php echo _T('Indeterminate') ?>"><?php echo _T('Indeterminate') ?></option>
						<option <?php if($datas['type_contrat'] == _T('Fix')) echo 'selected="selected" ' ?>value="<?php echo _T('Fix') ?>"><?php echo _T('Fix') ?></option>
					</select>
				</div>
<?php
}
?>
<?php
if(false !== strpos('en,gr,de,hu', $lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['employeur'] == -1
	||(isset($_POST['employeur']) && $errors['employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_employeur"><?php echo _T('Employer name') ?></label>
					<input id="frm_employeur" name="employeur" value="<?php echo $datas['employeur'] ?>" type="text" class="inputText" />
				</div>
				
				<div class="ligne">
<?php 
	if($errors['adresse_employeur'] == -1
	||(isset($_POST['adresse_employeur']) && $errors['adresse_employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_adresse_employeur"><?php echo _T('Employer Address line 1') ?></label>
					<input id="frm_adresse_employeur" name="adresse_employeur" value="<?php echo $datas['adresse_employeur'] ?>" type="text" class="inputText inputAddress" />
				</div>	
<?php
}

if(false !== strpos('en,gr', $lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['compl_adresse_employeur'] == -1
	||(isset($_POST['compl_adresse_employeur']) && $errors['compl_adresse_employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_compl_adresse_employeur"><?php echo _T('Address line 2') ?></label>
					<input id="frm_compl_adresse_employeur" id="compl_adresse_employeur" value="<?php echo $datas['compl_adresse_employeur'] ?>" type="text" class="inputText inputAddress" />
				</div>
<?php
}

if(false !== strpos('en,gr,de,hu', $lang))
{
?>				
				<div class="ligne">
<?php 
	if($errors['code_postal_employeur'] == -1
	||(isset($_POST['code_postal_employeur']) && $errors['code_postal_employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_code_postal_employeur"><?php echo _T('Employer Zip Code') ?></label>
					<input id="frm_code_postal_employeur" name="code_postal_employeur" value="<?php echo $datas['code_postal_employeur'] ?>" type="text" class="inputText" />
				</div>	
				
				<div class="ligne">
<?php 
	if($errors['ville_employeur'] == -1
	||(isset($_POST['ville_employeur']) && $errors['ville_employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_ville_employeur"><?php echo _T('Employer City') ?></label>
					<input id="frm_ville_employeur" name="ville_employeur" value="<?php echo $datas['ville_employeur'] ?>" type="text" class="inputText" />
				</div>	
<?php
}

if(false !== strpos('en,gr,de', $lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['dep_employeur'] == -1
	||(isset($_POST['dep_employeur']) && $errors['dep_employeur'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_dep_employeur"><?php echo _T('Employer country') ?></label>
					<input id="frm_dep_employeur" name="dep_employeur" value="<?php echo $datas['dep_employeur'] ?>" type="text" class="inputText" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
if($errors['date_entree_pro_m'] == -1
|| $errors['date_entree_pro_a'] == -1
||(isset($_POST['date_entree_pro_m']) && $errors['date_entree_pro_m'] == 0)
||(isset($_POST['date_entree_pro_a']) && $errors['date_entree_pro_a'] == 0))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_date_entree_pro_m"><?php echo _T('Working for that employer since') ?></label>
					<select id="frm_date_entree_pro_m" name="date_entree_pro_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_entree_pro_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_entree_pro_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_entree_pro_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_entree_pro_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_entree_pro_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_entree_pro_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_entree_pro_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_entree_pro_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_entree_pro_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_entree_pro_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_entree_pro_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_entree_pro_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_entree_pro_a" name="date_entree_pro_a" value="<?php echo $datas['date_entree_pro_a'] ?>" maxlength="4" type="text" class="inputText inputYear" />
				</div>
<?php
if('de' == $lang)
{
?>
				<div class="ligne">
<?php 
	if($errors['date_fin_pro_m'] == -1
	|| $errors['date_fin_pro_a'] == -1
	||(isset($_POST['date_fin_pro_m']) && $errors['date_fin_pro_m'] == 0)
	||(isset($_POST['date_fin_pro_a']) && $errors['date_fin_pro_a'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_fin_pro_m"><?php echo _T('Working for that employer until') ?></label>
					<select id="frm_date_fin_pro_m" name="date_fin_pro_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_fin_pro_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_fin_pro_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_fin_pro_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_fin_pro_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_fin_pro_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_fin_pro_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_fin_pro_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_fin_pro_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_fin_pro_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_fin_pro_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_fin_pro_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_fin_pro_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_fin_pro_a" name="date_fin_pro_a" value="<?php echo $datas['date_fin_pro_a'] ?>" maxlength="4" type="text" class="inputText inputYear" />
				</div>
<?php
}
?>
			</fieldset>

			<fieldset id="frm_partner_professional_details">
				<legend><?php echo _T('Your partner professional details') ?></legend>			
				
				<div class="ligne">
<?php 
if($errors['categorie_pro_conjoint'] == -1
||($errors['categorie_pro_conjoint'] == 0
   && ($datas['statut_marital'] == 2 
       || $datas['statut_marital'] == 3
       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_sector_part"><?php echo _T('Sector') ?></label>
					<select id="frm_sector_part" name="categorie_pro_conjoint">
						<option value="">&nbsp;</option>
<?php
foreach($csp['basic'] as $v)
{
	echo "\t\t\t\t\t\t", '<option value="', $v, '"';
	
	if($datas['categorie_pro_conjoint'] == $v)
		echo ' selected="selected"';
	
	echo '>', $v, '</option>', "\n";
}
?>
					</select>
				</div>
<?php
if(count($csp) > 1)
{
?>
				<div class="ligne">
				<div class="ligne">
<?php
	if($errors['profession_conjoint'] == -1
	||($errors['profession_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_occupation_part"><?php echo _T('Occupation') ?></label>
					<select id="frm_occupation_part" name="profession_conjoint">
						<option value="">&nbsp;</option>
<?php
	foreach($csp['basic'] as $v)
	{
		echo "\t\t\t\t\t\t", '<optgroup label="', $v, '">', "\n";
		
	if(is_array($csp[$v]))
		{
			foreach($csp[$v] as $o)
			{
				echo "\t\t\t\t\t\t\t", '<option value="', $o, '"';
				if($datas['profession_conjoint'] == $o)
					echo ' selected="selected"';
				echo '>', $o, '</option>', "\n";
			}
		}
		echo "\t\t\t\t\t\t", '</optgroup>', "\n";
	}
?>
					</select>
				</div>
<?php
}

if('hu' == $lang)
{
?>
				<div class="ligne">
<?php
	if($errors['type_contrat_conjoint'] == -1
	||($errors['type_contrat_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_type_contrat_conjoint"><?php echo _T('Type of contract') ?></label>
					<select id="frm_type_contrat_conjoint" name="type_contrat_conjoint">
						<option value="">&nbsp;</option>
						<option <?php if($datas['type_contrat_conjoint'] == _T('Indeterminate')) echo 'selected="selected" ' ?>value="<?php echo _T('Indeterminate') ?>"><?php echo _T('Indeterminate') ?></option>
						<option <?php if($datas['type_contrat_conjoint'] == _T('Fix')) echo 'selected="selected" ' ?>value="<?php echo _T('Fix') ?>"><?php echo _T('Fix') ?></option>
					</select>
				</div>
<?php
}
?>
<?php
if(false !== strpos('en,gr,de,hu', $lang))
{
?>
				<div class="ligne">
<?php
	if($errors['employeur_conjoint'] == -1
	||($errors['employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_employeur_conjoint"><?php echo _T('Employer name') ?></label>
					<input id="frm_employeur_conjoint" name="employeur_conjoint" value="<?php echo $datas['employeur_conjoint'] ?>" type="text" class="inputText" />
				</div>
				
				<div class="ligne">
<?php
	if($errors['adresse_employeur_conjoint'] == -1
	||($errors['adresse_employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_adresse_employeur_conjoint"><?php echo _T('Employer Address line 1') ?></label>
					<input id="frm_adresse_employeur_conjoint" name="adresse_employeur_conjoint" value="<?php echo $datas['adresse_employeur_conjoint'] ?>" type="text" class="inputText inputAddress" />
				</div>	
<?php
}

if(false !== strpos('en,gr', $lang))
{
?>
				<div class="ligne">
<?php
	if($errors['compl_adresse_employeur_conjoint'] == -1
	||($errors['compl_adresse_employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_compl_adresse_employeur_conjoint"><?php echo _T('Address line 2') ?></label>
					<input id="frm_compl_adresse_employeur_conjoint" name="compl_adresse_employeur_conjoint" value="<?php echo $datas['compl_adresse_employeur_conjoint'] ?>" type="text" class="inputText inputAddress" />
				</div>
<?php
}

if(false !== strpos('en,gr,de,hu', $lang))
{
?>				
				<div class="ligne">
<?php
	if($errors['code_postal_employeur_conjoint'] == -1
	||($errors['code_postal_employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_code_postal_employeur_conjoint"><?php echo _T('Employer Zip Code') ?></label>
					<input id="frm_code_postal_employeur_conjoint" name="code_postal_employeur_conjoint" value="<?php echo $datas['code_postal_employeur_conjoint'] ?>" type="text" class="inputText" />
				</div>	
				
				<div class="ligne">
<?php
	if($errors['ville_employeur_conjoint'] == -1
	||($errors['ville_employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_ville_employeur_conjoint"><?php echo _T('Employer City') ?></label>
					<input id="frm_ville_employeur_conjoint" name="ville_employeur_conjoint" value="<?php echo $datas['ville_employeur_conjoint'] ?>" type="text" class="inputText" />
				</div>	
<?php
}

if(false !== strpos('en,gr,de', $lang))
{
?>
				<div class="ligne">
<?php
	if($errors['dep_employeur_conjoint'] == -1
	||($errors['dep_employeur_conjoint'] == 0
	   && ($datas['statut_marital'] == 2 
	       || $datas['statut_marital'] == 3
	       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_dep_employeur_conjoint"><?php echo _T('Employer country') ?></label>
					<input id="frm_dep_employeur_conjoint" name="dep_employeur_conjoint" value="<?php echo $datas['dep_employeur_conjoint'] ?>" type="text" class="inputText" />
				</div>
<?php
}
?>
				<div class="ligne">
<?php
if($errors['date_entree_pro_conjoint_m'] == -1
|| $errors['date_entree_pro_conjoint_a'] == -1
||(     ($errors['date_entree_pro_conjoint_m'] == 0
      || $errors['date_entree_pro_conjoint_a'] == 0)
   &&   ($datas['statut_marital'] == 2 
      || $datas['statut_marital'] == 3
      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_date_entree_pro_conjoint_m"><?php echo _T('Working for that employer since') ?></label>
					<select id="frm_date_entree_pro_conjoint_m" name="date_entree_pro_conjoint_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_entree_pro_conjoint_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_entree_pro_conjoint_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_entree_pro_conjoint_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_entree_pro_conjoint_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_entree_pro_conjoint_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_entree_pro_conjoint_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_entree_pro_conjoint_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_entree_pro_conjoint_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_entree_pro_conjoint_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_entree_pro_conjoint_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_entree_pro_conjoint_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_entree_pro_conjoint_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_entree_pro_conjoint_a" name="date_entree_pro_conjoint_a" value="<?php echo $datas['date_entree_pro_conjoint_a'] ?>" maxlength="4" type="text" class="inputText inputYear" />
				</div>
<?php
if('de' == $lang)
{
?>
				<div class="ligne">
<?php
	if($errors['date_fin_pro_conjoint_m'] == -1
	|| $errors['date_fin_pro_conjoint_a'] == -1
	||(     ($errors['date_fin_pro_conjoint_m'] == 0
	      || $errors['date_fin_pro_conjoint_a'] == 0)
	   &&   ($datas['statut_marital'] == 2 
	      || $datas['statut_marital'] == 3
	      ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
	{ 
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_fin_pro_conjoint_m"><?php echo _T('Working for that employer until') ?></label>
					<select id="frm_date_fin_pro_conjoint_m" name="date_fin_pro_conjoint_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_fin_pro_conjoint_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_fin_pro_conjoint_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_fin_pro_conjoint_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_fin_pro_conjoint_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_fin_pro_conjoint_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_fin_pro_conjoint_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_fin_pro_conjoint_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_fin_pro_conjoint_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_fin_pro_conjoint_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_fin_pro_conjoint_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_fin_pro_conjoint_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_fin_pro_conjoint_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_fin_pro_conjoint_a" name="date_fin_pro_conjoint_a" value="<?php echo $datas['date_fin_pro_conjoint_a'] ?>" type="text" class="inputText inputYear" />
				</div>
<?php
}
?>
			</fieldset>

			<fieldset>
				<legend><?php echo _T('Your incomes & expenses') ?></legend>
				
				<h4><?php echo _T('Incomes') ?></h4>			
				<div class="ligne">
<?php 
if($errors['salaire'] == -1
||(isset($_POST['salaire']) && $errors['salaire'] == 0))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_salaire"><?php echo _T('Your net monthly income') ?></label>
					<input id="frm_salaire" name="salaire" value="<?php echo $datas['salaire'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>
<?php 
if(false !== strpos('en,gr,hu',$lang))
{
?>
					<p class="indication">
						<?php echo _T('Monthly salary') ?>
						<br /><?php echo _T('Average per month over a year for liberal profession and pensioner') ?>
					</p>
<?php
}
?>
				</div>
				
				<div class="ligne" id="frm_partner_income">
<?php
if($errors['salaire_conjoint'] == -1
||($errors['salaire_conjoint'] == 0
   && ($datas['statut_marital'] == 2 
       || $datas['statut_marital'] == 3
       ||(isset($datas['type_part_credit']) && $datas['type_part_credit'] > 0))))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_salaire_conjoint"><?php echo _T('Your partner net monthly income') ?></label>
					<input id="frm_salaire_conjoint" name="salaire_conjoint" value="<?php echo $datas['salaire_conjoint'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>	
<?php 
if(false !== strpos('en,gr,hu',$lang))
{
?>
					<p class="indication">
						<?php echo _T('Monthly salary') ?>
						<br /><?php echo _T('Average per month over a year for liberal profession and pensioner') ?>
					</p>
<?php
}
?>
				</div>
				
				<div class="ligne">
<?php 
if($errors['autres_revenus'] == -1
||(isset($_POST['autres_revenus']) && $errors['autres_revenus'] == 0))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_autres_revenus"><?php echo _T('Other incomes') ?></label>
					<input id="frm_autres_revenus" name="autres_revenus" value="<?php echo $datas['autres_revenus'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>
<?php 
if(false !== strpos('en,gr,hu',$lang))
{
?>
					<p class="indication">
						<?php echo _T('Child benefit, properties letting') ?>
					</p>
<?php
}
?>
				</div>
				
				<h4><?php echo _T('Expense') ?></h4>

				<div class="ligne">
<?php 
if($errors['loyer'] == -1
||(isset($_POST['loyer']) && $errors['loyer'] == 0))
{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
}
?>
					<label for="frm_loyer"><?php echo _T('Montly rent / Mortgage instalment') ?></label>
					<input id="frm_loyer" name="loyer" value="<?php echo $datas['loyer'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>
				</div>

				<div class="ligne">
<?php 
	if($errors['credits'] == -1
	||(isset($_POST['credits']) && $errors['credits'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_credits"><?php echo _T('Other running credits') ?></label>
					<input id="frm_credits" name="credits" value="<?php echo $datas['credits'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>
				</div>
<?php
if(false !== strpos('en,gr,pl,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['autres_charges'] == -1
	||(isset($_POST['autres_charges']) && $errors['autres_charges'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_autres_charges"><?php echo _T('Other expenses') ?></label>
					<input id="frm_autres_charges" name="autres_charges" value="<?php echo $datas['autres_charges'] ?>" type="text" class="inputText chiffres" />&nbsp;<?php echo _T('G') ?>
				</div>
			</fieldset>
<?php
}
?>
			<fieldset>
				<legend><?php echo _T('Your banking details') ?></legend>			
				
				<div class="ligne">
<?php 
	if($errors['banque'] == -1
	||(isset($_POST['banque']) && $errors['banque'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_banque"><?php echo _T('Bank name') ?></label>
					<input id="frm_banque" name="banque" value="<?php echo $datas['banque'] ?>" type="text" class="inputText" />
				</div>
<?php
if(false !== strpos('en,de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['code_banque'] == -1
	||(isset($_POST['code_banque']) && $errors['code_banque'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_code_banque"><?php echo _T('Bank sort code') ?></label>
					<input id="frm_code_banque" name="code_banque" value="<?php echo $datas['code_banque'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('en',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['infos_compl'] == -1
	||(isset($_POST['infos_compl']) && $errors['infos_compl'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_infos_compl"><?php echo _T('Branch sort code') ?></label>
					<input id="frm_infos_compl" name="infos_compl" value="<?php echo $datas['infos_compl'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('en,gr,de,hu',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['num_compte'] == -1
	||(isset($_POST['num_compte']) && $errors['num_compte'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_num_compte"><?php echo _T('Account number') ?></label>
					<input id="frm_num_compte" name="num_compte" value="<?php echo $datas['num_compte'] ?>" type="text" class="inputText" />
				</div>
<?php
}

if(false !== strpos('de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['titulaire_compte'] == -1
	||(isset($_POST['titulaire_compte']) && $errors['titulaire_compte'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_titulaire_compte"><?php echo _T('Account owner') ?></label>
					<select id="frm_titulaire_compte" name="titulaire_compte">
						<option value="">&nbsp;</option>
						<option <?php if($datas['titulaire_compte'] == _T('Applicant')) echo 'selected="selected" ' ?>value="<?php echo _T('Applicant') ?>"><?php echo _T('Applicant') ?></option>
						<option <?php if($datas['titulaire_compte'] == _T('Co-Applicant')) echo 'selected="selected" ' ?>value="<?php echo _T('Co-Applicant') ?>"><?php echo _T('Co-Applicant') ?></option>
						<option <?php if($datas['titulaire_compte'] == _T('Account together')) echo 'selected="selected" ' ?>value="<?php echo _T('Account together') ?>"><?php echo _T('Account together') ?></option>
					</select>
				</div>
<?php
}
?>
				<div class="ligne">
<?php 
	if($errors['date_ouverture_compte_m'] == -1
	|| $errors['date_ouverture_compte_a'] == -1
	||(isset($_POST['date_ouverture_compte_m']) && $errors['date_ouverture_compte_m'] == 0)
	||(isset($_POST['date_ouverture_compte_a']) && $errors['date_ouverture_compte_a'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_date_ouverture_compte_m"><?php echo _T('Client in this bank since') ?></label>
					<select id="frm_date_ouverture_compte_m" name="date_ouverture_compte_m">
						<option value="">&nbsp;</option>
						<option value="1"<?php if($datas['date_ouverture_compte_m'] == 1) echo ' selected="selected"' ?>><?php echo _T('January') ?></option>
						<option value="2"<?php if($datas['date_ouverture_compte_m'] == 2) echo ' selected="selected"' ?>><?php echo _T('February') ?></option>
						<option value="3"<?php if($datas['date_ouverture_compte_m'] == 3) echo ' selected="selected"' ?>><?php echo _T('March') ?></option>
						<option value="4"<?php if($datas['date_ouverture_compte_m'] == 4) echo ' selected="selected"' ?>><?php echo _T('April') ?></option>
						<option value="5"<?php if($datas['date_ouverture_compte_m'] == 5) echo ' selected="selected"' ?>><?php echo _T('May') ?></option>
						<option value="6"<?php if($datas['date_ouverture_compte_m'] == 6) echo ' selected="selected"' ?>><?php echo _T('June') ?></option>
						<option value="7"<?php if($datas['date_ouverture_compte_m'] == 7) echo ' selected="selected"' ?>><?php echo _T('July') ?></option>
						<option value="8"<?php if($datas['date_ouverture_compte_m'] == 8) echo ' selected="selected"' ?>><?php echo _T('August') ?></option>
						<option value="9"<?php if($datas['date_ouverture_compte_m'] == 9) echo ' selected="selected"' ?>><?php echo _T('September') ?></option>
						<option value="10"<?php if($datas['date_ouverture_compte_m'] == 10) echo ' selected="selected"' ?>><?php echo _T('October') ?></option>
						<option value="11"<?php if($datas['date_ouverture_compte_m'] == 11) echo ' selected="selected"' ?>><?php echo _T('November') ?></option>
						<option value="12"<?php if($datas['date_ouverture_compte_m'] == 12) echo ' selected="selected"' ?>><?php echo _T('December') ?></option>
					</select> / 
					<input id="frm_date_ouverture_compte_a" name="date_ouverture_compte_a" value="<?php echo $datas['date_ouverture_compte_a'] ?>" maxlength="4" type="text" class="inputText inputYear" />
				</div>
<?php
if(false !== strpos('de',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['infos_compl'] == -1
	||(isset($_POST['infos_compl']) && $errors['infos_compl'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_infos_compl"><?php echo _T('Existing card') ?></label>
					<select id="frm_infos_compl" name="infos_compl">
						<option value="">&nbsp;</option>
						<option <?php if($datas['infos_compl'] == _T('EC/Maestro')) echo 'selected="selected" ' ?>value="<?php echo _T('EC/Maestro') ?>"><?php echo _T('EC/Maestro') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Diners / American Express')) echo 'selected="selected" ' ?>value="<?php echo _T('Diners / American Express') ?>"><?php echo _T('Diners / American Express') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Mastercard')) echo 'selected="selected" ' ?>value="<?php echo _T('Mastercard') ?>"><?php echo _T('Mastercard') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Sonstige')) echo 'selected="selected" ' ?>value="<?php echo _T('Sonstige') ?>"><?php echo _T('Sonstige') ?></option>
						<option <?php if($datas['infos_compl'] == _T('VISA')) echo 'selected="selected" ' ?>value="<?php echo _T('VISA') ?>"><?php echo _T('VISA') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Unknown')) echo 'selected="selected" ' ?>value="<?php echo _T('Unknown') ?>"><?php echo _T('Unknown') ?></option>
					</select>
				</div>
<?php
}
else if(false !== strpos('pl',$lang))
{
?>
				<div class="ligne">
<?php 
	if($errors['infos_compl'] == -1
	||(isset($_POST['infos_compl']) && $errors['infos_compl'] == 0))
	{
?>
					<p class="FormLigneError"><?php echo _T('Thanks to complete the following field') ?></p>
<?php
	}
?>
					<label for="frm_infos_compl"><?php echo _T('Insurance option') ?></label>
					<select id="frm_infos_compl" name="infos_compl">
						<option value="">&nbsp;</option>
						<option <?php if($datas['infos_compl'] == _T('None')) echo 'selected="selected" ' ?>value="<?php echo _T('None') ?>"><?php echo _T('None') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Basic')) echo 'selected="selected" ' ?>value="<?php echo _T('Basic') ?>"><?php echo _T('Basic') ?></option>
						<option <?php if($datas['infos_compl'] == _T('Extended')) echo 'selected="selected" ' ?>value="<?php echo _T('Extended') ?>"><?php echo _T('Extended') ?></option>
					</select>
				</div>
<?php
}
?>
			</fieldset>
			
			<p>
				<?php echo _T('Please') ?>
				<br /><?php echo _T('Confirm here your Credit application') ?>
			</p>
<?php
if($lang == 'gr')
{
?>
			<p class="legalStuf"><?php echo _T('legal mentions for the instalement loan') ?></p>
			
			<div class="ligne2">
<?php 
	if($errors['_chk_in'] == -1
	||(isset($_POST['btnBdd']) && $errors['_chk_in'] == 0))
	{
?>
					<p class="FormLigneError"></p>
<?php
	}
?>
					<label for="frm_chk_in"></label><input id="frm_chk_in" name="_chk_in" value="1" <?php if($datas['_chk_in'] == "1") echo ' checked="checked"' ?>type="checkbox" class="inputRadio" />
				</div>
<?php
	}
?>
			<div class="boutons">
				<input class="btSuivant" type="submit" name="btnBdd" value="<?php echo _T('Validate'); ?>" />
			</div>
		</form>
	</div><!-- /pageIn -->
	<div class="pageBottom"></div>
</div>

</body>
</html>