/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.text.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPModelUtil {
    public static final String PHPDOC_CLASS_NAME_SEPARATOR = "\\|";

    public static PHPFunctionData getRealConstructor(PHPProjectModel pHPProjectModel, String string, PHPClassData pHPClassData) {
        if (pHPClassData.hasConstructor()) {
            return pHPClassData.getConstructor();
        }
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, pHPClassData.getName(), "__construct");
        if (codeData != null) {
            return (PHPFunctionData)codeData;
        }
        return pHPClassData.getConstructor();
    }

    public static PHPFunctionData getRealDestructor(PHPProjectModel pHPProjectModel, String string, PHPClassData pHPClassData) {
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, pHPClassData.getName(), "__destruct");
        if (codeData != null) {
            return (PHPFunctionData)codeData;
        }
        return null;
    }

    public static String getFunctionReturnType(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        if (string2 == null) {
            CodeData[] codeDataArray;
            PHPFunctionData pHPFunctionData = pHPProjectModel.getFunction(string, string3);
            if (pHPFunctionData != null) {
                return pHPFunctionData.getReturnType();
            }
            CodeData[] codeDataArray2 = codeDataArray = pHPProjectModel.getFunctions();
            int n = codeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData codeData = codeDataArray2[n2];
                if (codeData.getName().equals(string3) && codeData instanceof PHPFunctionData) {
                    return ((PHPFunctionData)codeData).getReturnType();
                }
                ++n2;
            }
            return null;
        }
        String[] stringArray = string2.split(PHPDOC_CLASS_NAME_SEPARATOR);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String string4 = stringArray2[n3];
            CodeData codeData = pHPProjectModel.getClassFunctionData(string, string4 = string4.trim(), string3);
            if (codeData != null) {
                if (codeData instanceof PHPFunctionData) {
                    linkedHashSet.add(((PHPFunctionData)codeData).getReturnType());
                }
            } else {
                PHPClassData pHPClassData = pHPProjectModel.getClass(string, string4);
                if (pHPClassData != null) {
                    String string5;
                    String string6 = null;
                    PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
                    if (pHPSuperClassNameData != null && (string5 = pHPSuperClassNameData.getName()) != null) {
                        string6 = PHPModelUtil.getFunctionReturnType(pHPProjectModel, string, string5, string3);
                    }
                    if (string6 != null) {
                        linkedHashSet.add(string6);
                    }
                }
            }
            ++n3;
        }
        return StringUtils.implodeStrings(linkedHashSet, "|");
    }

    public static String getVarType(PHPProjectModel pHPProjectModel, String string, String string2, String string3, int n, int n2, boolean bl) {
        String string4 = PHPFileDataUtilities.getVariableType(string, "this;*" + string3, n, n2, (IPhpModel)pHPProjectModel.getPHPUserModel(), bl);
        if (string4 != null) {
            return string4;
        }
        String[] stringArray = string2.split(PHPDOC_CLASS_NAME_SEPARATOR);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string5 = stringArray2[n4];
            CodeData codeData = pHPProjectModel.getClassVariablesData(string, string5 = string5.trim(), string3);
            if (codeData != null) {
                if (codeData instanceof PHPClassVarData) {
                    linkedHashSet.add(((PHPClassVarData)codeData).getClassType());
                }
            } else {
                String string6;
                PHPClassData.PHPSuperClassNameData pHPSuperClassNameData;
                PHPClassData pHPClassData = pHPProjectModel.getClass(string, string5);
                if (pHPClassData != null && (pHPSuperClassNameData = pHPClassData.getSuperClassData()) != null && (string6 = PHPModelUtil.getVarType(pHPProjectModel, string, pHPSuperClassNameData.getName(), string3, n, n2, bl)) != null) {
                    linkedHashSet.add(string6);
                }
            }
            ++n4;
        }
        return StringUtils.implodeStrings(linkedHashSet, "|");
    }

    public static PHPCodeData getElementAt(PHPCodeData pHPCodeData, int n) {
        throw new RuntimeException("test me");
    }

    public static Object getExternalResource(Object object, IProject iProject) {
        if (!(object instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)object;
        PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPCodeData);
        if (pHPFileData == null) {
            return null;
        }
        String string = pHPFileData.getName();
        File file = new File(string);
        if (file != null && file.exists()) {
            return file;
        }
        PHPProjectModel pHPProjectModel = null;
        if (iProject == null) {
            PHPProjectModel[] pHPProjectModelArray;
            string = pHPFileData.getName();
            PHPProjectModel[] pHPProjectModelArray2 = pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = pHPProjectModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPProjectModel pHPProjectModel2 = pHPProjectModelArray2[n2];
                if (pHPProjectModel2.getFileData(string) == pHPFileData) {
                    pHPProjectModel = pHPProjectModel2;
                    break;
                }
                ++n2;
            }
        } else {
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        if (pHPProjectModel == null) {
            return null;
        }
        return pHPProjectModel.getExternalResource(pHPFileData);
    }

    public static CodeData[] getMatchingClasses(IPhpModel iPhpModel, String string) {
        return iPhpModel.getClass(string.toLowerCase());
    }

    public static PHPCodeData[] getMatchingElements(IPhpModel iPhpModel, String string) {
        PHPFunctionData[] pHPFunctionDataArray;
        int n;
        CodeData[] codeDataArray = PHPModelUtil.getMatchingClasses(iPhpModel, string);
        int n2 = codeDataArray.length;
        if (n2 + (n = (pHPFunctionDataArray = PHPModelUtil.getMatchingFunctions(iPhpModel, string)).length) == 0) {
            return new PHPCodeData[0];
        }
        ArrayList arrayList = new ArrayList(n2 + n);
        if (n2 > 0) {
            arrayList.addAll(Arrays.asList(codeDataArray));
        }
        if (n > 0) {
            arrayList.addAll(Arrays.asList(pHPFunctionDataArray));
        }
        return arrayList.toArray(new PHPCodeData[0]);
    }

    public static PHPFunctionData[] getMatchingFunctions(IPhpModel iPhpModel, String string) {
        CodeData[] codeDataArray = iPhpModel.getFunctions(string);
        ArrayList<PHPFunctionData> arrayList = new ArrayList<PHPFunctionData>(1);
        int n = 0;
        while (n < codeDataArray.length) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)codeDataArray[n];
            if (string.equalsIgnoreCase(pHPFunctionData.getName())) {
                arrayList.add(pHPFunctionData);
            }
            ++n;
        }
        return arrayList.toArray(new PHPFunctionData[0]);
    }

    public static int getModifier(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getModifiers();
        }
        if (pHPCodeData instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)pHPCodeData;
            return pHPFunctionData.getModifiers();
        }
        if (pHPCodeData instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)pHPCodeData;
            return pHPClassVarData.getModifiers();
        }
        return 0;
    }

    public static Object getParent(Object object) {
        if (object instanceof IResource) {
            if (object instanceof IProject) {
                return PHPWorkspaceModelManager.getInstance();
            }
            IContainer iContainer = ((IResource)object).getParent();
            boolean cfr_ignored_0 = iContainer instanceof IProject;
            return iContainer;
        }
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = ((PHPCodeData)object).getContainer();
            if (pHPCodeData == null && object instanceof PHPFileData) {
                IResource iResource = PHPModelUtil.getResource(object);
                if (iResource == null) {
                    return pHPCodeData;
                }
                IContainer iContainer = iResource.getParent();
                if (iContainer.exists()) {
                    return iContainer;
                }
            }
            return pHPCodeData;
        }
        if (object instanceof PHPProjectModel) {
            return PHPWorkspaceModelManager.getInstance();
        }
        return null;
    }

    public static PHPFileData getPHPFile(IFile iFile) {
        PHPFileData pHPFileData;
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
        if (pHPProjectModel != null && (pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toString())) != null) {
            return pHPFileData;
        }
        return null;
    }

    public static PHPFileData getPHPFileContainer(PHPCodeData pHPCodeData) {
        UserData userData;
        if (pHPCodeData instanceof PHPFileData) {
            return (PHPFileData)pHPCodeData;
        }
        PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
        while (pHPCodeData2 != null && !(pHPCodeData2 instanceof PHPFileData)) {
            pHPCodeData2 = pHPCodeData2.getContainer();
        }
        if (pHPCodeData2 == null && (userData = pHPCodeData.getUserData()) != null) {
            Path path = new Path(userData.getFileName());
            pHPCodeData2 = PHPWorkspaceModelManager.getInstance().getModelForFile(path.toString());
        }
        return (PHPFileData)pHPCodeData2;
    }

    public static IContainer getPHPFolderRoot(PHPCodeData pHPCodeData) {
        IResource iResource = PHPModelUtil.getResource(pHPCodeData);
        return iResource != null ? iResource.getProject() : null;
    }

    public static IResource getResource(Object object) {
        if (object instanceof PHPCodeData) {
            UserData userData;
            PHPFileData pHPFileData = null;
            if (!(object instanceof PHPFileData)) {
                pHPFileData = PHPModelUtil.getPHPFileContainer((PHPCodeData)object);
            }
            PHPFileData pHPFileData2 = pHPFileData;
            String string = null;
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            if (pHPFileData2 != null) {
                string = pHPFileData2.getName();
            } else if (pHPCodeData.getUserData() != null) {
                userData = pHPCodeData.getUserData();
                string = userData.getFileName();
            } else {
                return null;
            }
            userData = new Path(string);
            if (userData.segmentCount() < 2) {
                return null;
            }
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)userData);
            if (iResource == null && ExternalFilesRegistry.getInstance().isEntryExist(new Path(string).toOSString())) {
                iResource = ExternalFilesRegistry.getInstance().getFileEntry(new Path(string).toOSString());
            }
            return iResource;
        }
        if (object instanceof PHPProjectModel) {
            PHPProjectModel pHPProjectModel = (PHPProjectModel)object;
            IProject iProject = pHPProjectModel.getProject();
            if (iProject == null) {
                iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
            }
            return iProject;
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        return null;
    }

    public static PHPClassData getSuperClass(PHPClassData pHPClassData) {
        PHPProjectModel pHPProjectModel;
        PHPProjectModel[] pHPProjectModelArray;
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return null;
        }
        String string = pHPSuperClassNameData.getName();
        if (string == null) {
            return null;
        }
        PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPClassData);
        String string2 = null;
        if (pHPFileData != null) {
            string2 = pHPFileData.getName();
        }
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        PHPClassData pHPClassData2 = null;
        PHPProjectModel pHPProjectModel2 = null;
        IProject iProject = null;
        IResource iResource = PHPModelUtil.getResource(pHPClassData);
        if (iResource != null) {
            iProject = iResource.getProject();
            pHPProjectModel2 = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
            if (pHPProjectModel2 != null && (pHPClassData2 = pHPProjectModel2.getClass(iResource.getName(), string)) != null) {
                return pHPClassData2;
            }
        }
        PHPProjectModel[] pHPProjectModelArray2 = pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
        int n = pHPProjectModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            pHPProjectModel = pHPProjectModelArray2[n2];
            if (pHPProjectModel.getFileData(string2) == pHPFileData && (pHPClassData2 = pHPProjectModel.getClass(string2, string)) != null) {
                return pHPClassData2;
            }
            ++n2;
        }
        pHPProjectModelArray2 = pHPProjectModelArray;
        n = pHPProjectModelArray.length;
        n2 = 0;
        while (n2 < n) {
            pHPProjectModel = pHPProjectModelArray2[n2];
            pHPClassData2 = pHPProjectModel.getClass(string2, string);
            if (pHPClassData2 != null) {
                return pHPClassData2;
            }
            ++n2;
        }
        return null;
    }

    public static PHPClassData[] getInterfaces(PHPClassData pHPClassData) {
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = pHPClassData.getInterfacesNamesData();
        int n = pHPInterfaceNameDataArray.length;
        ArrayList<PHPClassData> arrayList = new ArrayList<PHPClassData>();
        int n2 = 0;
        while (n2 < n) {
            String string;
            if (pHPInterfaceNameDataArray[n2] != null && (string = pHPInterfaceNameDataArray[n2].getName()) != null) {
                PHPProjectModel[] pHPProjectModelArray;
                PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPClassData);
                String string2 = null;
                if (pHPFileData != null) {
                    string2 = pHPFileData.getName();
                }
                if ("".equals(string2)) {
                    string2 = null;
                }
                PHPClassData pHPClassData2 = null;
                IResource iResource = PHPModelUtil.getResource(pHPClassData);
                if (iResource != null) {
                    pHPProjectModelArray = iResource.getProject();
                    PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)pHPProjectModelArray);
                    if (pHPProjectModel != null && (pHPClassData2 = pHPProjectModel.getClass(iResource.getName(), string)) != null) {
                        arrayList.add(pHPClassData2);
                    }
                } else {
                    PHPProjectModel pHPProjectModel;
                    pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
                    boolean bl = false;
                    PHPProjectModel[] pHPProjectModelArray2 = pHPProjectModelArray;
                    int n3 = pHPProjectModelArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        pHPProjectModel = pHPProjectModelArray2[n4];
                        if (pHPProjectModel.getFileData(string2) == pHPFileData && (pHPClassData2 = pHPProjectModel.getClass(string2, string)) != null) {
                            arrayList.add(pHPClassData2);
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        pHPProjectModelArray2 = pHPProjectModelArray;
                        n3 = pHPProjectModelArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            pHPProjectModel = pHPProjectModelArray2[n4];
                            pHPClassData2 = pHPProjectModel.getClass(string2, string);
                            if (pHPClassData2 != null) {
                                arrayList.add(pHPClassData2);
                            }
                            ++n4;
                        }
                    }
                }
            }
            ++n2;
        }
        PHPClassData[] pHPClassDataArray = new PHPClassData[arrayList.size()];
        arrayList.toArray(pHPClassDataArray);
        return pHPClassDataArray;
    }

    public static PHPProjectModel getProjectModelForFile(PHPFileData pHPFileData) {
        PHPProjectModel pHPProjectModel = null;
        IProject iProject = (IProject)PHPModelUtil.getPHPFolderRoot(pHPFileData);
        if (iProject != null) {
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        if (pHPProjectModel == null) {
            PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                if (pHPProjectModelArray[n].getFileData(pHPFileData.getName()) == pHPFileData) {
                    pHPProjectModel = pHPProjectModelArray[n];
                    break;
                }
                ++n;
            }
        }
        return pHPProjectModel;
    }

    public static IPhpModel getIncludeModelForFile(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData) {
        PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel("CompositeIncludePathModel");
        if (pHPIncludePathModelManager == null) {
            return null;
        }
        IPhpModel[] iPhpModelArray = pHPIncludePathModelManager.listModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            if (iPhpModelArray[n].getFileData(pHPFileData.getName()) == pHPFileData) {
                return iPhpModelArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean hasChildren(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPFunctionData) {
            return false;
        }
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getFunctions().length > 0 || pHPClassData.getVars().length > 0 || pHPClassData.getConsts().length > 0;
        }
        return !(pHPCodeData instanceof PHPVariableData) && !(pHPCodeData instanceof PHPKeywordData) && !(pHPCodeData instanceof PHPConstantData) && !(pHPCodeData instanceof PHPClassConstData) && !(pHPCodeData instanceof PHPIncludeFileData);
    }

    public static boolean hasPhpExtention(IFile iFile) {
        String[] stringArray;
        String string = iFile.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        if (iFile instanceof ExternalFileWrapper) {
            int n2 = string2.indexOf(58);
            string2 = n2 > 0 ? string2.substring(0, n2) : string2;
        }
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray2 = stringArray = iContentType.getFileSpecs(8);
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string3 = stringArray2[n4];
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData pHPClassData, PHPClassData pHPClassData2) {
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return false;
        }
        String string = pHPSuperClassNameData.getName();
        if (string == null) {
            return false;
        }
        PHPClassData pHPClassData3 = pHPClassData;
        while ((pHPClassData3 = PHPModelUtil.getSuperClass(pHPClassData3)) != null) {
            if (pHPClassData3 != pHPClassData2) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData pHPClassData, String string) {
        return PHPModelUtil.discoverSuperClass(pHPClassData, string) != null || string.equalsIgnoreCase(PHPModelUtil.getSuperClassName(pHPClassData));
    }

    public static String getSuperClassName(PHPClassData pHPClassData) {
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData != null) {
            return pHPSuperClassNameData.getName();
        }
        return null;
    }

    public static PHPClassData discoverSuperClass(PHPClassData pHPClassData, String string) {
        String string2 = PHPModelUtil.getSuperClassName(pHPClassData);
        if (string2 == null) {
            return null;
        }
        PHPClassData pHPClassData2 = pHPClassData;
        HashSet<PHPClassData> hashSet = new HashSet<PHPClassData>();
        hashSet.add(pHPClassData2);
        while ((pHPClassData2 = PHPModelUtil.getSuperClass(pHPClassData2)) != null) {
            if (hashSet.contains(pHPClassData2)) {
                return null;
            }
            string2 = pHPClassData2.getName();
            if (string2 == null) {
                return null;
            }
            if (string2.compareToIgnoreCase(string) == 0) {
                return pHPClassData2;
            }
            hashSet.add(pHPClassData2);
        }
        return null;
    }

    public static PHPClassData discoverInterface(PHPClassData pHPClassData, String string) {
        PHPClassData[] pHPClassDataArray = PHPModelUtil.getInterfaces(pHPClassData);
        int n = 0;
        while (n < pHPClassDataArray.length) {
            if (pHPClassDataArray[n].getName() != null && pHPClassDataArray[n].getName().equalsIgnoreCase(string)) {
                return pHPClassDataArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean isExternal(Object object) {
        return false;
    }

    public static boolean isPhpFile(IFile iFile) {
        IContentDescription iContentDescription = null;
        if (!iFile.exists()) {
            return PHPModelUtil.hasPhpExtention(iFile);
        }
        try {
            iContentDescription = iFile.getContentDescription();
        }
        catch (CoreException coreException) {
            return PHPModelUtil.hasPhpExtention(iFile);
        }
        if (iContentDescription == null) {
            return PHPModelUtil.hasPhpExtention(iFile);
        }
        return ContentTypeIdForPHP.ContentTypeID_PHP.equals(iContentDescription.getContentType().getId());
    }

    public static boolean isReadOnly(Object object) {
        return false;
    }

    public static String getRelativeLocation(IPhpModel iPhpModel, String string) {
        PHPFileData pHPFileData = iPhpModel.getFileData(string);
        if (pHPFileData != null) {
            IResource iResource = PHPModelUtil.getResource(pHPFileData);
            if (iResource != null && iResource.exists()) {
                IProject iProject = iResource.getProject();
                if (iProject.isAccessible()) {
                    return new Path(string).removeFirstSegments(1).toString();
                }
            } else if (iPhpModel instanceof PHPProjectModel) {
                IPhpModel iPhpModel2 = PHPModelUtil.getIncludeModelForFile((PHPProjectModel)iPhpModel, pHPFileData);
                IPath iPath = PHPModelUtil.getIncludeModelLocation(iPhpModel2);
                if (iPhpModel2.getFileData(string) == pHPFileData) {
                    return new Path(string).setDevice("").removeFirstSegments(iPath.segmentCount()).toString();
                }
            }
        } else {
            Path path = new Path(string);
            if (iPhpModel instanceof PHPProjectModel) {
                String string2 = path.segment(0);
                if (string2.equals(((PHPProjectModel)iPhpModel).getProject().getName())) {
                    return path.removeFirstSegments(1).makeRelative().toString();
                }
                PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)((PHPProjectModel)iPhpModel).getModel("CompositeIncludePathModel");
                if (pHPIncludePathModelManager.getModel(string2) != null) {
                    return path.removeFirstSegments(1).makeRelative().toString();
                }
                if (ResourcesPlugin.getWorkspace().getRoot().getProject(string2) != null) {
                    return path.removeFirstSegments(1).makeRelative().toString();
                }
            }
        }
        return string;
    }

    public static String getRelativeLocation(IProject iProject, String string) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel == null) {
            return string;
        }
        return PHPModelUtil.getRelativeLocation(pHPProjectModel, string);
    }

    public static PHPFileData getFileData(Object object) {
        PHPFileData pHPFileData = null;
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if (!PHPModelUtil.isPhpFile(iFile)) {
                return null;
            }
            pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile.getFullPath().toString());
        }
        if (object instanceof PHPFileData) {
            pHPFileData = (PHPFileData)object;
        }
        return pHPFileData;
    }

    public static ArrayList<PHPFunctionData> getFunctionsToOverride(IProject iProject, PHPClassData pHPClassData, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3) {
        ArrayList<PHPFunctionData> arrayList4 = new ArrayList<PHPFunctionData>();
        if (pHPClassData != null) {
            int n;
            PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
            if (pHPClassData.getUserData() != null) {
                String string = pHPClassData.getUserData().getFileName();
                if (!arrayList2.contains(string = PHPModelUtil.getRelativeLocation(iProject, string))) {
                    arrayList2.add(string);
                    arrayList3.add(string);
                }
            }
            int n2 = pHPFunctionDataArray.length;
            if (PHPModifier.isInterface(pHPClassData.getModifiers())) {
                n = 0;
                while (n < n2) {
                    if (!arrayList.contains(pHPFunctionDataArray[n].getName())) {
                        arrayList4.add(pHPFunctionDataArray[n]);
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    }
                    ++n;
                }
            } else if (PHPModifier.isAbstract(pHPClassData.getModifiers())) {
                n = 0;
                while (n < n2) {
                    if (!PHPModifier.isAbstract(pHPFunctionDataArray[n].getModifiers())) {
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    } else if (!arrayList.contains(pHPFunctionDataArray[n].getName())) {
                        arrayList4.add(pHPFunctionDataArray[n]);
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < n2) {
                    if (!arrayList.contains(pHPFunctionDataArray[n].getName())) {
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    }
                    ++n;
                }
            }
            if (pHPClassData.getSuperClassData() != null && pHPClassData.getSuperClassData().getName() != null) {
                PHPClassData pHPClassData2 = PHPModelUtil.getSuperClass(pHPClassData);
                ArrayList<PHPFunctionData> arrayList5 = PHPModelUtil.getFunctionsToOverride(iProject, pHPClassData2, arrayList, arrayList2, arrayList3);
                arrayList4.addAll(arrayList5);
                Iterator<PHPFunctionData> iterator = arrayList5.iterator();
                while (iterator.hasNext()) {
                    arrayList4.add(iterator.next());
                }
            }
            if (pHPClassData.getInterfacesNamesData() != null && pHPClassData.getInterfacesNamesData().length > 0) {
                PHPClassData[] pHPClassDataArray = PHPModelUtil.getInterfaces(pHPClassData);
                int n3 = pHPClassDataArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ArrayList<PHPFunctionData> arrayList6 = PHPModelUtil.getFunctionsToOverride(iProject, pHPClassDataArray[n4], arrayList, arrayList2, arrayList3);
                    arrayList4.addAll(arrayList6);
                    ++n4;
                }
            }
        }
        return arrayList4;
    }

    public static IPath getIncludeModelLocation(IPhpModel iPhpModel) {
        Object object;
        if (iPhpModel instanceof PHPIncludePathModel && ((PHPIncludePathModel)(object = (PHPIncludePathModel)iPhpModel)).getType() == PHPIncludePathModel.IncludePathModelType.VARIABLE) {
            return IncludePathVariableManager.instance().getIncludePathVariable(iPhpModel.getID());
        }
        object = iPhpModel.getID();
        if (object != null) {
            return new Path((String)object);
        }
        return null;
    }

    public static IPath getFileDataShortPath(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData) {
        Path path;
        IPhpModel iPhpModel = PHPModelUtil.getIncludeModelForFile(pHPProjectModel, pHPFileData);
        if (iPhpModel != null) {
            IPath iPath = PHPModelUtil.getIncludeModelLocation(iPhpModel);
            path = new Path(iPhpModel.getID()).append(new Path(pHPFileData.getName()).removeFirstSegments(iPath.segmentCount()));
        } else {
            path = new Path(pHPFileData.getName());
        }
        return path;
    }

    public static class PHPContainerStringConverter {
        public static Object toContainer(String string) {
            PHPFileData pHPFileData;
            IPath iPath = Path.fromPortableString((String)string);
            if (iPath == null) {
                return null;
            }
            IFile iFile = null;
            try {
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (iFile != null && (pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile, false)) != null) {
                return pHPFileData;
            }
            pHPFileData = null;
            try {
                pHPFileData = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (pHPFileData != null) {
                return pHPFileData;
            }
            IProject iProject = null;
            try {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.segments()[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return iProject;
        }

        public static String toString(Object object) {
            IPath iPath;
            if (object instanceof PHPCodeData) {
                while (object != null && !(object instanceof PHPFileData)) {
                    object = ((PHPCodeData)object).getContainer();
                }
            }
            if (object == null) {
                return "";
            }
            IResource iResource = PHPModelUtil.getResource(object);
            if (iResource != null && (iPath = iResource.getFullPath()) != null) {
                return iPath.toPortableString();
            }
            return "";
        }
    }
}

