/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        this.fWorkingSet = iWorkingSet;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        if (this.fWorkingSet == null) {
            return true;
        }
        if (object2 instanceof PHPCodeData) {
            return this.isEnclosing((PHPCodeData)object2);
        }
        if (object2 instanceof IResource) {
            return this.isEnclosing(((IResource)object2).getFullPath());
        }
        if (object2 instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object2;
            PHPCodeData pHPCodeData = (PHPCodeData)iAdaptable.getAdapter(PHPCodeData.class);
            if (pHPCodeData != null) {
                return this.isEnclosing(pHPCodeData);
            }
            IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
            if (iResource != null) {
                return this.isEnclosing(iResource.getFullPath());
            }
        }
        return true;
    }

    public Object[] filter(Viewer viewer, Object object, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            objectArray2 = super.filter(viewer, object, objectArray);
        }
        finally {
            this.fCachedWorkingSet = null;
        }
        return objectArray2;
    }

    private boolean isEnclosing(IPath iPath) {
        if (iPath == null) {
            return false;
        }
        IAdaptable[] iAdaptableArray = this.fCachedWorkingSet;
        if (iAdaptableArray == null) {
            iAdaptableArray = this.fWorkingSet.getElements();
        }
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.isEnclosing(iAdaptableArray[n2], iPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isEnclosing(PHPCodeData pHPCodeData) {
        IAdaptable[] iAdaptableArray = this.fCachedWorkingSet;
        if (iAdaptableArray == null) {
            iAdaptableArray = this.fWorkingSet.getElements();
        }
        boolean bl = false;
        IPath iPath = null;
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPCodeData pHPCodeData2 = (PHPCodeData)iAdaptableArray[n2].getAdapter(PHPCodeData.class);
            if (pHPCodeData2 != null) {
                PHPCodeData pHPCodeData3 = pHPCodeData;
                while (pHPCodeData2 != null && pHPCodeData3 != null) {
                    if (pHPCodeData3.equals(pHPCodeData2)) {
                        return true;
                    }
                    pHPCodeData3 = pHPCodeData3.getContainer();
                }
                while (pHPCodeData2 != null && pHPCodeData != null) {
                    if (pHPCodeData.equals(pHPCodeData2)) {
                        return true;
                    }
                    pHPCodeData2 = pHPCodeData2.getContainer();
                }
            } else {
                if (!bl) {
                    iPath = PHPModelUtil.getResource((Object)pHPCodeData).getFullPath();
                }
                if (this.isEnclosing(iAdaptableArray[n2], iPath)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable iAdaptable, IPath iPath) {
        PHPCodeData pHPCodeData;
        if (iPath == null) {
            return false;
        }
        IPath iPath2 = null;
        IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
        if (iResource != null) {
            iPath2 = iResource.getFullPath();
        }
        if (iPath2 == null && (pHPCodeData = (PHPCodeData)iAdaptable.getAdapter(PHPCodeData.class)) != null) {
            iPath2 = PHPModelUtil.getResource((Object)pHPCodeData).getFullPath();
        }
        if (iPath2 == null && iAdaptable instanceof IStorage) {
            iPath2 = ((IStorage)iAdaptable).getFullPath();
        }
        if (iPath2 == null) {
            return false;
        }
        if (iPath2.isPrefixOf(iPath)) {
            return true;
        }
        return iPath.isPrefixOf(iPath2);
    }
}

