/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.ui.treecontent.IncludesNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PathMapperEntryDialog
extends StatusDialog {
    private PathMapper.Mapping fEditData;
    private Text fRemotePathText;
    private Button fWorkspacePathBtn;
    private Button fExternalPathBtn;
    private Text fWorkspacePathText;
    private Text fExternalPathText;
    private Button fWorkspacePathBrowseBtn;
    private Button fExternalPathBrowseBtn;

    public PathMapperEntryDialog(Shell shell) {
        this(shell, null);
    }

    public PathMapperEntryDialog(Shell shell, PathMapper.Mapping mapping) {
        super(shell);
        if (mapping != null) {
            this.fEditData = mapping.clone();
            this.setTitle("Edit Path Mapping");
        } else {
            this.setTitle("Add new Path Mapping");
        }
    }

    public PathMapper.Mapping getResult() {
        return this.fEditData;
    }

    protected Control createDialogArea(Composite composite) {
        composite = (Composite)super.createDialogArea(composite);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Path on Server:");
        this.fRemotePathText = new Text(composite, 2048);
        this.fRemotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PathMapperEntryDialog.this.validate();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fRemotePathText.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.fWorkspacePathBtn = new Button(composite2, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fWorkspacePathBtn.setLayoutData((Object)gridData);
        this.fWorkspacePathBtn.setText("Path in &Workspace");
        this.fWorkspacePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PathMapperEntryDialog.this.fWorkspacePathBtn.getSelection();
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(bl);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(bl);
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(!bl);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(!bl);
            }
        });
        this.fWorkspacePathText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fWorkspacePathText.setLayoutData((Object)gridData);
        this.fWorkspacePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fWorkspacePathBrowseBtn = new Button(composite2, 0);
        this.fWorkspacePathBrowseBtn.setText("&Browse");
        this.fWorkspacePathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkspaceBrowseDialog workspaceBrowseDialog = new WorkspaceBrowseDialog(PathMapperEntryDialog.this.getShell());
                if (workspaceBrowseDialog.open() == 0) {
                    Object object = workspaceBrowseDialog.getSelectedElement();
                    PathMapperEntryDialog.this.fWorkspacePathText.setData(null);
                    if (object instanceof IResource) {
                        IResource iResource = (IResource)object;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)PathEntry.Type.WORKSPACE);
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(iResource.getFullPath().toString());
                    } else if (object instanceof IIncludePathEntry) {
                        IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(iIncludePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        if (iIncludePathEntry.getEntryKind() == 4) {
                            IPath iPath = IncludePathVariableManager.instance().resolveVariablePath(iIncludePathEntry.getPath().toString());
                            if (iPath != null) {
                                PathMapperEntryDialog.this.fWorkspacePathText.setText(iPath.toOSString());
                            }
                        } else {
                            PathMapperEntryDialog.this.fWorkspacePathText.setText(iIncludePathEntry.getPath().toOSString());
                        }
                    } else if (object instanceof WorkspaceBrowseDialog.IPFile) {
                        WorkspaceBrowseDialog.IPFile iPFile = (WorkspaceBrowseDialog.IPFile)object;
                        IIncludePathEntry iIncludePathEntry = iPFile.includePathEntry;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(iIncludePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(iPFile.file.getAbsolutePath());
                    }
                }
            }
        });
        this.fExternalPathBtn = new Button(composite2, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fExternalPathBtn.setLayoutData((Object)gridData);
        this.fExternalPathBtn.setText("Path in &File System");
        this.fExternalPathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PathMapperEntryDialog.this.fExternalPathBtn.getSelection();
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(bl);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(bl);
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(!bl);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(!bl);
            }
        });
        this.fExternalPathText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fExternalPathText.setLayoutData((Object)gridData);
        this.fExternalPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fExternalPathBrowseBtn = new Button(composite2, 0);
        this.fExternalPathBrowseBtn.setText("&Browse");
        this.fExternalPathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(PathMapperEntryDialog.this.getShell());
                String string = directoryDialog.open();
                if (string != null) {
                    PathMapperEntryDialog.this.fExternalPathText.setText(string);
                }
            }
        });
        PathMapperEntryDialog.applyDialogFont((Control)composite);
        this.initializeValues();
        return composite;
    }

    protected void initializeValues() {
        this.fWorkspacePathBtn.setSelection(true);
        this.fExternalPathBtn.setSelection(false);
        if (this.fEditData != null) {
            this.fRemotePathText.setText(this.fEditData.remotePath.toString());
            if (this.fEditData.type == PathEntry.Type.EXTERNAL) {
                this.fExternalPathBtn.setSelection(true);
                this.fWorkspacePathBtn.setSelection(false);
                this.fExternalPathText.setText(this.fEditData.localPath.toString());
            } else {
                this.fWorkspacePathText.setData((Object)this.fEditData.type);
                this.fWorkspacePathText.setText(this.fEditData.localPath.toString());
            }
        }
        this.fWorkspacePathBtn.notifyListeners(13, new Event());
        this.fExternalPathBtn.notifyListeners(13, new Event());
    }

    protected void setError(String string) {
        this.updateStatus((IStatus)new StatusInfo(4, string));
    }

    protected void validate() {
        PathMapper.Mapping mapping = new PathMapper.Mapping();
        String string = this.fRemotePathText.getText().trim();
        if (string.length() == 0) {
            this.setError("Path on server must not be empty!");
            return;
        }
        try {
            mapping.remotePath = new VirtualPath(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path on server is illegal or not absolute!");
            return;
        }
        if (this.fWorkspacePathBtn.getSelection()) {
            String string2 = this.fWorkspacePathText.getText().trim();
            if (string2.length() == 0) {
                this.setError("Path in workspace must not be empty!");
                return;
            }
            boolean bl = false;
            mapping.type = (PathEntry.Type)this.fWorkspacePathText.getData();
            if (mapping.type == PathEntry.Type.INCLUDE_FOLDER || mapping.type == PathEntry.Type.INCLUDE_VAR) {
                bl = new File(string2).exists();
            } else {
                boolean bl2 = bl = ResourcesPlugin.getWorkspace().getRoot().findMember(string2) != null;
            }
            if (!bl) {
                this.setError(NLS.bind((String)"Path ''{0}'' doesn't exist in workspace!", (Object)string2));
                return;
            }
            try {
                mapping.localPath = new VirtualPath(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setError("Path in workspace is illegal or not absolute!");
                return;
            }
        }
        String string3 = this.fExternalPathText.getText().trim();
        if (string3.length() == 0) {
            this.setError("Path in file system must not be empty!");
            return;
        }
        if (!new File(string3).exists()) {
            this.setError(NLS.bind((String)"Path ''{0}'' doesn't exist in file system!", (Object)string3));
            return;
        }
        try {
            mapping.type = PathEntry.Type.EXTERNAL;
            mapping.localPath = new VirtualPath(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path in file system is illegal or not absolute!");
            return;
        }
        this.fEditData = mapping;
        this.updateStatus(Status.OK_STATUS);
    }

    class WorkspaceBrowseDialog
    extends StatusDialog {
        private TreeViewer fViewer;
        private Object selectedElement;

        public WorkspaceBrowseDialog(Shell shell) {
            super(shell);
            this.setTitle("Select Workspace Resource");
        }

        public Object getSelectedElement() {
            return this.selectedElement;
        }

        protected Control createDialogArea(Composite composite) {
            composite = (Composite)super.createDialogArea(composite);
            composite.setLayoutData((Object)new GridData(1808));
            PixelConverter pixelConverter = new PixelConverter((Control)composite);
            this.fViewer = new TreeViewer(composite, 2820);
            GridData gridData = new GridData(1808);
            gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
            gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
            this.fViewer.getControl().setLayoutData((Object)gridData);
            this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    WorkspaceBrowseDialog.this.validate();
                }
            });
            this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            return composite;
        }

        protected void validate() {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (object == null || object instanceof IncludesNode) {
                this.updateStatus((IStatus)new StatusInfo(4, ""));
                return;
            }
            this.selectedElement = object;
            this.updateStatus(Status.OK_STATUS);
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object object) {
                try {
                    if (object instanceof IContainer) {
                        PHPProjectOptions pHPProjectOptions;
                        IResource iResource;
                        IResource[] iResourceArray;
                        LinkedList<IResource> linkedList = new LinkedList<IResource>();
                        IContainer iContainer = (IContainer)object;
                        IResource[] iResourceArray2 = iResourceArray = iContainer.members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            iResource = iResourceArray2[n2];
                            if (iResource instanceof IContainer && iResource.isAccessible()) {
                                linkedList.add(iResource);
                            }
                            ++n2;
                        }
                        if (object instanceof IProject && (pHPProjectOptions = PHPProjectOptions.forProject((IProject)(iResource = (IProject)object))) != null) {
                            IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
                            linkedList.addAll((Collection)Arrays.asList(iIncludePathEntryArray));
                        }
                        return linkedList.toArray();
                    }
                    if (object instanceof IIncludePathEntry) {
                        IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                        IPath iPath = iIncludePathEntry.getPath();
                        File file = null;
                        if (iIncludePathEntry.getEntryKind() == 1) {
                            file = iPath.toFile();
                        } else if (iIncludePathEntry.getEntryKind() == 4 && (iPath = IncludePathVariableManager.instance().resolveVariablePath(iPath.toString())) != null) {
                            file = iPath.toFile();
                        }
                        if (file != null) {
                            return this.getChildren(new IPFile(iIncludePathEntry, file));
                        }
                    } else if (object instanceof IPFile) {
                        IPFile iPFile = (IPFile)object;
                        File file = iPFile.file;
                        if (file.isDirectory()) {
                            File[] fileArray = file.listFiles(new FileFilter(){

                                public boolean accept(File file) {
                                    return file.isDirectory();
                                }
                            });
                            ArrayList<IPFile> arrayList = new ArrayList<IPFile>(fileArray.length);
                            File[] fileArray2 = fileArray;
                            int n = fileArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                File file2 = fileArray2[n3];
                                arrayList.add(new IPFile(iPFile.includePathEntry, file2));
                                ++n3;
                            }
                            return arrayList.toArray();
                        }
                    }
                }
                catch (CoreException coreException) {}
                return new Object[0];
            }

            public Object getParent(Object object) {
                if (object instanceof IResource) {
                    return ((IResource)object).getParent();
                }
                if (object instanceof IPFile) {
                    IPFile iPFile = (IPFile)object;
                    return new IPFile(iPFile.includePathEntry, iPFile.file.getParentFile());
                }
                return null;
            }

            public boolean hasChildren(Object object) {
                return this.getChildren(object).length > 0;
            }

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        }

        class IPFile {
            IIncludePathEntry includePathEntry;
            File file;

            IPFile(IIncludePathEntry iIncludePathEntry, File file) {
                this.includePathEntry = iIncludePathEntry;
                this.file = file;
            }

            public int hashCode() {
                return this.file.hashCode() + 13 * this.includePathEntry.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof IPFile)) {
                    return false;
                }
                IPFile iPFile = (IPFile)object;
                return iPFile.file.equals(this.file) && iPFile.includePathEntry.equals(this.includePathEntry);
            }
        }

        class LabelProvider
        extends PHPUILabelProvider {
            LabelProvider() {
            }

            public Image getImage(Object object) {
                if (object instanceof IIncludePathEntry) {
                    IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                    if (iIncludePathEntry.getEntryKind() == 4) {
                        return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                    }
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
                }
                if (object instanceof IPFile) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return super.getImage(object);
            }

            public String getText(Object object) {
                if (object instanceof IIncludePathEntry) {
                    IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                    return iIncludePathEntry.getPath().toOSString();
                }
                if (object instanceof IPFile) {
                    return ((IPFile)object).file.getName();
                }
                return super.getText(object);
            }
        }
    }
}

