/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionDeclaration
extends Statement {
    private final boolean isReference;
    private final Identifier functionName;
    private final FormalParameter[] formalParameters;
    private final Block body;

    private FunctionDeclaration(int n, int n2, Identifier identifier, FormalParameter[] formalParameterArray, Block block, boolean bl) {
        super(n, n2);
        assert (identifier != null && formalParameterArray != null);
        this.isReference = bl;
        this.functionName = identifier;
        this.formalParameters = formalParameterArray;
        this.body = block;
        identifier.setParent(this);
        int n3 = 0;
        while (n3 < formalParameterArray.length) {
            formalParameterArray[n3].setParent(this);
            ++n3;
        }
        if (block != null) {
            block.setParent(this);
        }
    }

    public FunctionDeclaration(int n, int n2, Identifier identifier, List list, Block block, boolean bl) {
        this(n, n2, identifier, list.toArray(new FormalParameter[list.size()]), block, bl);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        int n = 0;
        while (n < this.formalParameters.length) {
            this.formalParameters[n].accept(visitor);
            ++n;
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        int n = 0;
        while (n < this.formalParameters.length) {
            this.formalParameters[n].traverseTopDown(visitor);
            ++n;
        }
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        int n = 0;
        while (n < this.formalParameters.length) {
            this.formalParameters[n].traverseBottomUp(visitor);
            ++n;
        }
        if (this.body != null) {
            this.body.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<FunctionDeclaration");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" isReference='").append(this.isReference).append("'>\n");
        stringBuffer.append("\t").append(string).append("<FunctionName>\n");
        this.functionName.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("</FunctionName>\n");
        stringBuffer.append("\t").append(string).append("<FormalParameters>\n");
        int n = 0;
        while (n < this.formalParameters.length) {
            this.formalParameters[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("\t").append(string).append("</FormalParameters>\n");
        stringBuffer.append("\t").append(string).append("<FunctionBody>\n");
        if (this.body != null) {
            this.body.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</FunctionBody>\n");
        stringBuffer.append(string).append("</FunctionDeclaration>");
    }

    public int getType() {
        return 29;
    }

    public Block getBody() {
        return this.body;
    }

    public FormalParameter[] getFormalParameters() {
        return this.formalParameters;
    }

    public Identifier getFunctionName() {
        return this.functionName;
    }

    public boolean isReference() {
        return this.isReference;
    }
}

