/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

public class DBGpLogger {
    private static boolean debugOn = false;

    public static boolean debugState() {
        return false;
    }

    public static boolean debugCmd() {
        return false;
    }

    public static boolean debugResp() {
        return false;
    }

    public static boolean debugBP() {
        return false;
    }

    public static boolean debugSession() {
        return false;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println("-->DBGp: " + string);
        }
    }

    public static void debugException(Throwable throwable) {
        DBGpLogger.debug(String.valueOf(throwable.getClass().toString()) + ":" + throwable.getMessage());
        if (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = 0;
            while (n < stackTraceElementArray.length) {
                DBGpLogger.debug(stackTraceElementArray[n].toString());
                ++n;
            }
        }
    }

    public static void logException(String string, Object object, Throwable throwable) {
        ILog iLog = PHPDebugPlugin.getDefault().getLog();
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            stringBuffer.append(object.getClass().toString());
            stringBuffer.append(" : ");
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        DBGpLogger.debug(stringBuffer.toString());
        if (throwable != null) {
            DBGpLogger.debugException(throwable);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        Status status = new Status(4, "org.eclipse.php.debug.core", 4, stringBuffer + "\n" + byteArrayOutputStream.toString(), null);
        iLog.log((IStatus)status);
    }

    public static void logError(String string, Object object, Throwable throwable) {
        DBGpLogger.doLog(string, object, throwable, 4);
    }

    public static void logWarning(String string, Object object, Throwable throwable) {
        DBGpLogger.doLog(string, object, throwable, 2);
    }

    public static void logInfo(String string, Object object) {
        DBGpLogger.doLog(string, object, null, 1);
    }

    private static void doLog(String string, Object object, Throwable throwable, int n) {
        ILog iLog = PHPDebugPlugin.getDefault().getLog();
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            stringBuffer.append(object.getClass().toString());
            stringBuffer.append(" : ");
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (throwable != null) {
            stringBuffer.append("Exception:");
            stringBuffer.append(throwable.getClass().toString());
            stringBuffer.append(" msg: ");
            stringBuffer.append(throwable.getMessage());
        }
        Status status = new Status(n, "org.eclipse.php.debug.core", n, stringBuffer.toString(), throwable);
        DBGpLogger.debug(stringBuffer.toString());
        if (throwable != null) {
            DBGpLogger.debugException(throwable);
        }
        iLog.log((IStatus)status);
    }
}

