/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;

public class RequestData {
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected ServletContext context;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String locale;
    protected WebappPreferences preferences;
    protected boolean advancedUI;

    public RequestData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.preferences = new WebappPreferences();
        this.locale = UrlUtil.getLocale(request, response);
        String agent = request.getHeader("User-Agent");
        this.advancedUI = UrlUtil.isAdvanced(agent);
    }

    public WebappPreferences getPrefs() {
        return this.preferences;
    }

    public boolean isBot() {
        return UrlUtil.isBot(this.request);
    }

    public boolean isGecko() {
        return UrlUtil.isGecko(this.request);
    }

    public boolean isIE() {
        return UrlUtil.isIE(this.request);
    }

    public String getIEVersion() {
        return UrlUtil.getIEVersion(this.request);
    }

    public boolean isKonqueror() {
        return UrlUtil.isKonqueror(this.request);
    }

    public boolean isMozilla() {
        return UrlUtil.isMozilla(this.request);
    }

    public String getMozillaVersion() {
        return UrlUtil.getMozillaVersion(this.request);
    }

    public boolean isSafari() {
        return UrlUtil.isSafari(this.request);
    }

    public String getSafariVersion() {
        return UrlUtil.getSafariVersion(this.request);
    }

    public boolean isOpera() {
        return UrlUtil.isOpera(this.request);
    }

    public String getLocale() {
        return this.locale;
    }

    public int getMode() {
        return BaseHelpSystem.getMode();
    }

    public boolean isAdvancedUI() {
        return this.advancedUI;
    }
}

