/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.Rect;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    boolean disposed;
    boolean warnings;
    int colorspace;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Callback drawPatternCallback;
    Callback axialShadingCallback;
    Callback releaseCallback;
    int drawPatternProc;
    int axialShadingProc;
    int releaseProc;
    static final Object CREATE_OBJECT;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        CREATE_OBJECT = new Object();
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Object object = CREATE_OBJECT;
        synchronized (object) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            this.create(data);
            this.init();
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
            }
        }
    }

    int axialShadingProc(int ref, int in, int out) {
        Object object = OS.JNIGetObject(ref);
        if (object instanceof Pattern) {
            return ((Pattern)object).axialShadingProc(ref, in, out);
        }
        return 0;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    void createPatternCallbacks() {
        if (this.drawPatternCallback == null) {
            this.drawPatternCallback = new Callback(this, "drawPatternProc", 2);
            this.drawPatternProc = this.drawPatternCallback.getAddress();
            if (this.drawPatternProc == 0) {
                SWT.error(3);
            }
        }
        if (this.axialShadingCallback == null) {
            this.axialShadingCallback = new Callback(this, "axialShadingProc", 3);
            this.axialShadingProc = this.axialShadingCallback.getAddress();
            if (this.axialShadingProc == 0) {
                SWT.error(3);
            }
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    int drawPatternProc(int ref, int context) {
        Object object = OS.JNIGetObject(ref);
        if (object instanceof Pattern) {
            return ((Pattern)object).drawPatternProc(ref, context);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memmove(ptr, gdevice, 4);
        GDevice device = new GDevice();
        OS.memmove(device, ptr[0], 62);
        return new Rectangle(device.left, device.top, device.right - device.left, device.bottom - device.top);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds(gdevice, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDepth() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memmove(ptr, gdevice, 4);
        GDevice device = new GDevice();
        OS.memmove(device, ptr[0], 62);
        return OS.GetPixDepth(device.gdPMap);
    }

    public Point getDPI() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memmove(ptr, gdevice, 4);
        GDevice device = new GDevice();
        OS.memmove(device, ptr[0], 62);
        OS.memmove(ptr, device.gdPMap, 4);
        PixMap pixmap = new PixMap();
        OS.memmove(pixmap, ptr[0], 50);
        return new Point(OS.Fix2Long(pixmap.hRes), OS.Fix2Long(pixmap.vRes));
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        int count = 0;
        int[] buffer = new int[1];
        CFRange range = new CFRange();
        OS.ATSUGetFontIDs(null, 0, buffer);
        FontData[] fds = new FontData[buffer[0]];
        int status = OS.ATSFontIteratorCreate(2, 0, 0, 0, buffer);
        int iter = buffer[0];
        while (status == 0) {
            int font;
            status = OS.ATSFontIteratorNext(iter, buffer);
            if (status != 0 || OS.ATSFontGetName(font = buffer[0], 0, buffer) != 0) continue;
            range.length = OS.CFStringGetLength(buffer[0]);
            char[] chars = new char[range.length];
            OS.CFStringGetCharacters(buffer[0], range, chars);
            OS.CFRelease(buffer[0]);
            String atsName = new String(chars);
            int platformCode = 0;
            int encoding = 256;
            if (OS.ATSUFindFontName(font, 1, platformCode, -1, -1, 0, null, buffer, null) != 0) {
                platformCode = -1;
                encoding = 0;
                if (OS.ATSUFindFontName(font, 1, platformCode, -1, -1, 0, null, buffer, null) != 0) continue;
            }
            byte[] bytes = new byte[buffer[0]];
            OS.ATSUFindFontName(font, 1, platformCode, -1, -1, bytes.length, bytes, buffer, null);
            int ptr = OS.CFStringCreateWithBytes(0, bytes, bytes.length, encoding, false);
            if (ptr == 0) continue;
            range.length = OS.CFStringGetLength(ptr);
            if (range.length != 0) {
                chars = new char[range.length];
                OS.CFStringGetCharacters(ptr, range, chars);
                String name = new String(chars);
                if (!name.startsWith(".") && (faceName == null || Compatibility.equalsIgnoreCase(faceName, name))) {
                    int s = 0;
                    if (atsName.indexOf("Italic") != -1) {
                        s |= 2;
                    }
                    if (atsName.indexOf("Bold") != -1) {
                        s |= 1;
                    }
                    FontData data = new FontData(name, 0, s);
                    data.atsName = atsName;
                    if (count == fds.length) {
                        FontData[] newFDs = new FontData[count + 4];
                        System.arraycopy(fds, 0, newFDs, 0, count);
                        fds = newFDs;
                    }
                    fds[count++] = data;
                }
            }
            OS.CFRelease(ptr);
        }
        if (iter != 0) {
            buffer[0] = iter;
            OS.ATSFontIteratorRelease(buffer);
        }
        if (count == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[count];
        System.arraycopy(fds, 0, result, 0, count);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (this.colorspace == 0) {
            SWT.error(2);
        }
        this.releaseCallback = new Callback(this, "releaseProc", 3);
        this.releaseProc = this.releaseCallback.getAddress();
        if (this.releaseProc == 0) {
            SWT.error(3);
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        boolean smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        byte[] family = new byte[256];
        short[] size = new short[1];
        byte[] style = new byte[1];
        boolean themeFont = smallFonts;
        OS.GetThemeFont((short)(themeFont ? 1 : 0), (short)-1, family, size, style);
        short id = OS.FMGetFontFamilyFromName(family);
        int[] font = new int[1];
        OS.FMGetFontFromFontFamilyInstance(id, style[0], font, null);
        this.systemFont = Font.carbon_new(this, OS.FMGetATSFontRefFromFont(font[0]), style[0], size[0]);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        boolean result = false;
        char[] chars = new char[path.length()];
        path.getChars(0, chars.length, chars, 0);
        int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        if (str != 0) {
            int url = OS.CFURLCreateWithFileSystemPath(0, str, 0, false);
            if (url != 0) {
                byte[] fsSpec;
                byte[] fsRef = new byte[80];
                if (OS.CFURLGetFSRef(url, fsRef) && OS.FSGetCatalogInfo(fsRef, 0, null, null, fsSpec = new byte[70], null) == 0) {
                    int[] container = new int[1];
                    result = OS.ATSFontActivateFromFileSpecification(fsSpec, 2, 0, 0, 0, container) == 0;
                }
                OS.CFRelease(url);
            }
            OS.CFRelease(str);
        }
        return result;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    protected void release() {
        if (this.releaseCallback != null) {
            this.releaseCallback.dispose();
        }
        if (this.drawPatternCallback != null) {
            this.drawPatternCallback.dispose();
        }
        if (this.axialShadingCallback != null) {
            this.axialShadingCallback.dispose();
        }
        this.drawPatternCallback = null;
        this.axialShadingCallback = null;
        this.releaseCallback = null;
        this.drawPatternProc = 0;
        this.axialShadingProc = 0;
        this.releaseProc = 0;
        OS.CGColorSpaceRelease(this.colorspace);
        this.colorspace = 0;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    int releaseProc(int info, int data, int size) {
        OS.DisposePtr(data);
        return 0;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
        this.warnings = warnings;
    }
}

