/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.ShowPHPsPreferences;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPsComboBlock
implements ISelectionProvider {
    PHPexes exes = PHPexes.getInstance();
    protected Combo fExecutablesCombo;
    protected Combo fDebuggersCombo;
    private Composite fControl;
    private PHPexeDescriptor fDefaultDescriptor = null;
    private ISelection fPrevSelection = new StructuredSelection();
    private final ListenerList fSelectionListeners = new ListenerList();
    private String fTitle = null;
    private final List<PHPexeItem> phpExecutables = new ArrayList<PHPexeItem>();
    private boolean isTitled;
    private Link link;
    private Set<String> fDebuggerIds;
    private Timer timer;

    public PHPsComboBlock(boolean bl) {
        this.isTitled = bl;
        this.fDefaultDescriptor = new PHPexeDescriptor(){

            public String getDescription() {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.exes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
                if (pHPexeItem != null) {
                    return String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getExecutable().toString() + ")";
                }
                return "No PHP exes defined";
            }
        };
    }

    public PHPsComboBlock() {
        this(true);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public void createControl(Composite composite) {
        Group group;
        Font font = composite.getFont();
        Composite composite2 = null;
        if (this.isTitled) {
            group = new Group(composite, 0);
            if (this.fTitle == null) {
                this.fTitle = PHPDebugUIMessages.PHPexesComboBlock_3;
            }
            group.setText(this.fTitle);
            composite2 = group;
        } else {
            composite2 = new Composite(composite, 0);
        }
        group = new GridLayout(2, false);
        composite2.setLayout((Layout)group);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.fControl = composite2;
        Composite composite3 = new Composite(composite2, 0);
        group = new GridLayout(2, false);
        composite3.setLayout((Layout)group);
        composite3.setFont(font);
        Label label = new Label(composite3, 64);
        label.setText(PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger);
        GridData gridData2 = new GridData(1);
        gridData2.widthHint = 100;
        label.setLayoutData((Object)gridData2);
        this.fDebuggersCombo = new Combo(composite3, 12);
        this.fDebuggersCombo.setFont(font);
        gridData2 = new GridData(768);
        gridData2.grabExcessHorizontalSpace = true;
        this.fDebuggersCombo.setLayoutData((Object)gridData2);
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = PHPsComboBlock.this.getSelectedDebuggerId();
                PHPexeItem[] pHPexeItemArray = PHPsComboBlock.this.exes.getItems(string);
                List<PHPexeItem> list = pHPexeItemArray != null ? Arrays.asList(pHPexeItemArray) : new ArrayList<PHPexeItem>(0);
                PHPsComboBlock.this.setPHPexes(list);
                PHPsComboBlock.this.fireSelectionChanged();
                PHPsComboBlock.this.signalExecutablesCombo();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData(512));
        Composite composite4 = new Composite(composite2, 0);
        group = new GridLayout(2, false);
        composite4.setLayout((Layout)group);
        composite4.setFont(font);
        gridData2 = gridData;
        composite4.setLayoutData((Object)gridData2);
        Label label3 = new Label(composite4, 64);
        label3.setText("PHP Executable:");
        gridData2 = new GridData(1);
        gridData2.widthHint = 100;
        label3.setLayoutData((Object)gridData2);
        this.fExecutablesCombo = new Combo(composite4, 12);
        this.fExecutablesCombo.setFont(font);
        gridData2 = new GridData(768);
        gridData2.grabExcessHorizontalSpace = true;
        this.fExecutablesCombo.setLayoutData((Object)gridData2);
        this.fExecutablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPsComboBlock.this.setPHPexe(PHPsComboBlock.this.getPHPexe());
            }
        });
        this.link = new Link(composite2, 0);
        gridData2 = new GridData();
        gridData2.horizontalSpan = 1;
        this.link.setLayoutData((Object)gridData2);
        this.link.setFont(font);
        this.link.setText(PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.getPHPexe();
                new ShowPHPsPreferences().run(null);
                PHPsComboBlock.this.fillWithWorkspacePHPexes();
                if (PHPsComboBlock.this.phpExecutables.contains(pHPexeItem)) {
                    String string = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getExecutable().toString() + ")";
                    PHPsComboBlock.this.fExecutablesCombo.select(PHPsComboBlock.this.fExecutablesCombo.indexOf(string));
                }
            }
        });
        this.checkDeuggers();
        this.fillDebuggers();
        this.fillWithWorkspacePHPexes();
    }

    private void checkDeuggers() {
        if (!this.exes.hasItems()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.PHPsComboBlock_NoPHPsTitle, (String)PHPDebugUIMessages.PHPsComboBlock_noPHPsMessage);
            new ShowPHPsPreferences().run(null);
        }
    }

    protected void fillDebuggers() {
        String string2;
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String string2 : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName((String)string2));
        }
        string2 = PHPDebuggersRegistry.getDebuggerName((String)PHPDebuggersRegistry.getDefaultDebuggerId());
        int n = this.fDebuggersCombo.indexOf(string2);
        if (n > -1) {
            this.fDebuggersCombo.select(n);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    protected void signalExecutablesCombo() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new BlinkTask(), 0L, 300L);
    }

    protected void fillWithWorkspacePHPexes() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        PHPexeItem[] pHPexeItemArray = this.exes.getItems(PHPDebugPlugin.getCurrentDebuggerId());
        if (pHPexeItemArray != null) {
            int n = 0;
            while (n < pHPexeItemArray.length) {
                PHPexeItem pHPexeItem = pHPexeItemArray[n];
                arrayList.add(pHPexeItem);
                ++n;
            }
        }
        this.setPHPexes(arrayList);
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setEnabled(boolean bl) {
        this.fControl.setEnabled(bl);
        this.fExecutablesCombo.setEnabled(bl);
        this.fDebuggersCombo.setEnabled(bl);
        this.link.setEnabled(bl);
    }

    public PHPexeItem getPHPexe() {
        int n = this.fExecutablesCombo.getSelectionIndex();
        if (n >= 0 && !PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(this.fExecutablesCombo.getText())) {
            return this.phpExecutables.get(n);
        }
        return null;
    }

    public PHPexeItem[] getPHPexes() {
        return this.phpExecutables.toArray(new PHPexeItem[this.phpExecutables.size()]);
    }

    public String getSelectedExecutablePath() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem != null) {
            return pHPexeItem.getExecutable().toString();
        }
        return "";
    }

    public String getSelectedIniPath() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem != null && pHPexeItem.getINILocation() != null) {
            return pHPexeItem.getINILocation().toString();
        }
        return "";
    }

    public String getSelectedDebuggerId() {
        int n = this.fDebuggersCombo.getSelectionIndex();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        if (n > -1 && this.fDebuggerIds.size() > n) {
            string = this.fDebuggerIds.toArray()[n].toString();
        }
        return string;
    }

    public ISelection getSelection() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)pHPexeItem);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    public void setPHPexe(PHPexeItem pHPexeItem) {
        if (pHPexeItem == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)pHPexeItem));
        }
    }

    public void setDebugger(String string) {
        int n = this.fDebuggersCombo.indexOf(PHPDebuggersRegistry.getDebuggerName((String)string));
        if (n > -1) {
            this.fDebuggersCombo.select(n);
            PHPexeItem[] pHPexeItemArray = this.exes.getItems(string);
            if (pHPexeItemArray != null) {
                this.setPHPexes(Arrays.asList(pHPexeItemArray));
            } else {
                this.setPHPexes(new ArrayList<PHPexeItem>(0));
            }
        }
    }

    protected void setPHPexes(List<PHPexeItem> list) {
        PHPexeItem pHPexeItem;
        this.phpExecutables.clear();
        this.phpExecutables.addAll(list);
        Collections.sort(this.phpExecutables, new Comparator<PHPexeItem>(){

            @Override
            public int compare(PHPexeItem pHPexeItem, PHPexeItem pHPexeItem2) {
                return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        String[] stringArray = new String[this.phpExecutables.size()];
        Iterator<PHPexeItem> iterator = this.phpExecutables.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pHPexeItem = iterator.next();
            stringArray[n] = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getExecutable().toString() + ")";
            ++n;
        }
        if (stringArray.length == 0) {
            stringArray = new String[]{PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined};
        }
        this.fExecutablesCombo.setItems(stringArray);
        pHPexeItem = this.exes.getDefaultItem(this.getSelectedDebuggerId());
        if (pHPexeItem != null) {
            String string = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getExecutable().toString() + ")";
            this.fExecutablesCombo.select(this.fExecutablesCombo.indexOf(string));
        } else {
            this.fExecutablesCombo.select(0);
        }
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.equals(this.fPrevSelection)) {
            this.fPrevSelection = iSelection;
            if (iSelection.isEmpty()) {
                this.fExecutablesCombo.setText("");
                this.fExecutablesCombo.select(-1);
                this.fExecutablesCombo.setItems(new String[0]);
                this.fillWithWorkspacePHPexes();
            } else {
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                int n = this.phpExecutables.indexOf(object);
                if (n >= 0) {
                    this.fExecutablesCombo.select(n);
                }
            }
            this.fireSelectionChanged();
        }
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setUseDefaultPHPexe() {
        if (this.fDefaultDescriptor != null && this.fControl != null) {
            this.fPrevSelection = null;
            this.fireSelectionChanged();
        }
    }

    private class BlinkTask
    extends TimerTask {
        int counter;

        private BlinkTask() {
        }

        public void run() {
            try {
                if (this.counter++ < 6) {
                    PHPsComboBlock.this.fExecutablesCombo.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                if (BlinkTask.this.counter % 2 != 0) {
                                    ((BlinkTask)BlinkTask.this).PHPsComboBlock.this.fExecutablesCombo.setEnabled(false);
                                } else {
                                    ((BlinkTask)BlinkTask.this).PHPsComboBlock.this.fExecutablesCombo.setEnabled(true);
                                }
                            }
                            catch (SWTException sWTException) {
                                BlinkTask.this.cancel();
                            }
                        }
                    });
                } else {
                    this.cancel();
                }
            }
            catch (SWTException sWTException) {
                this.cancel();
            }
        }
    }
}

