/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl.ModelQueryExtensionManagerImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.CMDataTypeValueHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.DOMValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.extension.ModelQueryExtensionManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryActionHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.XMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ModelQueryImpl
implements ModelQuery {
    protected ModelQueryAssociationProvider modelQueryAssociationProvider;
    protected ModelQueryActionHelper modelQueryActionHelper;
    protected DOMValidator validator;
    protected ModelQueryExtensionManagerImpl extensionManager;
    protected CMDataTypeValueHelper valueHelper;
    protected int editMode = 2;

    public ModelQueryImpl(ModelQueryAssociationProvider modelQueryAssociationProvider) {
        this.modelQueryAssociationProvider = modelQueryAssociationProvider;
        this.modelQueryActionHelper = this.createModelQueryActionHelper();
        this.validator = new DOMValidator();
        this.extensionManager = new ModelQueryExtensionManagerImpl();
        this.valueHelper = new CMDataTypeValueHelper();
    }

    public int getEditMode() {
        return this.editMode;
    }

    public void setEditMode(int editMode) {
        this.editMode = editMode;
    }

    public ModelQueryActionHelper createModelQueryActionHelper() {
        return new ModelQueryActionHelper(this);
    }

    public DOMValidator getValidator() {
        return this.validator;
    }

    public CMDocument getCorrespondingCMDocument(Node node) {
        return this.modelQueryAssociationProvider.getCorrespondingCMDocument(node);
    }

    public CMNode getCMNode(Node node) {
        return this.modelQueryAssociationProvider.getCMNode(node);
    }

    public CMDataType getCMDataType(Text text) {
        return this.modelQueryAssociationProvider.getCMDataType(text);
    }

    public CMAttributeDeclaration getCMAttributeDeclaration(Attr attr) {
        return this.modelQueryAssociationProvider.getCMAttributeDeclaration(attr);
    }

    public CMElementDeclaration getCMElementDeclaration(Element element) {
        return this.modelQueryAssociationProvider.getCMElementDeclaration(element);
    }

    public CMDocumentManager getCMDocumentManager() {
        CMDocumentManager result = null;
        if (this.modelQueryAssociationProvider instanceof XMLAssociationProvider) {
            XMLAssociationProvider xmlAssociationProvider = (XMLAssociationProvider)this.modelQueryAssociationProvider;
            result = xmlAssociationProvider.getCMDocumentManager();
        }
        return result;
    }

    public List getCMDocumentList(Element element, String uri) {
        return Collections.EMPTY_LIST;
    }

    public List getCMDocumentList(Element element, CMElementDeclaration ed, String uri) {
        Vector<CMDocument> result = new Vector<CMDocument>();
        if (this.modelQueryAssociationProvider instanceof XMLAssociationProvider) {
            XMLAssociationProvider xmlAssociationProvider = (XMLAssociationProvider)this.modelQueryAssociationProvider;
            if (uri == null) {
                uri = "##any";
            }
            if (uri.equals("##targetNamespace")) {
                CMDocument cmDocument = (CMDocument)ed.getProperty("CMDocument");
                if (cmDocument != null) {
                    result.add(cmDocument);
                }
            } else if (uri.equals("##any") || uri.equals("##other")) {
                CMDocument cmDocument;
                String excludedURI = null;
                if (uri.equals("##other") && (cmDocument = (CMDocument)ed.getProperty("CMDocument")) != null) {
                    excludedURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
                }
                NamespaceTable namespaceTable = new NamespaceTable(element.getOwnerDocument());
                namespaceTable.addElementLineage(element);
                List list = namespaceTable.getNamespaceInfoList();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    CMDocument document;
                    NamespaceInfo info = (NamespaceInfo)i.next();
                    if (info.uri == null || info.uri.equals(excludedURI) || (document = xmlAssociationProvider.getCMDocument(info.uri, info.locationHint, "XSD")) == null) continue;
                    result.add(document);
                }
            } else {
                CMDocument document = xmlAssociationProvider.getCMDocument(element, uri);
                if (document != null) {
                    result.add(document);
                }
            }
        }
        return result;
    }

    public CMDocument getCMDocument(Element element, String uri) {
        CMDocument result = null;
        if (this.modelQueryAssociationProvider instanceof XMLAssociationProvider) {
            XMLAssociationProvider xmlAssociationProvider = (XMLAssociationProvider)this.modelQueryAssociationProvider;
            result = xmlAssociationProvider.getCMDocument(element, uri);
        }
        return result;
    }

    public boolean isContentValid(Element element) {
        CMElementDeclaration ed = this.getCMElementDeclaration(element);
        return this.isContentValid(ed, element);
    }

    public boolean isContentValid(CMElementDeclaration ed, Element element) {
        boolean result = true;
        if (ed != null) {
            CMNamedNodeMap map = ed.getAttributes();
            int mapLength = map.getLength();
            int i = 0;
            while (i < mapLength) {
                Attr attr;
                CMAttributeDeclaration ad = (CMAttributeDeclaration)map.item(i);
                String attributeName = DOMNamespaceHelper.computeName(ad, element, null);
                if (ad.getUsage() == 2 && (attr = element.getAttributeNode(attributeName)) == null) {
                    result = false;
                    break;
                }
                ++i;
            }
            if (result) {
                CMNode[] originArray = this.getOriginArray(element);
                result = originArray != null && originArray.length == element.getChildNodes().getLength();
            }
        }
        return result;
    }

    public CMNode getOrigin(Node node) {
        int index;
        Element parentElement;
        CMNode[] array;
        CMNode result = null;
        Node parentNode = this.getParentOrOwnerNode(node);
        if (parentNode != null && parentNode.getNodeType() == 1 && (array = this.getOriginArray(parentElement = (Element)parentNode)) != null && (index = this.getIndexOfNode(parentElement.getChildNodes(), node)) < array.length) {
            result = array[index];
        }
        return result;
    }

    public CMNode[] getOriginArray(Element element) {
        CMElementDeclaration ed = this.getCMElementDeclaration(element);
        return ed != null ? this.getValidator().getOriginArray(ed, element) : null;
    }

    public int getIndexOfNode(NodeList nodeList, Node node) {
        int result = -1;
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            if (nodeList.item(i) == node) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public List getAvailableContent(Element element, CMElementDeclaration ed, int includeOptions) {
        AvailableContentCMVisitor visitor = new AvailableContentCMVisitor(element, ed);
        List list = visitor.computeAvailableContent(includeOptions);
        if (this.extensionManager != null) {
            this.extensionManager.filterAvailableElementContent(list, element, ed);
        }
        return list;
    }

    public boolean canInsert(Element parent, CMNode cmNode, int index, int validityChecking) {
        boolean result = true;
        CMElementDeclaration ed = this.getCMElementDeclaration(parent);
        if (ed != null) {
            result = this.canInsert(parent, ed, cmNode, index, validityChecking);
        }
        return result;
    }

    public boolean canInsert(Element parent, CMElementDeclaration ed, CMNode cmNode, int index, int validityChecking) {
        return this.canInsert(parent, ed, cmNode, index, validityChecking, null);
    }

    protected boolean canInsert(Element parent, CMElementDeclaration ed, CMNode cmNode, int index, int validityChecking, Object reuseableData) {
        boolean result = true;
        switch (cmNode.getNodeType()) {
            case 2: {
                String attributeName = DOMNamespaceHelper.computeName(cmNode, parent, null);
                result = parent.getAttributeNode(attributeName) == null;
                break;
            }
            case 5: 
            case 7: {
                if (validityChecking != 2) break;
                List contentSpecificationList = null;
                contentSpecificationList = reuseableData != null ? (List)reuseableData : this.getValidator().createContentSpecificationList(parent, ed);
                result = this.getValidator().canInsert(ed, contentSpecificationList, index, cmNode);
                break;
            }
            case 3: {
                int contentType = ed.getContentType();
                result = contentType == 3 || contentType == 4 || contentType == 0;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean canInsert(Element parent, List cmNodeList, int index, int validityChecking) {
        return true;
    }

    public boolean canRemove(Node node, int validityChecking) {
        boolean result = true;
        if (validityChecking == 2) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 2: {
                    CMAttributeDeclaration ad = this.getCMAttributeDeclaration((Attr)node);
                    if (ad == null) break;
                    result = ad.getUsage() == 1;
                    break;
                }
                case 1: {
                    Element parentElement;
                    CMElementDeclaration ed;
                    Node parentNode = node.getParentNode();
                    if (parentNode.getNodeType() != 1 || (ed = this.getCMElementDeclaration(parentElement = (Element)parentNode)) == null) break;
                    List contentSpecificationList = this.getValidator().createContentSpecificationList(parentElement, ed);
                    int index = this.getIndexOfNode(parentElement.getChildNodes(), node);
                    result = this.getValidator().canRemove(ed, contentSpecificationList, index);
                }
            }
        }
        return result;
    }

    public boolean canRemove(List nodeList, int validityChecking) {
        boolean result = true;
        if (validityChecking == 2) {
            CMElementDeclaration ed;
            Element parentElement = null;
            List childList = null;
            Iterator i = nodeList.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                if (parentElement == null) {
                    parentElement = this.getParentOrOwnerElement(node);
                } else if (parentElement != this.getParentOrOwnerElement(node)) {
                    result = false;
                    break;
                }
                if (parentElement == null) {
                    result = true;
                    break;
                }
                short nodeType = node.getNodeType();
                if (nodeType == 2) {
                    if (this.canRemove(node, validityChecking)) continue;
                    result = false;
                    break;
                }
                if (childList == null) {
                    childList = this.nodeListToList(parentElement.getChildNodes());
                }
                childList.remove(node);
            }
            if (result && childList != null && (ed = this.getCMElementDeclaration(parentElement)) != null) {
                List contentSpecificationList = this.getValidator().createContentSpecificationList(childList, ed);
                result = this.getValidator().isValid(ed, contentSpecificationList);
            }
        }
        return result;
    }

    public boolean canReplace(Element parent, int startIndex, int endIndex, CMNode cmNode, int validityChecking) {
        return true;
    }

    public boolean canReplace(Element parent, int startIndex, int endIndex, List cmNodeList, int validityChecking) {
        return true;
    }

    public boolean canWrap(Element childElement, CMElementDeclaration wrapElement, int validityChecking) {
        boolean result = true;
        Node parentNode = childElement.getParentNode();
        if (parentNode.getNodeType() == 1) {
            Element parentElement = (Element)parentNode;
            CMElementDeclaration parentEd = this.getCMElementDeclaration(parentElement);
            if (parentEd != null && validityChecking == 2) {
                int index = this.getIndexOfNode(parentElement.getChildNodes(), childElement);
                List contentSpecificationList = this.getValidator().createContentSpecificationList(parentElement, parentEd);
                List subList = contentSpecificationList.subList(index, index + 1);
                result = this.getValidator().canReplace(parentEd, contentSpecificationList, index, index, wrapElement);
                if (result) {
                    result = this.getValidator().isValid(wrapElement, subList);
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public void getInsertActions(Element parent, CMElementDeclaration ed, int index, int includeOptions, int validityChecking, List actionList) {
        this.modelQueryActionHelper.getInsertActions(parent, ed, index, includeOptions, validityChecking, actionList);
    }

    public void getInsertActions(Document parent, CMDocument cmDocument, int index, int includeOptions, int validityChecking, List actionList) {
        this.modelQueryActionHelper.getInsertActions(parent, cmDocument, index, includeOptions, validityChecking, actionList);
    }

    public void getReplaceActions(Element parent, CMElementDeclaration ed, int includeOptions, int validityChecking, List actionList) {
        this.modelQueryActionHelper.getReplaceActions(parent, ed, includeOptions, validityChecking, actionList);
    }

    public void getReplaceActions(Element parent, CMElementDeclaration ed, List selectedChildren, int includeOptions, int validityChecking, List actionList) {
        this.modelQueryActionHelper.getReplaceActions(parent, ed, selectedChildren, includeOptions, validityChecking, actionList);
    }

    public void getInsertChildNodeActionTable(Element parent, CMElementDeclaration ed, int validityChecking, Hashtable actionTable) {
        this.modelQueryActionHelper.getInsertChildNodeActionTable(parent, ed, validityChecking, actionTable);
    }

    public void getActionTable(Element parent, CMElementDeclaration ed, int index, int validityChecking, Hashtable actionTable) {
    }

    protected Node getParentOrOwnerNode(Node node) {
        return node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
    }

    protected Element getParentOrOwnerElement(Node node) {
        Node parent = this.getParentOrOwnerNode(node);
        return parent.getNodeType() == 1 ? (Element)parent : null;
    }

    protected List nodeListToList(NodeList nodeList) {
        int size = nodeList.getLength();
        Vector<Node> v = new Vector<Node>(size);
        int i = 0;
        while (i < size) {
            v.add(nodeList.item(i));
            ++i;
        }
        return v;
    }

    public List getDataTypeValues(Element element, CMNode cmNode) {
        return Arrays.asList(this.getPossibleDataTypeValues(element, cmNode));
    }

    public String[] getPossibleDataTypeValues(Element element, CMNode cmNode) {
        int i;
        Vector<String> list = new Vector<String>();
        if (cmNode != null) {
            String[] enumeratedValues;
            CMDataType dataType = null;
            if (cmNode.getNodeType() == 2) {
                dataType = ((CMAttributeDeclaration)cmNode).getAttrType();
            } else if (cmNode.getNodeType() == 5) {
                dataType = ((CMElementDeclaration)cmNode).getDataType();
            }
            String[] stringArray = enumeratedValues = dataType != null ? dataType.getEnumeratedValues() : null;
            if (enumeratedValues != null) {
                i = 0;
                while (i < enumeratedValues.length) {
                    list.add(enumeratedValues[i]);
                    ++i;
                }
            }
        }
        this.addValuesForXSIType(element, cmNode, list);
        if (this.extensionManager != null) {
            list.addAll(this.extensionManager.getDataTypeValues(element, cmNode));
        }
        int listSize = list.size();
        String[] result = new String[listSize];
        i = 0;
        while (i < listSize) {
            result[i] = (String)list.get(i);
            ++i;
        }
        return result;
    }

    protected void addValuesForXSIType(Element element, CMNode cmNode, List list) {
        CMAttributeDeclaration ad;
        if (cmNode != null && cmNode.getNodeType() == 2 && this.valueHelper.isXSIType(ad = (CMAttributeDeclaration)cmNode)) {
            NamespaceTable table = new NamespaceTable(element.getOwnerDocument());
            table.addElementLineage(element);
            list.addAll(this.valueHelper.getQualifiedXSITypes(ad, table));
        }
    }

    public ModelQueryExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public class AvailableContentCMVisitor
    extends CMVisitor {
        public Hashtable childNodeTable = new Hashtable();
        public Hashtable attributeTable = new Hashtable();
        public Element rootElement;
        public CMElementDeclaration rootElementDeclaration;
        public boolean isRootVisited;
        protected boolean includeSequenceGroups;

        public AvailableContentCMVisitor(Element rootElement, CMElementDeclaration rootElementDeclaration) {
            this.rootElement = rootElement;
            this.rootElementDeclaration = rootElementDeclaration;
        }

        protected String getKey(CMNode cmNode) {
            String namespaceURI;
            String key = cmNode.getNodeName();
            CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
            if (cmDocument != null && (namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null) {
                key = "[" + namespaceURI + "]" + key;
            }
            return key;
        }

        protected void addToTable(Hashtable table, CMNode cmNode) {
            String nodeName = cmNode.getNodeName();
            if (nodeName != null && nodeName.length() > 0) {
                table.put(this.getKey(cmNode), cmNode);
            }
        }

        public List computeAvailableContent(int includeOptions) {
            Vector<Object> v = new Vector<Object>();
            int contentType = this.rootElementDeclaration.getContentType();
            this.includeSequenceGroups = (includeOptions & 4) != 0;
            this.visitCMNode(this.rootElementDeclaration);
            if ((includeOptions & 1) != 0) {
                v.addAll(this.attributeTable.values());
                CMAttributeDeclaration nillableAttribute = (CMAttributeDeclaration)this.rootElementDeclaration.getProperty("http://org.eclipse.wst/cm/properties/nillable");
                if (nillableAttribute != null) {
                    v.add(nillableAttribute);
                }
            }
            if ((includeOptions & 2) != 0) {
                CMDataType dataType;
                CMDocument cmDocument;
                if (contentType == 3 || contentType == 2) {
                    v.addAll(this.childNodeTable.values());
                } else if (contentType == 0 && (cmDocument = (CMDocument)this.rootElementDeclaration.getProperty("CMDocument")) != null) {
                    CMNamedNodeMap elements = cmDocument.getElements();
                    Iterator i = elements.iterator();
                    while (i.hasNext()) {
                        v.add(i.next());
                    }
                }
                if ((contentType == 3 || contentType == 4 || contentType == 0) && (dataType = this.rootElementDeclaration.getDataType()) != null) {
                    v.add(dataType);
                }
            }
            return v;
        }

        public void visitCMAnyElement(CMAnyElement anyElement) {
            String uri = anyElement.getNamespaceURI();
            List list = ModelQueryImpl.this.getCMDocumentList(this.rootElement, this.rootElementDeclaration, uri);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CMDocument cmdocument = (CMDocument)iterator.next();
                if (cmdocument == null) continue;
                CMNamedNodeMap map = cmdocument.getElements();
                int size = map.getLength();
                int i = 0;
                while (i < size) {
                    CMNode ed = map.item(i);
                    this.addToTable(this.childNodeTable, ed);
                    ++i;
                }
            }
        }

        public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
            super.visitCMAttributeDeclaration(ad);
            this.attributeTable.put(ad.getNodeName(), ad);
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            if (ed == this.rootElementDeclaration && !this.isRootVisited) {
                this.isRootVisited = true;
                super.visitCMElementDeclaration(ed);
            } else {
                CMNodeList substitutionGroup;
                if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                    this.addToTable(this.childNodeTable, ed);
                }
                if ((substitutionGroup = (CMNodeList)ed.getProperty("SubstitutionGroup")) != null) {
                    this.handleSubstitutionGroup(substitutionGroup);
                }
            }
        }

        protected void handleSubstitutionGroup(CMNodeList substitutionGroup) {
            int substitutionGroupLength = substitutionGroup.getLength();
            if (substitutionGroupLength > 1) {
                int i = 0;
                while (i < substitutionGroupLength) {
                    CMNode ed = substitutionGroup.item(i);
                    if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                        this.addToTable(this.childNodeTable, ed);
                    }
                    ++i;
                }
            }
        }

        public void visitCMGroup(CMGroup group) {
            if (this.includeSequenceGroups && group.getOperator() == 1 && group.getChildNodes().getLength() > 1 && this.includesRequiredContent(group)) {
                this.childNodeTable.put(group, group);
            }
            super.visitCMGroup(group);
        }

        public boolean includesRequiredContent(CMGroup group) {
            List list = ModelQueryImpl.this.getValidator().createContentSpecificationList(group);
            return list.size() > 1;
        }
    }
}

