/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.connector.ResponseStream;
import org.apache.catalina.connector.ResponseWriter;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public abstract class ResponseBase
implements Response,
ServletResponse {
    protected boolean appCommitted = false;
    protected byte[] buffer = new byte[1024];
    protected int bufferCount = 0;
    protected boolean committed = false;
    protected Connector connector = null;
    protected int contentCount = 0;
    protected int contentLength = -1;
    protected String contentType = null;
    protected Context context = null;
    protected String encoding = null;
    protected ResponseFacade facade = new ResponseFacade(this);
    protected boolean included = false;
    protected static final String info = "org.apache.catalina.connector.ResponseBase/1.0";
    protected Locale locale = Locale.getDefault();
    protected OutputStream output = null;
    protected Request request = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected ServletOutputStream stream = null;
    protected boolean suspended = false;
    protected PrintWriter writer = null;
    protected boolean error = false;

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.committed;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getInfo() {
        return info;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public ServletResponse getResponse() {
        return this.facade;
    }

    public OutputStream getStream() {
        return this.output;
    }

    public void setStream(OutputStream stream) {
        this.output = stream;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
        if (this.stream != null) {
            ((ResponseStream)this.stream).setSuspended(suspended);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new ResponseStream(this);
    }

    public void finishResponse() throws IOException {
        if (this.stream == null) {
            ServletOutputStream sos = this.getOutputStream();
            sos.flush();
            sos.close();
            return;
        }
        if (((ResponseStream)this.stream).closed()) {
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.stream.flush();
            this.stream.close();
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getReporter() {
        if (this.isError()) {
            try {
                if (this.stream == null) {
                    this.stream = this.createOutputStream();
                }
            }
            catch (IOException e) {
                return null;
            }
            return new PrintWriter((OutputStream)this.stream);
        }
        if (this.stream != null) {
            return null;
        }
        try {
            return new PrintWriter((OutputStream)this.getOutputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public void recycle() {
        this.bufferCount = 0;
        this.committed = false;
        this.appCommitted = false;
        this.suspended = false;
        this.contentCount = 0;
        this.contentLength = -1;
        this.contentType = null;
        this.context = null;
        this.encoding = null;
        this.included = false;
        this.locale = Locale.getDefault();
        this.output = null;
        this.request = null;
        this.stream = null;
        this.writer = null;
        this.error = false;
    }

    public void write(int b) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferCount++] = (byte)b;
        ++this.contentCount;
    }

    public void write(byte[] b) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseBase.write.suspended"));
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            this.contentCount += len;
            return;
        }
        this.flushBuffer();
        int iterations = len / this.buffer.length;
        int leftoverStart = iterations * this.buffer.length;
        int leftoverLen = len - leftoverStart;
        for (int i = 0; i < iterations; ++i) {
            this.write(b, off + i * this.buffer.length, this.buffer.length);
        }
        if (leftoverLen > 0) {
            this.write(b, off + leftoverStart, leftoverLen);
        }
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
        if (this.bufferCount > 0) {
            try {
                this.output.write(this.buffer, 0, this.bufferCount);
            }
            catch (IOException ioe) {
                throw new ClientAbortException(ioe);
            }
            finally {
                this.bufferCount = 0;
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            return "ISO-8859-1";
        }
        return this.encoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException(sm.getString("responseBase.getOutputStream.ise"));
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        ((ResponseStream)this.stream).setCommit(true);
        return this.stream;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException(sm.getString("responseBase.getWriter.ise"));
        }
        ResponseStream newStream = (ResponseStream)this.createOutputStream();
        newStream.setCommit(false);
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)((Object)newStream), this.getCharacterEncoding());
        this.writer = new ResponseWriter(osr, newStream);
        this.stream = newStream;
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(sm.getString("responseBase.reset.ise"));
        }
        if (this.included) {
            return;
        }
        if (this.stream != null) {
            ((ResponseStream)this.stream).reset();
        }
        this.bufferCount = 0;
        this.contentLength = -1;
        this.contentType = null;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException(sm.getString("responseBase.resetBuffer.ise"));
        }
        this.bufferCount = 0;
    }

    public void setBufferSize(int size) {
        if (this.committed || this.bufferCount > 0) {
            throw new IllegalStateException(sm.getString("responseBase.setBufferSize.ise"));
        }
        if (this.buffer.length >= size) {
            return;
        }
        this.buffer = new byte[size];
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentLength = length;
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentType = type;
        if (type.indexOf(59) >= 0) {
            this.encoding = RequestUtil.parseCharacterEncoding(type);
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        } else if (this.encoding != null) {
            this.contentType = type + ";charset=" + this.encoding;
        }
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.locale = locale;
        if (this.context != null) {
            CharsetMapper mapper = this.context.getCharsetMapper();
            this.encoding = mapper.getCharset(locale);
            if (this.contentType != null) {
                if (this.contentType.indexOf(59) < 0) {
                    this.contentType = this.contentType + ";charset=" + this.encoding;
                } else {
                    int i = this.contentType.indexOf(59);
                    this.contentType = this.contentType.substring(0, i) + ";charset=" + this.encoding;
                }
            }
        }
    }
}

