/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.core.util.collections.IntMap;
import org.eclipse.swt.browser.Browser;

public class PHPSessionLaunchMapper
implements ILaunchesListener {
    private static final String SYSTEM_DEBUG_PROPERTY = "org.eclipse.php.debug.ui.activeDebugging";
    private static PHPSessionLaunchMapper instance;
    private IntHashtable map = new IntHashtable(10);

    private PHPSessionLaunchMapper() {
    }

    private static PHPSessionLaunchMapper getInstance() {
        if (instance == null) {
            instance = new PHPSessionLaunchMapper();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)instance);
        }
        return instance;
    }

    public static void put(int n, ILaunch iLaunch) {
        PHPSessionLaunchMapper.getInstance().map.put(n, (Object)iLaunch);
    }

    public static ILaunch get(int n) {
        return (ILaunch)PHPSessionLaunchMapper.getInstance().map.get(n);
    }

    public static ILaunch remove(int n) {
        return (ILaunch)PHPSessionLaunchMapper.getInstance().map.remove(n);
    }

    public void launchesAdded(ILaunch[] iLaunchArray) {
        PHPSessionLaunchMapper.updateSystemProperty(iLaunchArray);
    }

    public void launchesChanged(ILaunch[] iLaunchArray) {
        PHPSessionLaunchMapper.updateSystemProperty(iLaunchArray);
    }

    public void launchesRemoved(ILaunch[] iLaunchArray) {
        IntMap.Entry[] entryArray = new IntMap.Entry[this.map.size()];
        this.map.entrySet().toArray(entryArray);
        IntMap.Entry[] entryArray2 = entryArray;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IntMap.Entry entry = entryArray2[n2];
            ILaunch[] iLaunchArray2 = iLaunchArray;
            int n3 = iLaunchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ILaunch iLaunch = iLaunchArray2[n4];
                if (entry.getValue() == iLaunch) {
                    this.map.remove(entry.getKey());
                }
                ++n4;
            }
            ++n2;
        }
        PHPSessionLaunchMapper.updateSystemProperty(iLaunchArray);
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 0) {
            Browser.clearSessions();
        }
    }

    public static void updateSystemProperty(ILaunch[] iLaunchArray) {
        boolean bl = false;
        ILaunch[] iLaunchArray2 = iLaunchArray;
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch iLaunch = iLaunchArray2[n2];
            bl |= !iLaunch.isTerminated();
            ++n2;
        }
        System.setProperty(SYSTEM_DEBUG_PROPERTY, bl ? "true" : "false");
    }
}

