/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.internal.debug.core.zend.debugger.StackVariable;

public class StackLayer {
    private int depth;
    private String callerFileName;
    private int callerLineNumber;
    private String callerFunctionName;
    private String resolvedCalledFileName;
    private String calledFileName;
    private int calledLineNumber;
    private String calledFunctionName;
    private Expression[] variables;
    private Map<String, byte[]> unresolvedVariables = new HashMap<String, byte[]>();
    private ExpressionsValueDeserializer expressionValueDeserializer;

    public StackLayer(String string) {
        this.expressionValueDeserializer = new ExpressionsValueDeserializer(string);
    }

    public StackLayer(int n, String string, int n2, String string2, String string3, int n3, String string4, String string5) {
        this(string5);
        this.depth = n;
        this.setCallerFileName(string);
        this.setCallerLineNumber(n2);
        this.setCallerFunctionName(string2);
        this.setCalledFileName(string3);
        this.setCalledLineNumber(n3);
        this.setCalledFunctionName(string4);
    }

    public final int getDepth() {
        return this.depth;
    }

    public final String getCallerFileName() {
        return this.callerFileName;
    }

    public final void setCallerFileName(String string) {
        this.callerFileName = string;
    }

    public final int getCallerLineNumber() {
        return this.callerLineNumber;
    }

    public final void setCallerLineNumber(int n) {
        this.callerLineNumber = n;
    }

    public final String getCallerFunctionName() {
        return this.callerFunctionName;
    }

    public final void setCallerFunctionName(String string) {
        this.callerFunctionName = string;
    }

    public final String getCalledFileName() {
        return this.calledFileName;
    }

    public final void setCalledFileName(String string) {
        this.calledFileName = string;
    }

    public final String getResolvedCalledFileName() {
        return this.resolvedCalledFileName;
    }

    public final void setResolvedCalledFileName(String string) {
        this.resolvedCalledFileName = string;
    }

    public final int getCalledLineNumber() {
        return this.calledLineNumber;
    }

    public final void setCalledLineNumber(int n) {
        this.calledLineNumber = n;
    }

    public final String getCalledFunctionName() {
        return this.calledFunctionName;
    }

    public final void setCalledFunctionName(String string) {
        this.calledFunctionName = string;
    }

    public void addVariable(String string, byte[] byArray) {
        this.unresolvedVariables.put(string, byArray);
    }

    public Expression[] getVariables() {
        if (this.variables == null) {
            this.variables = new Expression[this.unresolvedVariables.size()];
            int n = 0;
            for (String string : this.unresolvedVariables.keySet()) {
                DefaultStackVariable defaultStackVariable = new DefaultStackVariable(string, this.depth);
                defaultStackVariable.setValue(this.expressionValueDeserializer.deserializer(defaultStackVariable, this.unresolvedVariables.get(string)));
                this.variables[n++] = defaultStackVariable;
            }
        }
        return this.variables;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.toStringCalledFunctionLine());
        stringBuffer.append("  " + this.callerFileName + " line " + (this.callerLineNumber + 1));
        return stringBuffer.toString();
    }

    public String toStringCalledFunctionLine() {
        if (this.getCallerFunctionName() == null || this.getCallerFunctionName().equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getCallerFunctionName()) + '(');
        Expression[] expressionArray = this.getVariables();
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression = expressionArray[n];
            stringBuffer.append(" $");
            stringBuffer.append(expression.getLastName());
            if (n != expressionArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private static class DefaultStackVariable
    extends DefaultExpression
    implements StackVariable {
        private int stackDepth;

        DefaultStackVariable(String string, int n) {
            super(string);
            this.stackDepth = n;
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public Expression createChildExpression(String string, String string2) {
            return new DefaultStackVariable(this, string, this.stackDepth, string2);
        }

        private DefaultStackVariable(StackVariable stackVariable, String string, int n, String string2) {
            super(stackVariable, string, string2);
            this.stackDepth = n;
        }
    }
}

