/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class LaunchConfigChange
extends Change {
    protected LaunchConfigurationContainer fConfig;
    private final boolean fShouldFlagWarning;

    public LaunchConfigChange(LaunchConfigurationContainer config, boolean shouldFlagWarning) {
        this.fConfig = config;
        this.fShouldFlagWarning = shouldFlagWarning;
    }

    public Object getModifiedElement() {
        return this.fConfig;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!this.fConfig.getConfiguration().exists() && this.fShouldFlagWarning) {
            refactoringStatus.addError(Messages.format(JUnitMessages.LaunchConfigChange_configDeleted, this.fConfig.getName()));
        }
        return refactoringStatus;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.fConfig.getConfiguration().exists()) {
            return new NullChange();
        }
        pm.beginTask("", 1);
        String oldValue = this.getOldValue(this.fConfig.getConfiguration());
        ILaunchConfigurationWorkingCopy copy = this.fConfig.getConfiguration().getWorkingCopy();
        this.alterLaunchConfiguration(copy);
        this.fConfig.setConfiguration(copy.doSave());
        Change undo = this.getUndo(oldValue);
        pm.worked(1);
        return undo;
    }

    public boolean shouldFlagWarning() {
        return this.fShouldFlagWarning;
    }

    protected abstract void alterLaunchConfiguration(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    protected abstract String getOldValue(ILaunchConfiguration var1) throws CoreException;

    protected abstract Change getUndo(String var1) throws CoreException;
}

