/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStreamCreator;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;

final class XMLFileSchemaTreePopulator
implements ISaxParserConsumer {
    private int rowCount = 0;
    private ATreeNode root = new ATreeNode();
    private SaxParser sp;
    private int numberOfElementsAccessiable;
    Thread spThread;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    XMLFileSchemaTreePopulator(int numberOfElementsAccessiable) {
        this.root.setValue("ROOT");
        this.numberOfElementsAccessiable = numberOfElementsAccessiable == 0 ? Integer.MAX_VALUE : numberOfElementsAccessiable;
    }

    public void manipulateData(String path, String value) {
    }

    public void detectNewRow(String path, boolean start) {
        String treamedPath = path.replaceAll("\\Q[\\E\\d+\\Q]\\E", "").trim();
        try {
            this.insertNode(treamedPath);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        if (!this.isAttribute(path) && start) {
            ++this.rowCount;
        }
        if (this.rowCount >= this.numberOfElementsAccessiable) {
            if (!$assertionsDisabled && this.sp == null) {
                throw new AssertionError();
            }
            this.sp.setStart(false);
            this.sp.stopParsing();
        }
    }

    private boolean isAttribute(String path) {
        return path.matches(".*\\Q[@\\E.+\\Q]\\E.*");
    }

    public synchronized void wakeup() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ATreeNode getSchemaTree(String xmlFileName, String xmlEncoding) {
        try {
            XMLDataInputStreamCreator is = XMLDataInputStreamCreator.getCreator(xmlFileName, xmlEncoding);
            this.sp = new SaxParser(is.createXMLDataInputStream(), this);
            this.spThread = new Thread(this.sp);
            this.spThread.start();
            while (this.sp.isAlive() && !this.sp.isSuspended()) {
                try {
                    XMLFileSchemaTreePopulator xMLFileSchemaTreePopulator = this;
                    synchronized (xMLFileSchemaTreePopulator) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (OdaException e1) {
            e1.printStackTrace();
        }
        if (this.sp == null || this.sp.exceptionOccurred()) {
            return null;
        }
        return this.root;
    }

    public ATreeNode getSchemaTree(String xmlFileName) {
        return this.getSchemaTree(xmlFileName, null);
    }

    private void insertNode(String treatedPath) throws OdaException {
        boolean isAttribute = this.isAttribute(treatedPath);
        String[] path = treatedPath.replaceFirst("/", "").split("/");
        if (isAttribute) {
            String[] temp = path[path.length - 1].split("\\Q[@\\E");
            if (!$assertionsDisabled && temp.length != 2) {
                throw new AssertionError();
            }
            String[] temp1 = new String[path.length + 1];
            int i = 0;
            while (i < path.length - 1) {
                temp1[i] = path[i];
                ++i;
            }
            temp1[temp1.length - 2] = temp[0];
            temp1[temp1.length - 1] = temp[1].replaceAll("\\Q]\\E", "");
            path = temp1;
        }
        ATreeNode parentNode = this.root;
        int i = 0;
        while (i < path.length) {
            ATreeNode matchedNode = null;
            int j = 0;
            while (j < parentNode.getChildren().length) {
                if (((ATreeNode)parentNode.getChildren()[j]).getValue().equals(path[i])) {
                    matchedNode = (ATreeNode)parentNode.getChildren()[j];
                    break;
                }
                ++j;
            }
            if (matchedNode != null) {
                parentNode = matchedNode;
            } else {
                matchedNode = new ATreeNode();
                if (i == path.length - 1 && isAttribute) {
                    matchedNode.setType(2);
                } else {
                    matchedNode.setType(1);
                }
                matchedNode.setValue(path[i]);
                matchedNode.setParent(parentNode);
                parentNode = matchedNode;
            }
            ++i;
        }
    }
}

