/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.actions.IPHPMoveActionDelegator;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;

public class PHPNavigatorDropAdapter
extends NavigatorDropAdapter {
    private boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    private IPHPMoveActionDelegator fReorgMoveAction = (IPHPMoveActionDelegator)PHPActionDelegatorRegistry.getActionDelegator("org.eclipse.php.ui.actions.Move");
    private static final String MOVE_ACTION_ID = "org.eclipse.php.ui.actions.Move";

    public PHPNavigatorDropAdapter(StructuredViewer structuredViewer) {
        super(structuredViewer);
    }

    private IStatus error(String string) {
        return this.error(string, null);
    }

    private IStatus error(String string, Throwable throwable) {
        return new Status(4, "org.eclipse.ui", 0, string, throwable);
    }

    private IContainer getActualTarget(IResource iResource) {
        if (this.getFeedbackEnabled() && (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2)) {
            return iResource.getParent();
        }
        if (iResource.getType() == 1) {
            return iResource.getParent();
        }
        return (IContainer)iResource;
    }

    private IResource[] getSelectedResources() {
        ArrayList arrayList = new ArrayList();
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                IAdaptable iAdaptable;
                IResource iResource;
                if (e instanceof IResource) {
                    arrayList.add(e);
                    continue;
                }
                if (!(e instanceof IAdaptable) || (iResource = (IResource)(iAdaptable = (IAdaptable)e).getAdapter(IResource.class)) == null) continue;
                arrayList.add(iResource);
            }
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    private IStatus info(String string) {
        return new Status(1, "org.eclipse.ui", 0, string, null);
    }

    private void mergeStatus(MultiStatus multiStatus, IStatus iStatus) {
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
        }
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_ok, null);
    }

    private void openError(IStatus iStatus) {
        if (iStatus == null) {
            return;
        }
        String string = ResourceNavigatorMessages.DropAdapter_title;
        int n = 6;
        if (!iStatus.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
            return;
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)iStatus.getMessage(), null, (IStatus)iStatusArray[0], (int)n);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
    }

    public boolean performDrop(Object object) {
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || object == null) {
            return false;
        }
        boolean bl = false;
        IStatus iStatus = null;
        IResource[] iResourceArray = null;
        TransferData transferData = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = (IResource[])object;
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            iStatus = this.performFileDrop(object);
            bl = iStatus.isOK();
        } else {
            bl = PHPNavigatorDropAdapter.super.performDrop(object);
        }
        if (iResourceArray != null && iResourceArray.length > 0) {
            iStatus = this.getCurrentOperation() == 1 ? this.performResourceCopy(this.getShell(), iResourceArray) : this.performResourceMove(iResourceArray);
        }
        this.openError(iStatus);
        return bl;
    }

    private IStatus performFileDrop(Object object) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        final IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        final String[] stringArray = (String[])object;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                PHPNavigatorDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(PHPNavigatorDropAdapter.this.getShell());
                copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
            }
        });
        return multiStatus;
    }

    private IStatus performResourceCopy(Shell shell, IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(shell);
        copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        return multiStatus;
    }

    private IStatus performResourceMove(IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.getShell(), ResourceNavigatorMessages.MoveResourceAction_title, ResourceNavigatorMessages.MoveResourceAction_checkMoveMessage);
        iResourceArray = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
        this.fReorgMoveAction.setSources(iResourceArray);
        this.fReorgMoveAction.setTarget(iContainer);
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.fReorgMoveAction.setSelection((IStructuredSelection)((StructuredSelection)iSelection));
            this.fReorgMoveAction.runDrop((IStructuredSelection)iSelection);
        }
        return multiStatus;
    }

    private IStatus validateTarget(Object object, TransferData transferData) {
        if (!(object instanceof IResource)) {
            return this.info(ResourceNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource iResource = (IResource)object;
        if (!iResource.isAccessible()) {
            return this.error(ResourceNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer.getType() == 8) {
            return this.error(ResourceNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String string = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (iResourceArray.length == 0) {
                string = ResourceNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object object2 = this.lastValidOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                string = object2.validateDestination(iContainer, iResourceArray);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(transferData);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            string = copyFilesAndFoldersOperation.validateImportDestination(iContainer, stringArray);
        }
        if (string != null) {
            return this.error(string);
        }
        return this.ok();
    }
}

