/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public class Element {
    public final ElementType type;
    public final String name;
    public final Element parent;
    public final int index;
    public int length;

    Element(Element element, ElementType elementType, String string, int n) {
        this(element, elementType, string, n, 0);
    }

    Element(Element element, ElementType elementType, String string, int n, int n2) {
        this.type = elementType;
        this.name = string;
        this.parent = element;
        this.index = n2;
        this.length = n;
    }

    public Element(ElementType elementType, String string, int n) {
        this(null, elementType, string, n);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        assert (object instanceof Element);
        Element element = (Element)object;
        if (this.parent == null ? element.parent != null : !this.parent.equals(element.parent)) {
            return false;
        }
        if (this.name == null ? element.name != null : !this.name.equals(element.name)) {
            return false;
        }
        if (this.type == null) {
            if (element.type != null) {
                return false;
            }
        } else {
            if (!this.type.equals((Object)element.type)) {
                return false;
            }
            if (this.index != element.index) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Element ");
        stringBuffer.append(this.type.toString());
        stringBuffer.append(": ");
        stringBuffer.append(", Name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(", Parent: ");
        stringBuffer.append(this.parent);
        stringBuffer.append(", Index: ");
        stringBuffer.append(this.index);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class ElementFactory {
        private ElementFactory() {
        }

        public static Element createDocElement(Element element, PHPDocBlock pHPDocBlock) {
            return new Element(element, ElementType.DOC, element.name, pHPDocBlock.getEndPosition() - pHPDocBlock.getStartPosition());
        }

        public static Element createFileElement(PHPFileData pHPFileData) {
            return ElementFactory.createElement(null, (PHPCodeData)pHPFileData, 0);
        }

        public static Element createElement(Element element, PHPCodeData pHPCodeData, int n) {
            Element element2 = null;
            if (pHPCodeData instanceof PHPFileData) {
                element2 = new Element(ElementType.FILE, pHPCodeData.getName(), 0);
            } else if (pHPCodeData instanceof PHPClassData) {
                element2 = new Element(element, ElementType.CLASS, pHPCodeData.getName(), ElementFactory.getLength(pHPCodeData), n);
            } else if (pHPCodeData instanceof PHPFunctionData) {
                element2 = element.type == ElementType.FILE ? new Element(element, ElementType.FUNCTION, pHPCodeData.getName(), ElementFactory.getLength(pHPCodeData), n) : new Element(element, ElementType.METHOD, pHPCodeData.getName(), ElementFactory.getLength(pHPCodeData), n);
            } else if (pHPCodeData instanceof PHPClassVarData) {
                element2 = new Element(element, ElementType.FIELD, pHPCodeData.getName(), ElementFactory.getLength(pHPCodeData), n);
            } else if (pHPCodeData instanceof PHPClassConstData) {
                assert (element != null);
                element2 = new Element(element, ElementType.CONSTANT, pHPCodeData.getName(), ElementFactory.getLength(pHPCodeData), n);
            } else {
                throw new IllegalStateException("Internal Error: CodeData is not supported as folded element");
            }
            return element2;
        }

        private static final int getLength(PHPCodeData pHPCodeData) {
            int n = pHPCodeData.getUserData().getEndPosition() - pHPCodeData.getUserData().getStartPosition();
            return n < 0 ? 0 : n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        FILE("File"),
        CLASS("Class"),
        FUNCTION("Function"),
        METHOD("Method"),
        FIELD("Field"),
        CONSTANT("Constant"),
        DOC("PHP Doc");

        private final String elementTypeName;

        private ElementType(String string2) {
            this.elementTypeName = string2;
        }

        public String toString() {
            return this.elementTypeName;
        }
    }
}

