/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;

public class PHPThread
extends PHPDebugElement
implements IThread {
    private static final Expression[] NO_VARIABLES = new Expression[0];
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;

    public PHPThread(PHPDebugTarget pHPDebugTarget) {
        super(pHPDebugTarget);
    }

    protected IStackFrame[] getStackFrames(boolean bl) throws DebugException {
        if (this.isSuspended()) {
            return ((PHPDebugTarget)this.getDebugTarget()).getStackFrames(bl);
        }
        return new IStackFrame[0];
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.getStackFrames(false);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    protected IStackFrame getTopStackFrame(boolean bl) throws DebugException {
        IStackFrame[] iStackFrameArray = this.getStackFrames(bl);
        if (iStackFrameArray.length > 0) {
            return iStackFrameArray[0];
        }
        return null;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.getTopStackFrame(false);
    }

    public String getName() throws DebugException {
        return "PHPthread";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.fBreakpoints = iBreakpointArray;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void setStepping(boolean bl) {
        this.fStepping = bl;
    }

    public Object getError() {
        return null;
    }

    public Expression[] getStackVariables() throws DebugException {
        IStackFrame iStackFrame = this.getTopStackFrame(true);
        if (iStackFrame == null) {
            return NO_VARIABLES;
        }
        Expression[] expressionArray = ((PHPStackFrame)iStackFrame).getStackVariables();
        if (expressionArray == null) {
            return NO_VARIABLES;
        }
        return expressionArray;
    }
}

