/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPSearchEngine {
    private static Pattern RELATIVE_PATH_PATTERN = Pattern.compile("\\.\\.?[/\\\\].*");

    public static Result<?, ?> find(String string, String string2, String string3, IProject iProject) {
        Object[] objectArray;
        if (string == null || string2 == null || string3 == null || iProject == null) {
            throw new NullPointerException("Parameters can't be null");
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(file);
        }
        if (RELATIVE_PATH_PATTERN.matcher(string).matches()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(string2, string);
        }
        Object[] objectArray2 = objectArray = PHPSearchEngine.buildIncludePath(iProject);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource;
            Object object;
            Object object2 = objectArray2[n2];
            if (object2 instanceof IContainer) {
                object = (IContainer)object2;
                iResource = object.findMember(string);
                if (iResource instanceof IFile) {
                    return new ResourceResult((IFile)iResource);
                }
            } else if (object2 instanceof IIncludePathEntry) {
                IResource iResource2;
                File file2;
                object = (IIncludePathEntry)object2;
                iResource = object.getPath();
                if (object.getEntryKind() == 1) {
                    if (object.getContentKind() != 2 && (file = new File(file2 = iResource.toFile(), string)).exists()) {
                        return new IncludedFileResult((IIncludePathEntry)object, file);
                    }
                } else if (object.getEntryKind() == 4) {
                    iResource = IncludePathVariableManager.instance().resolveVariablePath(iResource.toString());
                    file2 = iResource.toFile();
                    file = new File(file2, string);
                    if (file.exists()) {
                        return new IncludedFileResult((IIncludePathEntry)object, file);
                    }
                } else if (object.getEntryKind() == 2 && (file2 = (IProject)object.getResource()).isAccessible() && (iResource2 = file2.findMember(string)) instanceof IFile) {
                    return new ResourceResult((IFile)iResource2);
                }
            }
            ++n2;
        }
        return PHPSearchEngine.searchExternalOrWorkspaceFile(string3, string);
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(String string, String string2) {
        Object object;
        IResource iResource;
        IResource iResource2 = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        if (iResource2 instanceof IContainer && (iResource = (object = (IContainer)iResource2).findMember(string2)) instanceof IFile) {
            return new ResourceResult((IFile)iResource);
        }
        object = new File(string);
        if (((File)object).isDirectory()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(new File((File)object, string2));
        }
        return null;
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(File file) {
        if (file.exists()) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (iFile != null) {
                return new ResourceResult(iFile);
            }
            if (file.exists()) {
                return new ExternalFileResult(file);
            }
        }
        return null;
    }

    public static Object[] buildIncludePath(IProject iProject) {
        HashSet<Object> hashSet = new HashSet<Object>();
        PHPSearchEngine.buildIncludePath(iProject, hashSet);
        return hashSet.toArray();
    }

    public static void buildIncludePath(IProject iProject, Set<Object> set) {
        if (set.contains(iProject)) {
            return;
        }
        if (!iProject.isAccessible() || !iProject.isOpen()) {
            return;
        }
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        if (pHPProjectOptions != null) {
            IIncludePathEntry[] iIncludePathEntryArray;
            IIncludePathEntry[] iIncludePathEntryArray2 = iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
            int n = iIncludePathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray2[n2];
                set.add(iIncludePathEntry);
                ++n2;
            }
        }
        set.add(iProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExternalFileResult
    extends Result<Object, File> {
        public ExternalFileResult(File file) {
            super(file.getParentFile(), file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludedFileResult
    extends Result<IIncludePathEntry, File> {
        public IncludedFileResult(IIncludePathEntry iIncludePathEntry, File file) {
            super(iIncludePathEntry, file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceResult
    extends Result<Object, IFile> {
        public ResourceResult(IFile iFile) {
            super(iFile.getParent(), iFile);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Result<T, S> {
        private T container;
        private S file;

        public Result(T t, S s) {
            this.container = t;
            this.file = s;
        }

        public T getContainer() {
            return this.container;
        }

        public S getFile() {
            return this.file;
        }
    }
}

