/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.preferences;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.Key;
import org.eclipse.ui.preferences.IWorkingCopyManager;

public class XMLPreferencesWriter {
    public static final char DELIMITER = '\u0005';

    public static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            XMLPreferencesWriter.appendEscapedChar(stringBuffer, string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
        String string = XMLPreferencesWriter.getReplacement(c);
        if (string != null) {
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(c);
        }
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    private static void write(StringBuffer stringBuffer, HashMap hashMap) {
        Set set = hashMap.keySet();
        for (String string : set) {
            stringBuffer.append("<");
            stringBuffer.append(string);
            stringBuffer.append(">");
            Object v = hashMap.get(string);
            if (v instanceof HashMap) {
                XMLPreferencesWriter.write(stringBuffer, (HashMap)v);
            } else if (v != null) {
                stringBuffer.append(XMLPreferencesWriter.getEscaped(v.toString()));
            } else {
                stringBuffer.append("");
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
    }

    public static void write(Key key, IXMLPreferencesStorable[] iXMLPreferencesStorableArray, ProjectScope projectScope, IWorkingCopyManager iWorkingCopyManager) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(stringBuffer, iXMLPreferencesStorableArray);
        key.setStoredValue((IScopeContext)projectScope, stringBuffer.toString(), iWorkingCopyManager);
    }

    public static void write(IPreferenceStore iPreferenceStore, String string, IXMLPreferencesStorable iXMLPreferencesStorable) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.write(stringBuffer, iXMLPreferencesStorable.storeToMap());
        iPreferenceStore.setValue(string, stringBuffer.toString());
    }

    public static void write(IPreferenceStore iPreferenceStore, String string, IXMLPreferencesStorable[] iXMLPreferencesStorableArray) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(stringBuffer, iXMLPreferencesStorableArray);
        iPreferenceStore.setValue(string, stringBuffer.toString());
    }

    public static void write(Preferences preferences, String string, IXMLPreferencesStorable[] iXMLPreferencesStorableArray) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(stringBuffer, iXMLPreferencesStorableArray);
        preferences.setValue(string, stringBuffer.toString());
    }

    public static void write(Preferences preferences, String string, IXMLPreferencesStorable iXMLPreferencesStorable) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.write(stringBuffer, iXMLPreferencesStorable.storeToMap());
        preferences.setValue(string, stringBuffer.toString());
    }

    private static void appendDelimitedString(StringBuffer stringBuffer, IXMLPreferencesStorable[] iXMLPreferencesStorableArray) {
        if (iXMLPreferencesStorableArray != null) {
            int n = 0;
            while (n < iXMLPreferencesStorableArray.length) {
                XMLPreferencesWriter.write(stringBuffer, iXMLPreferencesStorableArray[n].storeToMap());
                if (n < iXMLPreferencesStorableArray.length - 1) {
                    stringBuffer.append('\u0005');
                }
                ++n;
            }
        }
    }

    public static String storableElementsToString(IXMLPreferencesStorable[] iXMLPreferencesStorableArray) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLPreferencesWriter.appendDelimitedString(stringBuffer, iXMLPreferencesStorableArray);
        return stringBuffer.toString();
    }
}

