/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceInit;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.osgi.framework.BundleContext;

public class PHPDebugPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.core";
    public static final int INTERNAL_ERROR = 10001;
    public static final int INTERNAL_WARNING = 10002;
    private static PHPDebugPlugin plugin;
    private static final String BASE_URL = "http://localhost";
    private static String fPHPDebugPerspective;
    private static String fDebugPerspective;
    private static boolean fIsSupportingMultipleDebugAllPages;
    private boolean fInitialAutoRemoveLaunches;
    private static boolean fLaunchChangedAutoRemoveLaunches;
    public static final boolean DebugPHP;

    static {
        fPHPDebugPerspective = "org.eclipse.php.debug.ui.PHPDebugPerspective";
        fDebugPerspective = "org.eclipse.debug.ui.DebugPerspective";
        fIsSupportingMultipleDebugAllPages = true;
        String value = Platform.getDebugOption((String)"org.eclipse.php.debug.core/debug");
        DebugPHP = value != null && value.equalsIgnoreCase("true");
    }

    public PHPDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        this.fInitialAutoRemoveLaunches = preferenceStore.getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)new AutoRemoveOldLaunchesListener());
        Activator.getDefault();
        PHPDebugPlugin.createDefaultPHPServer();
        XDebugPreferenceInit.setDefaults();
        DaemonPlugin.getDefault().startDaemons(null);
        XDebugLaunchListener.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        XDebugLaunchListener.shutdown();
        DBGpProxyHandler.instance.unregister();
        this.savePluginPreferences();
        super.stop(context);
        plugin = null;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", this.fInitialAutoRemoveLaunches);
    }

    public static PHPDebugPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static boolean getStopAtFirstLine() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
    }

    public static boolean getDebugInfoOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO);
    }

    public static boolean getOpenInBrowserOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER);
    }

    public static String getCurrentDebuggerId() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
    }

    public static boolean getAutoSaveDirtyOption() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
        if (saveDirty == null) {
            return true;
        }
        return Boolean.valueOf(saveDirty);
    }

    public static boolean getOpenDebugViewsOption() {
        Preferences prefs = PHPDebugPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS);
    }

    public static int getDebugPort(String debuggerId) {
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerId);
        if (debuggerConfiguration == null) {
            return -1;
        }
        return debuggerConfiguration.getPort();
    }

    public static String getDebugHosts() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String hosts = prefs.getString(PHPDebugCorePreferenceNames.CLIENT_IP);
        return hosts.replaceAll(",", "%2C");
    }

    public static String getWorkspaceDefaultServer() {
        Preferences serverPrefs = Activator.getDefault().getPluginPreferences();
        return serverPrefs.getString("defaultPHPServer");
    }

    public static void createDefaultPHPServer() {
        if (ServersManager.getServers().length == 0) {
            Server server = ServersManager.createServer((String)"Default PHP Web Server", (String)BASE_URL);
            ServersManager.save();
            ServersManager.setDefaultServer(null, (Server)server);
        }
    }

    public static void log(IStatus status) {
        try {
            PHPDebugPlugin.getDefault().getLog().log(status);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable e) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, "PHPDebug plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static void logWarningMessage(String message) {
        PHPDebugPlugin.log((IStatus)new Status(2, ID, 10002, message, null));
    }

    public static boolean supportsMultipleDebugAllPages() {
        return fIsSupportingMultipleDebugAllPages;
    }

    public static void setMultipleDebugAllPages(boolean supported) {
        fIsSupportingMultipleDebugAllPages = supported;
    }

    public static void setDisableAutoRemoveLaunches(boolean disableAutoRemoveLaunches) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches") == disableAutoRemoveLaunches) {
            fLaunchChangedAutoRemoveLaunches = true;
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", !disableAutoRemoveLaunches);
        }
    }

    public boolean getInitialAutoRemoveLaunches() {
        return this.fInitialAutoRemoveLaunches;
    }

    private class AutoRemoveOldLaunchesListener
    implements IPropertyChangeListener {
        private AutoRemoveOldLaunchesListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.debug.ui.auto_remove_old_launches".equals(event.getProperty())) {
                if (fLaunchChangedAutoRemoveLaunches) {
                    fLaunchChangedAutoRemoveLaunches = false;
                } else {
                    PHPDebugPlugin.this.fInitialAutoRemoveLaunches = (Boolean)event.getNewValue();
                }
            }
        }
    }
}

