/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;

public class BreakpointSet {
    private IProject fProject;
    private ArrayList<String> fDirectories;
    private ArrayList<IProject> fProjects;

    public BreakpointSet(IProject project, boolean isPHPCGI) {
        IIncludePathEntry[] entries;
        PHPProjectOptions options;
        this.fProject = project;
        this.fDirectories = new ArrayList();
        this.fProjects = new ArrayList();
        if (project != null && (options = PHPProjectOptions.forProject((IProject)project)) != null && (entries = options.readRawIncludePath()) != null) {
            IIncludePathEntry[] iIncludePathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String variableName;
                File file;
                IPath path;
                IIncludePathEntry element = iIncludePathEntryArray[n2];
                if (element.getEntryKind() == 1) {
                    path = element.getPath();
                    File file2 = new File(path.toOSString());
                    this.fDirectories.add(file2.getAbsolutePath());
                } else if (element.getEntryKind() == 2) {
                    IResource includeResource = element.getResource();
                    if (includeResource instanceof IContainer) {
                        this.fProjects.add(includeResource.getProject());
                    }
                } else if (element.getEntryKind() == 4 && (file = this.getVariableFile(variableName = (path = element.getPath()).toOSString())) != null && file.isDirectory()) {
                    this.fDirectories.add(file.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (this.fProject == null) {
            return true;
        }
        PHPLineBreakpoint bp = (PHPLineBreakpoint)breakpoint;
        IMarker marker = bp.getMarker();
        IResource resource = null;
        if (breakpoint instanceof PHPRunToLineBreakpoint) {
            return true;
        }
        resource = marker.getResource();
        if (resource instanceof IWorkspaceRoot) {
            String includeBasedir;
            String storageType = marker.getAttribute("org.eclipse.php.debug.core.Storage_Type", "");
            if (storageType.equals("org.eclipse.php.debug.core.Include") && !"".equals(includeBasedir = marker.getAttribute("org.eclipse.php.debug.core.Include_Path_Basedir", ""))) {
                Object[] dirs;
                Object[] objectArray = dirs = this.fDirectories.toArray();
                int n = dirs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (includeBasedir.equals(element)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return true;
        }
        IProject project = resource.getProject();
        if (this.fProject.equals((Object)project) || this.fProject.equals((Object)PHPWorkspaceModelManager.getDefaultPHPProjectModel().getProject())) {
            return true;
        }
        return this.fProjects.contains(project);
    }

    private File getVariableFile(String variableName) {
        IPath path;
        int index = variableName.indexOf(47);
        String extention = "";
        if (index != -1) {
            if (index + 1 < variableName.length()) {
                extention = variableName.substring(index + 1);
            }
            variableName = variableName.substring(0, index);
        }
        if ((path = PHPProjectOptions.getIncludePathVariable((String)variableName)) == null) {
            return null;
        }
        path = path.append(extention);
        return path.toFile();
    }
}

