/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static String base64CharSetSequence = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static byte[] valToBase64CharTable = base64CharSetSequence.getBytes();
    private static int[] base64ToValTable = new int[256];

    static {
        int i = 0;
        while (i < 256) {
            Base64.base64ToValTable[i] = -1;
            ++i;
        }
        i = 0;
        while (i < valToBase64CharTable.length) {
            Base64.base64ToValTable[Base64.valToBase64CharTable[i]] = i;
            ++i;
        }
    }

    private static int[] three2four(byte a, byte b, byte c) {
        int[] result = new int[]{a >>> 2 & 0x3F, (a & 3) << 4 | (b & 0xF0) >>> 4, (b & 0xF) << 2 | (c & 0xC0) >>> 6, c & 0x3F};
        return result;
    }

    public static String encode(String input, String sessionEncoding) {
        byte[] byteInput = null;
        String strResult = null;
        try {
            byteInput = input.getBytes(sessionEncoding);
            byte[] result = Base64.encode(byteInput);
            strResult = new String(result, sessionEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byteInput = input.getBytes();
            byte[] result = Base64.encode(byteInput);
            strResult = new String(result);
        }
        return strResult;
    }

    public static String decode(String input, String sessionEncoding) {
        byte[] byteInput = null;
        String strResult = null;
        try {
            byteInput = input.getBytes(sessionEncoding);
            byte[] result = Base64.decode(byteInput);
            strResult = new String(result, sessionEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byteInput = input.getBytes();
            byte[] result = Base64.decode(byteInput);
            strResult = new String(result);
        }
        return strResult;
    }

    private static byte[] encode(byte[] input) {
        int outsize = input.length / 3 * 4;
        if (input.length % 3 != 0) {
            outsize += 4;
        }
        byte[] encoded = new byte[outsize];
        byte zero = 0;
        byte[] data = new byte[4];
        int pos = 0;
        int i = 0;
        while (i < input.length) {
            switch (input.length - i) {
                case 1: {
                    int[] result = Base64.three2four(input[i], zero, zero);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[64];
                    data[3] = valToBase64CharTable[64];
                    break;
                }
                case 2: {
                    int[] result = Base64.three2four(input[i], input[i + 1], zero);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[result[2]];
                    data[3] = valToBase64CharTable[64];
                    break;
                }
                default: {
                    int[] result = Base64.three2four(input[i], input[i + 1], input[i + 2]);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[result[2]];
                    data[3] = valToBase64CharTable[result[3]];
                }
            }
            int j = 0;
            while (j < 4) {
                encoded[pos] = data[j];
                ++pos;
                ++j;
            }
            i += 3;
        }
        return encoded;
    }

    private static byte[] decode(byte[] input) {
        int outsize = input.length;
        outsize = outsize / 4 * 3;
        if (input[input.length - 1] == valToBase64CharTable[64]) {
            --outsize;
        }
        if (input[input.length - 2] == valToBase64CharTable[64]) {
            --outsize;
        }
        int cfr_ignored_0 = input.length % 4;
        byte[] decoded = new byte[outsize];
        int j = 0;
        while (j < outsize) {
            decoded[j] = 63;
            ++j;
        }
        int[] base64set = new int[4];
        int pos = 0;
        int decodepos = 0;
        int i = 0;
        while (i < input.length) {
            if (base64ToValTable[input[i]] != -1) {
                base64set[decodepos] = base64ToValTable[input[i]];
                if (++decodepos == 4) {
                    decodepos = 0;
                    decoded[pos] = (byte)(base64set[0] << 2 | (base64set[1] & 0x30) >>> 4);
                    if (base64set[2] != 64) {
                        decoded[pos + 1] = (byte)((base64set[1] & 0xF) << 4 | (base64set[2] & 0x3C) >>> 2);
                        if (base64set[3] != 64) {
                            decoded[pos + 2] = (byte)((base64set[2] & 3) << 6 | base64set[3]);
                        }
                    }
                    pos += 3;
                }
            }
            ++i;
        }
        return decoded;
    }
}

