/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.StatusLineMessageTimerManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPRunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        String errorMessage = null;
        if (input == null) {
            errorMessage = PHPDebugUIMessages.PHPRunToLineAdapter_0;
        } else {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = PHPDebugUIMessages.PHPRunToLineAdapter_1;
            } else {
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = 0;
                try {
                    lineNumber = document.getLineOfOffset(textSelection.getOffset()) + 1;
                }
                catch (BadLocationException badLocationException) {}
                int validLinePosition = PHPBreakpointProvider.getValidPosition(document, lineNumber);
                if (validLinePosition < 0) {
                    StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                    return;
                }
                int validLineNumber = 0;
                try {
                    validLineNumber = document.getLineOfOffset(validLinePosition) + 1;
                    if (validLineNumber != lineNumber) {
                        StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                    return;
                }
                if (lineNumber > 0) {
                    if (this.getValidPosition(document, lineNumber) != -1) {
                        IDebugTarget debugTarget;
                        if (target instanceof IAdaptable && (debugTarget = (IDebugTarget)((IAdaptable)target).getAdapter(IDebugTarget.class)) != null) {
                            IFile file = this.getFile(textEditor);
                            if (debugTarget instanceof PHPDebugTarget) {
                                PHPRunToLineBreakpoint breakpoint = new PHPRunToLineBreakpoint(file, lineNumber);
                                RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                                handler.run((IProgressMonitor)new NullProgressMonitor());
                            } else if (debugTarget instanceof DBGpTarget) {
                                DBGpTarget t = (DBGpTarget)debugTarget;
                                t.runToLine(file, lineNumber);
                            }
                            return;
                        }
                    } else {
                        errorMessage = PHPDebugUIMessages.PHPRunToLineAdapter_2;
                    }
                } else {
                    errorMessage = PHPDebugUIMessages.PHPRunToLineAdapter_2;
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, PHPDebugUIPlugin.getID(), 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof PHPDebugElement || target instanceof DBGpElement) {
            return target.isSuspended();
        }
        return false;
    }

    protected IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput input = textEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof IURIEditorInput) {
            String filePath = new Path(((IURIEditorInput)input).getURI().getPath()).toOSString();
            IFile result = ExternalFilesRegistry.getInstance().getFileEntry(filePath);
            if (result == null && filePath.length() > 0 && filePath.charAt(0) == '/') {
                return ExternalFilesRegistry.getInstance().getFileEntry(filePath.substring(1));
            }
            return result;
        }
        if (input instanceof NonExistingPHPFileEditorInput) {
            return (IFile)((NonExistingPHPFileEditorInput)input).getAdapter(IResource.class);
        }
        return null;
    }

    private int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                startOffset = line.getOffset();
                endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
                if (lineText.equals("") || lineText.equals("<%") || lineText.equals("%>") || lineText.equals("<?php") || lineText.equals("?>") || lineText.trim().startsWith("//")) {
                    result = -1;
                } else {
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        String type = partitions[i].getType();
                        if (PHPStructuredTextPartitioner.isPHPPartitionType((String)type)) {
                            result = partitions[i].getOffset();
                        }
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }
}

