/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.filesystem.FileStoreFactory;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class PHPFileLink
implements IHyperlink {
    private Object fFile;
    private int fFileOffset;
    private int fFileLength;
    private int fFileLineNumber;

    public PHPFileLink(Object file, int fileOffset, int fileLength, int fileLineNumber) {
        this.fFile = file;
        this.fFileOffset = fileOffset;
        this.fFileLength = fileLength;
        this.fFileLineNumber = fileLineNumber;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void linkActivated() {
        IEditorPart editorPart = null;
        Object domModel = null;
        try {
            if (this.fFile instanceof File) {
                FileStoreEditorInput editorInput = new FileStoreEditorInput((IFileStore)new LocalFile((File)this.fFile));
                editorPart = EditorUtility.openInEditor((IEditorInput)editorInput, (String)"org.eclipse.php.editor", (boolean)false);
            } else if (this.fFile instanceof ExternalFileWrapper) {
                ExternalFileWrapper externalFile = (ExternalFileWrapper)this.fFile;
                IPath externalPath = externalFile.getFullPath();
                if (externalPath.segmentCount() > 1 && externalPath.segment(externalPath.segmentCount() - 2).equalsIgnoreCase("Untitled_Documents")) {
                    NonExistingPHPFileEditorInput editorInput = new NonExistingPHPFileEditorInput(externalPath);
                    editorPart = EditorUtility.openInEditor((IEditorInput)editorInput, (String)"org.eclipse.php.untitledPhpEditor", (boolean)false);
                } else {
                    FileStoreEditorInput editorInput = new FileStoreEditorInput(FileStoreFactory.createFileStore((File)new File(externalFile.getFullPath().toOSString())));
                    editorPart = EditorUtility.openInEditor((IEditorInput)editorInput, (String)"org.eclipse.php.editor", (boolean)false);
                }
            } else {
                editorPart = this.fFile instanceof IFile ? EditorUtility.openInEditor((IEditorInput)new FileEditorInput((IFile)this.fFile), (String)"org.eclipse.php.editor", (boolean)false) : EditorUtility.openInEditor((Object)this.fFile, (boolean)false);
            }
            if (editorPart != null && this.fFileLineNumber > 0 && editorPart instanceof StructuredTextEditor && this.fFileOffset < 0) {
                IRegion region = ((StructuredTextEditor)editorPart).getTextViewer().getDocument().getLineInformation(this.fFileLineNumber - 1);
                this.fFileOffset = region.getOffset();
                this.fFileLength = region.getLength();
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
            if (editorPart == null) return;
            EditorUtility.revealInEditor(editorPart, (int)this.fFileOffset, (int)this.fFileLength);
            if (domModel == null) return;
            domModel.releaseFromRead();
            return;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return;
        }
        catch (NullPointerException npe) {
            Logger.logException(npe);
            if (editorPart == null) return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            EditorUtility.revealInEditor(editorPart, (int)this.fFileOffset, (int)this.fFileLength);
            if (domModel == null) return;
            domModel.releaseFromRead();
            return;
        }
        {
            finally {
                if (editorPart != null) {
                    EditorUtility.revealInEditor(editorPart, (int)this.fFileOffset, (int)this.fFileLength);
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
        }
        if (editorPart == null) return;
        EditorUtility.revealInEditor((IEditorPart)editorPart, (int)this.fFileOffset, (int)this.fFileLength);
        if (domModel == null) return;
        domModel.releaseFromRead();
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

