/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.preferences.phps.InstalledPHPsBlock;
import org.eclipse.php.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PHPsPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private InstalledPHPsBlock fPHPBlock;

    public PHPsPreferencePage() {
        this.setTitle(PHPDebugUIMessages.PHPsPreferencePage_1);
        this.setDescription(PHPDebugUIMessages.PHPsPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    protected Preferences getModelPreferences() {
        return PHPProjectPreferences.getModelPreferences();
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fPHPBlock = new InstalledPHPsBlock();
        this.fPHPBlock.createControl(ancestor);
        Control control = this.fPHPBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fPHPBlock.restoreColumnSettings(PHPDebugUIPlugin.getDefault().getDialogSettings(), PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        this.initDefaultPHP();
        this.applyDialogFont(ancestor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.php.help.php_preferences");
        return ancestor;
    }

    public boolean performOk() {
        IDialogSettings settings = PHPDebugUIPlugin.getDefault().getDialogSettings();
        this.fPHPBlock.saveColumnSettings(settings, PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        this.fPHPBlock.commitChanges();
        return super.performOk();
    }

    private void verifyDefaultPHP(PHPexeItem php) {
        boolean exist;
        if (php != null && !(exist = php.getExecutable().exists())) {
            this.fPHPBlock.removePHPs(new PHPexeItem[]{php});
            ErrorDialog.openError((Shell)this.getControl().getShell(), (String)PHPDebugUIMessages.PHPsPreferencePage_1, (String)PHPDebugUIMessages.PHPsPreferencePage_10, (IStatus)new Status(4, "org.eclipse.php.debug.ui", 10001, PHPDebugUIMessages.PHPsPreferencePage_11, null));
            return;
        }
    }

    private void initDefaultPHP() {
        PHPexeItem realDefault = PHPexes.getInstance().getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
        if (realDefault != null) {
            PHPexeItem[] phps;
            PHPexeItem[] pHPexeItemArray = phps = this.fPHPBlock.getPHPs();
            int n = phps.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem fakePHP = pHPexeItemArray[n2];
                if (fakePHP.equals((Object)realDefault)) {
                    this.verifyDefaultPHP(fakePHP);
                    break;
                }
                ++n2;
            }
        }
    }
}

