/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;

public class ContainerContentProvider
extends StandardPHPElementContentProvider {
    static final String[] FILTERS = new String[]{".settings", ".project", ".projectOptions", ".cache", ".classpath"};

    protected Object[] getChildrenInternal(Object parentElement) {
        if (!this.exists(parentElement)) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof PHPWorkspaceModelManager) {
            return this.getPHPProjects((PHPWorkspaceModelManager)parentElement);
        }
        if (parentElement instanceof IProject) {
            return this.getProjectChildren((IProject)parentElement, FILTERS);
        }
        if (parentElement instanceof PHPProjectModel) {
            return this.getProjectChildren((PHPProjectModel)parentElement, FILTERS);
        }
        if (parentElement instanceof IFolder) {
            return this.getFolderChildren((IContainer)parentElement, FILTERS);
        }
        return NO_CHILDREN;
    }

    protected Object[] getFolderChildren(IContainer folder, String[] filterNames) {
        try {
            IResource[] members = folder.members();
            ArrayList<IResource> folderList = new ArrayList<IResource>();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                boolean filterOut = false;
                if (filterNames != null) {
                    int j = 0;
                    while (j < filterNames.length) {
                        if (filterNames[j].equals(member.getName())) {
                            filterOut = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!filterOut && member instanceof IFolder) {
                    folderList.add(member);
                }
                ++i;
            }
            return folderList.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }
}

