/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.FileDropAction;

public class IncludeDropAction
extends FileDropAction {
    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        if (!(targetEditor instanceof PHPStructuredEditor)) {
            return super.run(event, targetEditor);
        }
        PHPStructuredEditor phpEditor = (PHPStructuredEditor)targetEditor;
        final String[] fileNames = (String[])event.data;
        if (fileNames == null || fileNames.length == 0) {
            return false;
        }
        ArrayList<String> phpFileNames = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.length) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileNames[i]));
            PHPFileData fileData = null;
            fileData = file != null ? PHPWorkspaceModelManager.getInstance().getModelForFile(file, false) : PHPWorkspaceModelManager.getInstance().getModelForFile(fileNames[i], false);
            if (fileData != null) {
                phpFileNames.add(fileData.getName());
            }
            ++i;
        }
        if (phpFileNames.size() != 0 && this.insert(phpFileNames, phpEditor)) {
            return true;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EditorUtility.openFilesInEditor(Arrays.asList(fileNames));
            }
        });
        return true;
    }

    private static String getPartitionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion region = document.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        TextSequence statement = PHPTextSequenceUtilities.getStatement((int)offset, (IStructuredDocumentRegion)region, (boolean)false);
        if (statement == null) {
            return null;
        }
        String partitionType = TextSequenceUtilities.getTypeByAbsoluteOffset((TextSequence)statement, (int)offset);
        return partitionType;
    }

    protected boolean insert(List phpFiles, PHPStructuredEditor targetEditor) {
        String partitionType;
        ISelection selection = targetEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        boolean isPHPState = false;
        IStructuredDocument document = (IStructuredDocument)targetEditor.getDocumentProvider().getDocument((Object)targetEditor.getEditorInput());
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(document);
        if (!(model instanceof DOMModelForPHP)) {
            model.releaseFromRead();
            return false;
        }
        int line = document.getLineOfOffset(offset);
        int lineEndOffset = -1;
        try {
            IRegion lineInformation = document.getLineInformation(line);
            String lineString = document.get(lineInformation.getOffset(), lineInformation.getLength()).replaceAll("[\n\r]+", "");
            lineEndOffset = lineInformation.getOffset() + lineString.length();
        }
        catch (BadLocationException badLocationException) {}
        if (lineEndOffset > 0 && offset == lineEndOffset - 1 && document.getLength() >= offset) {
            ++offset;
        }
        boolean bl = isPHPState = PHPPartitionTypes.isPHPRegularState((String)(partitionType = IncludeDropAction.getPartitionType(document, offset))) || PHPPartitionTypes.isPHPQuotesState((String)partitionType);
        if (!isPHPState) {
            return false;
        }
        this.insert(phpFiles, document, offset, (DOMModelForPHP)model);
        model.releaseFromRead();
        return true;
    }

    private void insert(List phpFileNames, IStructuredDocument document, int insertionOffset, DOMModelForPHP model) {
        PHPFileData currentFileData = model.getFileData();
        IFile file = (IFile)PHPModelUtil.getResource((Object)currentFileData);
        boolean shrinkPaths = file != null && file.exists();
        IProject project = file.getProject();
        StringBuffer string = new StringBuffer();
        for (String fileName : phpFileNames) {
            if (shrinkPaths) {
                fileName = PHPModelUtil.getRelativeLocation((IProject)project, (String)fileName);
            }
            string.append(MessageFormat.format("include_once ''{0}'';", fileName));
            string.append(document.getLineDelimiter());
        }
        try {
            document.replace(insertionOffset, 0, string.toString());
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
    }
}

