/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AddDescriptionAction
implements IObjectActionDelegate {
    private PHPCodeData[] phpCodeData;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.phpCodeData == null) {
            return;
        }
        Arrays.sort(this.phpCodeData, new Comparator<PHPCodeData>(){

            @Override
            public int compare(PHPCodeData object1, PHPCodeData object2) {
                if (object1 == null || object1.getUserData() == null) {
                    if (object2 == null || object2.getUserData() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (object2 == null || object2.getUserData() == null) {
                    return -1;
                }
                return object1.getUserData().getStartPosition() - object2.getUserData().getStartPosition();
            }
        });
        int i = this.phpCodeData.length - 1;
        while (i >= 0) {
            PHPCodeData codeData = this.phpCodeData[i];
            if (codeData != null) {
                IEditorPart editorPart;
                IEditorInput input = EditorUtility.getEditorInput(codeData);
                IWorkbenchPage page = PHPUiPlugin.getActivePage();
                try {
                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.eclipse.php.editor");
                }
                catch (PartInitException e) {
                    Logger.logException(e);
                    return;
                }
                PHPStructuredEditor textEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editorPart);
                IEditorInput editorInput = editorPart.getEditorInput();
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
                if (codeData instanceof PHPFileData) {
                    this.handleFileDocBlock((PHPFileData)codeData, (IStructuredDocument)document);
                }
                PHPDocBlock docBlock = PHPDocTool.createPhpDoc((CodeData)codeData);
                int startPosition = this.getCodeDataOffset(codeData);
                String dockBlockText = this.insertDocBlock((CodeData)codeData, (IStructuredDocument)document, startPosition);
                if (dockBlockText == null) {
                    return;
                }
                String shortDescription = docBlock.getShortDescription();
                int shortDescriptionInnerOffset = dockBlockText.indexOf(shortDescription);
                int shortDescriptionStartOffset = startPosition + shortDescriptionInnerOffset;
                EditorUtility.revealInEditor((IEditorPart)textEditor, shortDescriptionStartOffset, shortDescription.length());
            }
            --i;
        }
    }

    private int getCodeDataOffset(PHPCodeData codeData) {
        if (codeData instanceof PHPFileData) {
            PHPBlock[] phpBlocks = ((PHPFileData)codeData).getPHPBlocks();
            return phpBlocks.length > 0 ? phpBlocks[0].getPHPStartTag().getEndPosition() : -1;
        }
        int dataOffset = codeData.getUserData().getStartPosition();
        return dataOffset;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.phpCodeData = new PHPCodeData[structuredSelection.size()];
        Iterator i = structuredSelection.iterator();
        int idx = 0;
        while (i.hasNext()) {
            this.phpCodeData[idx++] = (PHPCodeData)i.next();
        }
    }

    private void handleFileDocBlock(PHPFileData data, IStructuredDocument document) {
        IStructuredDocumentRegion sdRegion = document.getFirstStructuredDocumentRegion();
        IPhpScriptRegion phpScriptRegion = null;
        while (sdRegion != null) {
            ITextRegion region = sdRegion.getFirstRegion();
            if (region.getType() == "PHP_OPEN" && (region = sdRegion.getRegionAtCharacterOffset(region.getEnd())) != null && region.getType() == "PHP_CONTENT") {
                phpScriptRegion = (IPhpScriptRegion)region;
                break;
            }
            sdRegion = sdRegion.getNext();
        }
        if (phpScriptRegion != null) {
            try {
                ITextRegion textRegion = phpScriptRegion.getPhpToken(0);
                int offset = textRegion.getStart() + sdRegion.getStartOffset() + phpScriptRegion.getStart();
                if (textRegion.getType() == "PHP_CLASS") {
                    this.addClassBlock(document, data, offset);
                } else if (textRegion.getType() == "PHP_FUNCTION") {
                    this.addFunctionBlock(document, data, offset);
                } else if (textRegion.getType() == "PHP_STRING" && document.get(offset, textRegion.getLength()).trim().equalsIgnoreCase("define")) {
                    this.addConstantBlock(document, data, offset);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void addConstantBlock(IStructuredDocument document, PHPFileData data, int offset) {
        PHPConstantData[] constants = data.getConstants();
        if (constants.length > 0 && constants[0].getUserData().getStartPosition() == offset) {
            this.insertDocBlock((CodeData)constants[0], document, offset);
        }
    }

    private void addFunctionBlock(IStructuredDocument document, PHPFileData data, int offset) {
        PHPFunctionData[] functions = data.getFunctions();
        if (functions.length > 0 && functions[0].getUserData().getStartPosition() == offset) {
            this.insertDocBlock((CodeData)functions[0], document, offset);
        }
    }

    private void addClassBlock(IStructuredDocument document, PHPFileData data, int offset) {
        PHPClassData[] classes = data.getClasses();
        if (classes.length > 0 && classes[0].getUserData().getStartPosition() == offset) {
            this.insertDocBlock((CodeData)classes[0], document, offset);
        }
    }

    private String insertDocBlock(CodeData codeData, IStructuredDocument document, int offset) {
        PHPDocBlock docBlock = PHPDocTool.createPhpDoc(codeData);
        String dockBlockText = PHPDocBlockSerialezer.instance().createDocBlockText(document, docBlock, offset, true);
        try {
            document.replace(offset, 0, dockBlockText);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            dockBlockText = null;
        }
        return dockBlockText;
    }
}

