/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPElementLabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(PHPUIMessages.getString("CopyToClipboardAction_text"));
        this.setDescription(PHPUIMessages.getString("CopyToClipboardAction_desc"));
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
        ISharedImages workbenchImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
    }

    public void setAutoRepeatOnFailure(boolean autorepeatOnFailure) {
        this.fAutoRepeatOnFailure = autorepeatOnFailure;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public void selectionChanged(IStructuredSelection selection) {
        List elements = selection.toList();
        IResource[] resources = ActionUtils.getResources(elements);
        Object[] phpElements = ActionUtils.getPHPElements(elements);
        if (elements.size() != resources.length + phpElements.length) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.canEnable(resources, phpElements));
        }
    }

    public void run(IStructuredSelection selection) {
        List elements = selection.toList();
        try {
            IResource[] resources = ActionUtils.getResources(elements, true);
            Object[] phpElements = ActionUtils.getPHPElements(elements, true);
            if (elements.size() == resources.length + phpElements.length && this.canEnable(resources, phpElements)) {
                this.doRun(resources, phpElements);
            }
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
    }

    private void doRun(IResource[] resources, Object[] phpElements) throws CoreException {
        new ClipboardCopier(resources, phpElements, this.fClipboard, this.getShell(), this.fAutoRepeatOnFailure).copyToClipboard();
        if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
            this.fPasteAction.update(this.fPasteAction.getSelection());
        }
    }

    private boolean canEnable(IResource[] resources, Object[] phpElements) {
        if (resources.length + phpElements.length == 0) {
            return false;
        }
        return this.canCopyAllToClipboard(resources, phpElements);
    }

    private boolean canCopyAllToClipboard(IResource[] resources, Object[] phpElements) {
        int i = 0;
        while (i < resources.length) {
            if (!CopyToClipboardAction.canCopyToClipboard(resources[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < phpElements.length) {
            if (!CopyToClipboardAction.canCopyToClipboard(phpElements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canCopyToClipboard(Object element) {
        if (element == null) {
            return false;
        }
        if (!(element instanceof PHPCodeData) && !(element instanceof PHPProjectModel)) {
            return false;
        }
        return element instanceof PHPFileData;
    }

    private static boolean canCopyToClipboard(IResource resource) {
        return resource != null && resource.exists() && !resource.isPhantom() && resource.getType() != 8;
    }

    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final Object[] fPHPElements;
        private final Clipboard fClipboard;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] resources, Object[] phpElements, Clipboard clipboard, Shell shell, boolean autoRepeatOnFailure) {
            this.fResources = resources;
            this.fPHPElements = phpElements;
            this.fClipboard = clipboard;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = autoRepeatOnFailure;
        }

        public void copyToClipboard() throws CoreException {
            HashSet fileNames = new HashSet(this.fResources.length + this.fPHPElements.length);
            StringBuffer namesBuf = new StringBuffer();
            this.processResources(fileNames, namesBuf);
            this.processPHPElements(fileNames, namesBuf);
            String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
            this.copyToClipboard(this.fResources, fileNameArray, namesBuf.toString(), this.fPHPElements, 0);
        }

        private void copyToClipboard(IResource[] resources, String[] fileNames, String names, Object[] phpElements, int repeat) {
            block6: {
                try {
                    this.fClipboard.setContents(ClipboardCopier.createDataArray(resources, phpElements, fileNames, names), ClipboardCopier.createDataTypeArray(resources, phpElements, fileNames));
                }
                catch (SWTError e) {
                    if (e.code != 2002 || repeat >= 10) {
                        throw e;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)PHPUIMessages.getString("CopyToClipboardAction_4"), (String)PHPUIMessages.getString("CopyToClipboardAction_5"))) break block6;
                    this.copyToClipboard(resources, fileNames, names, phpElements, repeat + 1);
                }
            }
        }

        private void processResources(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fResources.length) {
                IResource resource = this.fResources[i];
                ClipboardCopier.addFileName(fileNames, resource);
                if (i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(resource));
                ++i;
            }
        }

        private void processPHPElements(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fPHPElements.length) {
                if (this.fPHPElements[i] instanceof PHPFileData) {
                    ClipboardCopier.addFileName(fileNames, PHPModelUtil.getResource((Object)this.fPHPElements[i]));
                }
                if (this.fResources.length > 0 || i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(this.fPHPElements[i]));
                ++i;
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] resources, Object[] phpElements, String[] fileNames) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(ResourceTransfer.getInstance());
            }
            if (phpElements.length != 0) {
                throw new RuntimeException(PHPUIMessages.getString("CopyToClipboardAction.0"));
            }
            if (fileNames.length != 0) {
                result.add(FileTransfer.getInstance());
            }
            result.add(TextTransfer.getInstance());
            return result.toArray(new Transfer[result.size()]);
        }

        private static Object[] createDataArray(IResource[] resources, Object[] phpElements, String[] fileNames, String names) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(resources);
            }
            if (phpElements.length != 0) {
                result.add(phpElements);
            }
            if (fileNames.length != 0) {
                result.add(fileNames);
            }
            result.add(names);
            return result.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new PHPElementLabelProvider(546);
        }

        private String getName(IResource resource) {
            return this.fLabelProvider.getText((Object)resource);
        }

        private String getName(Object phpElement) {
            return this.fLabelProvider.getText(phpElement);
        }

        private static void addFileNames(Set fileName, IResource[] resources) {
            int i = 0;
            while (i < resources.length) {
                ClipboardCopier.addFileName(fileName, resources[i]);
                ++i;
            }
        }

        private static void addFileName(Set fileName, IResource resource) {
            if (resource == null) {
                return;
            }
            IPath location = resource.getLocation();
            if (location != null) {
                fileName.add(location.toOSString());
            }
        }
    }
}

