/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.CopyToClipboardAction;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(PHPUIMessages.getString("CutAction_text"));
        this.fCopyToClipboardAction = new CopyToClipboardAction(site, clipboard, pasteAction);
        ISharedImages workbenchImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.update(this.getSelection());
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            if (!CutAction.containsOnlyElementsInsidePHPFiles(selection)) {
                this.setEnabled(false);
                return;
            }
            this.fCopyToClipboardAction.selectionChanged(selection);
            this.setEnabled(this.fCopyToClipboardAction.isEnabled() && ActionUtils.isDeleteAvailable(selection));
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsidePHPFiles(IStructuredSelection selection) {
        for (Object object : selection) {
            if (ActionUtils.isInsidePHPFile(object)) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        this.selectionChanged(selection);
        if (this.isEnabled()) {
            this.fCopyToClipboardAction.run(selection);
        }
    }
}

