/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.php.internal.ui.actions.PHPMoveProjectAction;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class MoveAction
extends SelectionDispatchAction {
    private static final String MOVE_ACTION_ID = "org.eclipse.php.ui.actions.Move";
    private PHPStructuredEditor fEditor;
    private IPHPActionDelegator fReorgMoveAction;
    private IStructuredSelection selectedResources;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.initMoveAction();
    }

    public MoveAction(PHPStructuredEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.initMoveAction();
    }

    private void initMoveAction() {
        this.fReorgMoveAction = PHPActionDelegatorRegistry.getActionDelegator(MOVE_ACTION_ID);
        this.setText(PHPUIMessages.getString("MoveAction_text"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_resource_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectedResources = null;
        if (selection != null && selection instanceof ITextSelection) {
            this.setEnabled(false);
            return;
        }
        if (!selection.isEmpty()) {
            if (ActionUtils.containsOnlyProjects(selection.toList())) {
                this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                return;
            }
            List elements = selection.toList();
            IResource[] resources = ActionUtils.getResources(elements);
            Object[] phpElements = ActionUtils.getPHPElements(elements, true);
            if (elements.size() != resources.length + phpElements.length) {
                this.setEnabled(false);
            } else {
                boolean enabled = true;
                int i = 0;
                while (i < phpElements.length) {
                    if (!(phpElements[i] instanceof PHPFileData)) {
                        enabled = false;
                    }
                    ++i;
                }
                if (enabled) {
                    ArrayList<IResource> list = new ArrayList<IResource>((Collection)Arrays.asList(resources));
                    int i2 = 0;
                    while (i2 < phpElements.length) {
                        IResource res;
                        if (phpElements[i2] instanceof PHPFileData && (res = PHPModelUtil.getResource((Object)phpElements[i2])) != null && res.exists()) {
                            list.add(PHPModelUtil.getResource((Object)phpElements[i2]));
                        }
                        ++i2;
                    }
                    if (list.size() == elements.size()) {
                        this.selectedResources = new StructuredSelection(list);
                        enabled = this.createWorkbenchAction(this.selectedResources).isEnabled();
                    }
                }
                this.setEnabled(enabled);
            }
        } else {
            this.selectedResources = StructuredSelection.EMPTY;
            this.setEnabled(false);
        }
        this.fReorgMoveAction.setSelection(this.selectedResources);
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection selection) {
        List list = selection.toList();
        PHPMoveProjectAction action = null;
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            action = new PHPMoveProjectAction(this.getShell());
            action.selectionChanged(selection);
        } else if (this.selectedResources != null) {
            action = new MoveResourceAction(this.getShell());
            action.selectionChanged(selection);
        }
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (this.isEnabled()) {
            this.fReorgMoveAction.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.tryReorgMove(selection)) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.getString("MoveAction_Move"), (String)PHPUIMessages.getString("MoveAction_select"));
    }

    private boolean tryReorgMove(ITextSelection selection) {
        PHPCodeData element = SelectionConverter.getElementAtOffset(this.fEditor);
        if (element == null) {
            return false;
        }
        StructuredSelection mockStructuredSelection = new StructuredSelection((Object)element);
        this.selectionChanged((IStructuredSelection)mockStructuredSelection);
        if (!this.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)mockStructuredSelection);
        return true;
    }

    public void update(ISelection selection) {
        super.update(selection);
    }
}

