/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPElementLabelProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws PartInitException {
        TreeItem item;
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof PHPCodeData) {
            EditorUtility.revealInEditor(part, (PHPCodeData)element);
        }
        if (element instanceof TreeItem && (item = (TreeItem)element).getData() instanceof PHPCodeData) {
            EditorUtility.revealInEditor(part, (PHPCodeData)item.getData());
        }
    }

    public static PHPCodeData selectPHPElement(PHPCodeData[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = 1106;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new PHPElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof PHPCodeData) {
                    return (PHPCodeData)current;
                }
                ++i;
            }
        }
        return null;
    }
}

