/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.OpenPhpElementDialog;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class OpenPhpElementAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        Shell parent = PHPUiPlugin.getActiveWorkbenchShell();
        OpenPhpElementDialog dialog = new OpenPhpElementDialog(parent);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        PHPCodeData codeData = dialog.getSelectedElement();
        this.openEditor(codeData);
    }

    protected void openEditor(PHPCodeData codeData) {
        try {
            IEditorPart part = EditorUtility.openInEditor(codeData);
            EditorUtility.revealInEditor(part, codeData);
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PHPUIMessages.getString("OpenTypeAction_errorTitle"), PHPUIMessages.getString("OpenTypeAction_errorMessage"));
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

