/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.CommentHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class RemoveBlockCommentHandler
extends CommentHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (this.isMoreThanOneContextBlockSelected(document, textSelection)) {
                org.eclipse.wst.xml.ui.internal.handlers.RemoveBlockCommentHandler removeBlockCommentHandlerWST = new org.eclipse.wst.xml.ui.internal.handlers.RemoveBlockCommentHandler();
                return removeBlockCommentHandlerWST.execute(event);
            }
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset();
                IStructuredDocument sDoc = (IStructuredDocument)document;
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                boolean isJavaScriptRegion = false;
                if (textRegion instanceof ForeignRegion) {
                    boolean bl = isJavaScriptRegion = textRegion.getType() == "BLOCK_TEXT";
                }
                if (textRegion.getType() == "PHP_CONTENT" || isJavaScriptRegion) {
                    this.processAction(textEditor, document, textSelection);
                } else {
                    org.eclipse.wst.xml.ui.internal.handlers.RemoveBlockCommentHandler removeBlockCommentHandlerWST = new org.eclipse.wst.xml.ui.internal.handlers.RemoveBlockCommentHandler();
                    return removeBlockCommentHandlerWST.execute(event);
                }
            }
        }
        return null;
    }

    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        int selectionOffset = textSelection.getOffset();
        int selectionLength = textSelection.getLength();
        if (textSelection.getLength() == 0) {
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                model.beginRecording((Object)this, PHPUIMessages.getString("RemoveBlockComment_tooltip"));
                model.aboutToChangeModel();
                try {
                    this.removeOpenCloseComments(document, selectionOffset, selectionLength);
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }
}

