/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.php.internal.ui.actions.RenamePHPElementAction;
import org.eclipse.php.internal.ui.actions.RenameResourceAction;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.actions.IRenamePHPElementActionFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class RenameAction
extends SelectionDispatchAction {
    private static final String RENAME_ELEMENT_ACTION_ID = "org.eclipse.php.ui.actions.RenameElement";
    private RenamePHPElementAction fRenamePHPElement;
    private RenameResourceAction fRenameResource;
    private PHPStructuredEditor fEditor;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("RenameAction_text"));
        IRenamePHPElementActionFactory actionDelegatorFactory = PHPActionDelegatorRegistry.getActionDelegatorFactory(RENAME_ELEMENT_ACTION_ID);
        if (actionDelegatorFactory == null) {
            this.fRenamePHPElement = new RenamePHPElementAction(site);
            this.fRenamePHPElement.setText(this.getText());
        } else {
            this.fRenamePHPElement = actionDelegatorFactory.createRenameAction(site);
            this.fRenamePHPElement.setText(this.getText());
        }
        this.fRenameResource = new RenameResourceAction(site);
        this.fRenameResource.setText(this.getText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
    }

    public RenameAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        IRenamePHPElementActionFactory actionDelegatorFactory = PHPActionDelegatorRegistry.getActionDelegatorFactory(RENAME_ELEMENT_ACTION_ID);
        if (actionDelegatorFactory == null) {
            this.fRenamePHPElement = new RenamePHPElementAction(editor);
            this.fRenamePHPElement.setText(this.getText());
        } else {
            this.fRenamePHPElement = actionDelegatorFactory.createRenameAction(editor);
            this.fRenamePHPElement.setText(this.getText());
        }
        this.fRenameResource = new RenameResourceAction((IWorkbenchSite)editor.getSite());
        this.fRenameResource.setText(this.getText());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenamePHPElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        this.fRenamePHPElement.update(selection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenamePHPElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenamePHPElement.isEnabled();
    }

    public void run(IStructuredSelection selection) {
        boolean isFile = ActionUtils.containsOnly(selection.toList(), PHPFileData.class);
        if (!isFile && this.fRenamePHPElement.isEnabled()) {
            this.fRenamePHPElement.run(selection);
            return;
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            if (isFile) {
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    arrayList.add(PHPModelUtil.getResource(iter.next()));
                }
                selection = new StructuredSelection(arrayList);
            }
            this.fRenameResource.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.fRenamePHPElement.canRun()) {
            this.fRenamePHPElement.run(selection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.getString("RenameAction_rename"), (String)PHPUIMessages.getString("RenameAction_unavailable"));
        }
    }
}

