/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenamePHPElementAction
extends SelectionDispatchAction {
    protected PHPStructuredEditor fEditor;

    public RenamePHPElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenamePHPElementAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenamePHPElementAction.canEnable(selection));
                return;
            }
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        PHPCodeData element = RenamePHPElementAction.getPHPElement(selection);
        if (element == null) {
            return false;
        }
        return RenamePHPElementAction.isRenameAvailable(element);
    }

    private static PHPCodeData getPHPElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof PHPCodeData)) {
            return null;
        }
        return (PHPCodeData)first;
    }

    public void run(IStructuredSelection selection) {
        PHPCodeData element = RenamePHPElementAction.getPHPElement(selection);
        if (element == null) {
            super.run(selection);
            return;
        }
        try {
            this.run(element);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, PHPUIMessages.getString("RenamePHPElementAction_name"), PHPUIMessages.getString("RenamePHPElementAction_exception"));
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void run(ITextSelection selection) {
        try {
            PHPCodeData element = this.getPHPElement();
            if (element != null && RenamePHPElementAction.isRenameAvailable(element)) {
                this.run(element);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, PHPUIMessages.getString("RenamePHPElementAction_name"), PHPUIMessages.getString("RenamePHPElementAction_exception"));
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.getString("RenamePHPElementAction_name"), (String)PHPUIMessages.getString("RenamePHPElementAction_not_available"));
    }

    public boolean canRun() {
        PHPCodeData element = this.getPHPElement();
        if (element == null) {
            return false;
        }
        try {
            return RenamePHPElementAction.isRenameAvailable(element);
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
            return false;
        }
    }

    private PHPCodeData getPHPElement() {
        PHPCodeData[] elements = SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), PHPUIMessages.getString("RenamePHPElementAction_name"));
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(PHPCodeData element) throws CoreException {
        if (!ActionUtils.isProcessable(this.getShell(), element)) {
            return;
        }
        throw new RuntimeException(PHPUIMessages.getString("RenamePHPElementAction.0"));
    }

    private static boolean isRenameAvailable(PHPCodeData element) throws CoreException {
        return false;
    }
}

