/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;

public class RenameResourceAction
extends SelectionDispatchAction {
    TreeViewer treeViewer;

    public RenameResourceAction(IWorkbenchSite site) {
        super(site);
        ViewSite viewSite;
        IWorkbenchPart part;
        if (site instanceof ViewSite && (part = (viewSite = (ViewSite)site).getPart()) instanceof ExplorerPart) {
            ExplorerPart explorer = (ExplorerPart)part;
            this.treeViewer = explorer.getViewer();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.setEnabled(true);
            return;
        }
        if (selection.size() != 1) {
            this.setEnabled(false);
            return;
        }
        Object object = selection.toArray()[0];
        if (object instanceof PHPFileData || object instanceof IResource) {
            IResource res = PHPModelUtil.getResource((Object)object);
            if (res != null && res.exists()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            return;
        }
        this.setEnabled(false);
    }

    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        if (!ActionUtils.isProcessable(this.getShell(), resource)) {
            return;
        }
        if (!ActionUtils.isRenameAvailable(resource)) {
            return;
        }
        this.createWorkbenchAction(selection).run();
    }

    private ResourceNavigatorRenameAction createWorkbenchAction(IStructuredSelection selection) {
        PHPResourceNavigatorRenameAction action = new PHPResourceNavigatorRenameAction(this.getShell(), this.treeViewer);
        action.selectionChanged(selection);
        return action;
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof PHPCodeData && !(first instanceof PHPFileData)) {
            return null;
        }
        if (!((first = PHPModelUtil.getResource((Object)first)) instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPResourceNavigatorRenameAction
    extends ResourceNavigatorRenameAction {
        public PHPResourceNavigatorRenameAction(Shell shell, TreeViewer treeViewer) {
            super(shell, treeViewer);
        }

        protected void runWithNewPath(IPath path, IResource resource) {
            IUndoableOperation operation = this.createOperation(path, resource);
            try {
                TriggeredOperations triggeredOperations = new TriggeredOperations(operation, PlatformUI.getWorkbench().getOperationSupport().getOperationHistory());
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)triggeredOperations, (IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter((Shell)RenameResourceAction.this.getShell()));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CoreException) {
                    Logger.logException(e.getCause());
                }
                Logger.logException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRunWithNewPath(final IPath path, final IResource resource, final Map<Integer, IBreakpoint> breakpoints, final Map<Integer, Map<String, Object>> breakpointAttributes) {
            final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            try {
                PHPResourceNavigatorRenameAction pHPResourceNavigatorRenameAction = this;
                synchronized (pHPResourceNavigatorRenameAction) {
                    IMarker[] markers;
                    IMarker[] iMarkerArray = markers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
                        Integer line = (Integer)marker.getAttribute("lineNumber");
                        if (breakpoint != null) {
                            breakpoints.put(line, breakpoint);
                            breakpointAttributes.put(line, breakpoint.getMarker().getAttributes());
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            super.runWithNewPath(path, resource);
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            WorkspaceJob createMarker = new WorkspaceJob("Creating markers"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (resource == null || 2 == resource.getType() || 4 == resource.getType()) {
                            return Status.CANCEL_STATUS;
                        }
                        IFile oldFile = workspace.getRoot().getFile(resource.getFullPath());
                        if (oldFile.isAccessible()) {
                            return Status.CANCEL_STATUS;
                        }
                        IResource file = workspace.getRoot().findMember(path);
                        if (file == null) {
                            return Status.CANCEL_STATUS;
                        }
                        if (file.getType() != 1) {
                            return Status.CANCEL_STATUS;
                        }
                        for (Integer line : breakpoints.keySet()) {
                            Map oldAttributesMap = (Map)breakpointAttributes.get(line);
                            IMarker newMarker = file.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                            String oldMessge = (String)oldAttributesMap.get("message");
                            if (oldMessge != null) {
                                oldAttributesMap.put("message", oldMessge.replaceFirst(resource.getName(), path.lastSegment()));
                            }
                            newMarker.setAttributes(oldAttributesMap);
                            IBreakpoint breakpoint = (IBreakpoint)breakpoints.get(line);
                            breakpoint.setMarker(newMarker);
                            breakpointManager.addBreakpoint(breakpoint);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            createMarker.setRule((ISchedulingRule)workspace.getRoot());
            createMarker.setSystem(true);
            createMarker.schedule(1000L);
        }

        protected IUndoableOperation createOperation(final IPath path, final IResource resource) {
            AbstractOperation operation = new AbstractOperation("Advanced rename"){
                private IPath oldPath;
                private final Map<Integer, IBreakpoint> breakpoints;
                private final Map<Integer, Map<String, Object>> breakpointAttributes;
                {
                    super($anonymous0);
                    this.oldPath = iResource.getFullPath();
                    this.breakpoints = new HashMap<Integer, IBreakpoint>(6);
                    this.breakpointAttributes = new HashMap<Integer, Map<String, Object>>(6);
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(path, resource, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath());
                    PHPResourceNavigatorRenameAction.this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)newResource));
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(path, newResource, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    PHPResourceNavigatorRenameAction.this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)newResource));
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(this.oldPath, newResource, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }
            };
            return operation;
        }
    }
}

