/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class DocBlockAutoEditStrategy
implements IAutoEditStrategy {
    private static final String lineStart = "* ";
    private static final IPreferenceStore store = PHPCorePlugin.getDefault().getPreferenceStore();
    private static final PreferencesSupport preferencesSupport = new PreferencesSupport("org.eclipse.php.core", store);

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (TypingPreferences.closePhpdoc && command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
            this.autoEditAfterNewLine((IStructuredDocument)document, command);
        }
    }

    private void autoEditAfterNewLine(IStructuredDocument document, DocumentCommand command) {
        try {
            Matcher m;
            IRegion lineInfo = document.getLineInformationOfOffset(command.offset);
            int startOffset = lineInfo.getOffset();
            String line = document.get(startOffset, lineInfo.getLength());
            String blanks = this.getBlanks(line);
            String trimedLine = line.trim();
            boolean isFirstLine = false;
            boolean isDocBlock = true;
            int docStart = trimedLine.indexOf("/*");
            if (docStart != -1) {
                if (command.offset + command.length < startOffset + docStart + 2) {
                    return;
                }
                isFirstLine = true;
                if (trimedLine.indexOf("/**") != docStart) {
                    isDocBlock = false;
                }
            }
            if ((m = Pattern.compile("/\\*.*\\*/").matcher(trimedLine)).find()) {
                return;
            }
            if (isFirstLine) {
                int placeCaretAt;
                blanks = String.valueOf(blanks) + ' ';
                command.text = String.valueOf(command.text) + blanks;
                int startIndex = line.indexOf("/*");
                String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(startOffset + startIndex - 1));
                if ((partitionType == "org.eclipse.php.PHP_DEFAULT" || partitionType == "org.eclipse.php.PHP_DOC" || partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (placeCaretAt = this.handleDocBlockStart(document, command, blanks, isDocBlock)) != -1) {
                    document.replace(command.offset, command.length, command.text);
                    command.offset = placeCaretAt;
                    command.length = 0;
                    command.text = "";
                    document.getUndoManager().disableUndoManagement();
                    document.replace(command.offset, command.length, command.text);
                    document.getUndoManager().enableUndoManagement();
                }
                return;
            }
            boolean lastLint = document.get(startOffset, command.offset - startOffset).endsWith("*/");
            if (!lastLint && trimedLine.length() > 0 && trimedLine.charAt(0) == '*') {
                command.text = String.valueOf(command.text) + blanks + lineStart;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private String getBlanks(String line) {
        int start = line.indexOf("/*");
        if (start < 0) {
            start = line.indexOf("*");
        }
        if (start >= 0) {
            StringBuffer blanks = new StringBuffer(start);
            int i = 0;
            while (i < start) {
                if (line.charAt(i) == '\t') {
                    blanks.append('\t');
                } else {
                    blanks.append(' ');
                }
                ++i;
            }
            return blanks.toString();
        }
        return " ";
    }

    /*
     * Unable to fully structure code
     */
    private int handleDocBlockStart(IStructuredDocument document, DocumentCommand command, String blanks, boolean isDocBlock) {
        block12: {
            block11: {
                block10: {
                    rvPosition = 0;
                    lineInfo = document.getLineInformationOfOffset(command.offset);
                    lineStart = lineInfo.getOffset();
                    line = document.get(lineStart, command.offset - lineStart);
                    m = isDocBlock != false ? Pattern.compile("\\/\\*\\*").matcher(line) : Pattern.compile("\\/\\*").matcher(line);
                    m.find();
                    commentStart = line.substring(m.start(), m.end());
                    commentStartLength = commentStart.length();
                    command.text = String.valueOf(command.text) + "* ";
                    rvPosition = command.offset + command.text.length();
                    selectionEnd = command.offset + command.length;
                    if (!this.isInsideExistingDocBlock(document, selectionEnd)) break block10;
lbl15:
                    // 2 sources

                    while (true) {
                        document.getUndoManager().enableUndoManagement();
                        return -1;
                    }
                }
                lineContent = line.substring(line.indexOf(commentStart) + commentStartLength).trim();
                rvPosition = (lineStart += line.indexOf(commentStart)) + commentStartLength + command.text.length();
                lineEnd = selectionEnd;
                if (selectionEnd < lineInfo.getOffset() + lineInfo.getLength()) {
                    lineInfo = document.getLineInformationOfOffset(selectionEnd);
                }
                if (!isDocBlock || !TypingPreferences.addDocTags) break block11;
                document.replace(lineStart + 3, lineEnd - lineStart - 3, "");
                command.offset = lineEnd = lineStart + 3;
                if (lineContent.equals("")) {
                    lineContent = null;
                }
                editorModel = (DOMModelForPHP)StructuredModelManager.getModelManager().getModelForRead(document);
                fileData = editorModel.getFileData();
                editorModel.releaseFromRead();
                fileData = this.updateFileData(document, lineStart, lineEnd, fileData);
                stub = this.getDocBlockStub(fileData, document, lineStart, lineContent, lineEnd);
                if (stub == null) ** GOTO lbl50
                command.text = stub.substring(3);
                if (lineContent == null) {
                    editorPart = PHPUiPlugin.getActivePage().getActiveEditor();
                    textEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editorPart);
                    Display.getDefault().asyncExec((Runnable)new SelectText(command.offset + command.text.indexOf("E"), 25, (ITextEditor)textEditor));
                    ** continue;
                }
                var21_21 = rvPosition + lineContent.length();
                document.getUndoManager().enableUndoManagement();
                return var21_21;
            }
            try {
                try {
                    command.length += command.offset - lineStart - commentStartLength;
                    command.offset = lineStart + commentStartLength;
lbl50:
                    // 2 sources

                    lineStart += commentStartLength;
                    if (lineContent == null || lineContent.equals("")) break block12;
                    command.text = String.valueOf(command.text) + lineContent;
                    rvPosition = lineStart + command.text.length();
                }
                catch (BadLocationException e) {
                    Logger.logException(e);
                    document.getUndoManager().enableUndoManagement();
                }
            }
            catch (Throwable var20_22) {
                document.getUndoManager().enableUndoManagement();
                throw var20_22;
            }
        }
        document.getUndoManager().enableUndoManagement();
        command.text = String.valueOf(command.text) + document.getLineDelimiter() + blanks + "*/";
        return rvPosition;
    }

    private PHPFileData updateFileData(IStructuredDocument document, int commentStart, int commentEnd, PHPFileData fileData) {
        String fileName = fileData.getName();
        Pattern[] tasks = new Pattern[]{};
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
        IProject project = null;
        if (file != null) {
            project = file.getProject();
            tasks = TaskPatternsProvider.getInstance().getPatternsForProject(project);
        }
        boolean useAspTags = UseAspTagsHandler.useAspTagsAsPhp(project);
        String version = preferencesSupport.getPreferencesValue("phpVersion", "php5", project);
        fileData = PHPFileDataUtilities.getFileData((Reader)new SkippedTextDocumentReader((IDocument)document, commentStart, commentEnd - commentStart), (String)fileData.getName(), (long)0L, (String)version, (Pattern[])tasks, (boolean)useAspTags);
        return fileData;
    }

    private boolean isInsideExistingDocBlock(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        boolean firstRegion = true;
        while (sdRegion != null) {
            int textLength;
            String text = sdRegion.getText();
            if (firstRegion) {
                firstRegion = false;
                text = text.substring(offset - sdRegion.getStartOffset());
            }
            if ((textLength = text.length()) == 0) {
                sdRegion = sdRegion.getNext();
                continue;
            }
            char c1 = text.charAt(0);
            int i = 1;
            while (i < textLength) {
                char c2 = text.charAt(i);
                if (c1 == '*' && c2 == '/') {
                    return true;
                }
                if (c1 == '/' && c2 == '*') {
                    return false;
                }
                c1 = c2;
                ++i;
            }
            sdRegion = sdRegion.getNext();
        }
        return false;
    }

    private String getDocBlockStub(PHPFileData fileData, IStructuredDocument document, int offset, String shortDescription, int skippedAreaEndoffset) {
        if (fileData == null) {
            return null;
        }
        PHPCodeData codeData = this.getClosestCodeData(document, fileData, offset, skippedAreaEndoffset);
        if (codeData == null) {
            return null;
        }
        PHPDocBlock docBlock = PHPDocTool.createPhpDoc((CodeData)codeData, shortDescription);
        return PHPDocBlockSerialezer.instance().createDocBlockText(document, docBlock, offset, false);
    }

    private PHPCodeData getClosestCodeData(IStructuredDocument document, PHPFileData fileData, int offset, int skippedAreaEndoffset) {
        PHPClassData closestCodeData = null;
        int closestCodeDataOffset = document.getLength();
        PHPClassData[] classes = fileData.getClasses();
        int i = 0;
        while (i < classes.length) {
            PHPClassData classData = classes[i];
            int startOffset = classData.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = classData.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return this.getClosestCodeDataFromClass(document, classData, offset, skippedAreaEndoffset);
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = classData;
            }
            ++i;
        }
        PHPFunctionData[] functions = fileData.getFunctions();
        int i2 = 0;
        while (i2 < functions.length) {
            PHPFunctionData functionData = functions[i2];
            int startOffset = functionData.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = functionData.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return null;
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = functionData;
            }
            ++i2;
        }
        PHPConstantData[] constants = fileData.getConstants();
        int i3 = 0;
        while (i3 < constants.length) {
            PHPConstantData constant = constants[i3];
            int startOffset = constant.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = constant.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return null;
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = constant;
            }
            ++i3;
        }
        if (closestCodeData != null && this.isNoCodeBetween(document, skippedAreaEndoffset, closestCodeDataOffset)) {
            return closestCodeData;
        }
        return null;
    }

    private PHPCodeData getClosestCodeDataFromClass(IStructuredDocument document, PHPClassData classData, int offset, int skippedAreaEndoffset) {
        PHPFunctionData closestCodeData = null;
        int closestCodeDataOffset = document.getLength();
        PHPFunctionData[] functions = classData.getFunctions();
        int i = 0;
        while (i < functions.length) {
            PHPFunctionData functionData = functions[i];
            int startOffset = functionData.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = functionData.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return null;
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = functionData;
            }
            ++i;
        }
        PHPClassConstData[] constants = classData.getConsts();
        int i2 = 0;
        while (i2 < constants.length) {
            PHPClassConstData constant = constants[i2];
            int startOffset = constant.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = constant.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return null;
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = constant;
            }
            ++i2;
        }
        PHPClassVarData[] vars = classData.getVars();
        int i3 = 0;
        while (i3 < vars.length) {
            PHPClassVarData var = vars[i3];
            int startOffset = var.getUserData().getStartPosition();
            if (startOffset < offset) {
                int endOffset = var.getUserData().getEndPosition();
                if (endOffset > offset) {
                    return null;
                }
            } else if (startOffset < closestCodeDataOffset) {
                closestCodeDataOffset = startOffset;
                closestCodeData = var;
            }
            ++i3;
        }
        if (closestCodeData != null && this.isNoCodeBetween(document, skippedAreaEndoffset, closestCodeDataOffset)) {
            return closestCodeData;
        }
        return null;
    }

    private boolean isNoCodeBetween(IStructuredDocument document, int offset, int endOffset) {
        char[] chars = null;
        try {
            chars = document.get(offset, endOffset - offset).toCharArray();
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
        if (chars == null) {
            return true;
        }
        boolean inLineComment = false;
        int index = 0;
        while (index < chars.length) {
            char curr = chars[index];
            if (inLineComment) {
                if (curr == '\n' || curr == '\r') {
                    inLineComment = false;
                }
            } else if (!Character.isWhitespace(curr)) {
                if (curr == '/' && index + 1 < chars.length && chars[index + 1] == '/') {
                    inLineComment = true;
                } else {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    private class SelectText
    implements Runnable {
        int offset;
        int length;
        ITextEditor textEditor;

        public SelectText(int offset, int length, ITextEditor textEditor) {
            this.offset = offset;
            this.length = length;
            this.textEditor = textEditor;
        }

        public void run() {
            EditorUtility.revealInEditor((IEditorPart)this.textEditor, this.offset, this.length);
        }
    }

    private class SkippedTextDocumentReader
    extends Reader {
        private IDocument document = null;
        private int mark = 0;
        private int position = 0;
        private int skippedPosition;
        private int skippedLength;

        public SkippedTextDocumentReader(IDocument document, int skippedPosition, int skippedLength) {
            this.document = document;
            this.skippedPosition = skippedPosition;
            this.skippedLength = skippedLength;
        }

        public void close() throws IOException {
            this.document = null;
        }

        public void mark(int readAheadLimit) throws IOException {
            this.mark = this.position;
        }

        public boolean markSupported() {
            return true;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            char[] readChars;
            block9: {
                if (this.document == null) {
                    return -1;
                }
                readChars = null;
                try {
                    if (this.position < this.document.getLength()) break block9;
                    return -1;
                }
                catch (Exception e) {
                    throw new IOException("Exception while reading from IDocument: " + e);
                }
            }
            if (this.position < this.skippedPosition) {
                if (this.position + len >= this.skippedPosition) {
                    String s1 = this.document.get(this.position, this.skippedPosition - this.position);
                    String s2 = this.document.get(this.skippedPosition + this.skippedLength, len - (this.skippedPosition - this.position));
                    readChars = (String.valueOf(s1) + s2).toCharArray();
                }
            } else if (this.position <= this.skippedPosition + this.skippedLength) {
                this.position = this.skippedPosition + this.skippedLength;
            }
            if (readChars == null) {
                readChars = this.position + len > this.document.getLength() ? this.document.get(this.position, this.document.getLength() - this.position).toCharArray() : this.document.get(this.position, len).toCharArray();
            }
            System.arraycopy(readChars, 0, cbuf, off, readChars.length);
            this.position += readChars.length;
            return readChars.length;
        }

        public void reset() throws IOException {
            this.position = this.mark;
        }

        public void reset(int pos) throws IOException {
            this.position = pos;
        }

        public long skip(long n) throws IOException {
            if (this.document == null) {
                return 0L;
            }
            long skipped = n;
            if ((long)this.position + n > (long)this.document.getLength()) {
                skipped = this.document.getLength() - this.position;
                this.position = this.document.getLength();
            } else {
                this.position = (int)((long)this.position + n);
            }
            return skipped;
        }
    }
}

