/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveFilesDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class SaveFilesHandler {
    public static SaveFilesResult handle(IProject project, boolean autoSave, boolean promptAutoSave, IProgressMonitor monitor) {
        SaveFilesResult result = new SaveFilesResult();
        List dirtyEditors = SaveFilesHandler.getDirtyEditors(project);
        if (dirtyEditors == null || dirtyEditors.size() == 0) {
            result.setAccepted(true);
            return result;
        }
        if (!autoSave) {
            Display.getDefault().syncExec((Runnable)new SaveFilesDialogRunnable(dirtyEditors, result, promptAutoSave));
        } else {
            result.setAccepted(true);
            result.setSaved(dirtyEditors);
        }
        List editorsToSave = result.getSaved();
        if (editorsToSave.size() > 0) {
            Display.getDefault().syncExec((Runnable)new SaveFilesRunnable(editorsToSave, monitor));
        }
        if (monitor.isCanceled()) {
            result.setAccepted(false);
        }
        return result;
    }

    public static List getDirtyEditors(IProject project) {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFileEditorInput fileInput = (IFileEditorInput)input;
                        IFile file = fileInput.getFile();
                        if (project == null || file.getProject() == project) {
                            result.add(ep);
                        }
                    } else if (SaveFilesHandler.isExternalFileInput(project, input)) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private static boolean isExternalFileInput(IProject project, IEditorInput input) {
        return project == PHPWorkspaceModelManager.getDefaultPHPProjectModel().getProject() && input instanceof FileStoreEditorInput;
    }

    protected static class SaveFilesDialogRunnable
    implements Runnable {
        List dirtyEditors;
        SaveFilesResult result;
        boolean promptAutoSave;

        public SaveFilesDialogRunnable(List dirtyEditors, SaveFilesResult result, boolean promptAutoSave) {
            this.dirtyEditors = dirtyEditors;
            this.result = result;
            this.promptAutoSave = promptAutoSave;
        }

        public void run() {
            SaveFilesDialog sfDialog = new SaveFilesDialog(Display.getCurrent().getActiveShell(), this.dirtyEditors, this.result, this.promptAutoSave);
            if (sfDialog.open() == 0) {
                this.result.setAccepted(true);
                this.result.setSaved(Arrays.asList(sfDialog.getResult()));
            }
        }
    }

    public static class SaveFilesResult {
        boolean autoSave;
        boolean accepted;
        List saved = new ArrayList();

        public boolean isAutoSave() {
            return this.autoSave;
        }

        public void setAutoSave(boolean autoSave) {
            this.autoSave = autoSave;
        }

        public void setSaved(List saved) {
            this.saved = saved;
        }

        public void setAccepted(boolean accepted) {
            this.accepted = accepted;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public List getSaved() {
            return this.saved;
        }

        public SaveFilesResult() {
        }

        public SaveFilesResult(List saved, boolean accepted) {
            this();
            this.setSaved(saved);
            this.setAccepted(accepted);
        }

        public SaveFilesResult(List saved, boolean accepted, boolean autoSave) {
            this(saved, accepted);
            this.setAutoSave(autoSave);
            this.setAccepted(accepted);
        }
    }

    protected static class SaveFilesRunnable
    implements Runnable {
        List dirtyEditors;
        IProgressMonitor monitor;

        public SaveFilesRunnable(List dirtyEditors, IProgressMonitor monitor) {
            this.dirtyEditors = dirtyEditors;
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.beginTask(PHPUIMessages.getString("SaveFilesHandler.0"), this.dirtyEditors.size());
            Iterator i = this.dirtyEditors.iterator();
            while (i.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                ((IEditorPart)i.next()).doSave(this.monitor);
                this.monitor.worked(1);
            }
            this.monitor.done();
        }
    }
}

